// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_write.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_write(int fd, const void *src, int count)
{
	os_file_t*	fp		= NULL;
	os_msg_t	msg;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Access the file and validate the arguments.
		ret	= os_file_acquire(fd, &fp);

		if (ret)
		{
			if (ret > 0)
				ret	= -EIO;

			break;
		}

		if ((fp == NULL) || (src == NULL) || (count < 0))
		{
			ret	= -EINVAL;
			break;
		}

		if (count == 0)
		{
			ret	= 0;
			break;
		}

		if (fp->tx.ptr == NULL)
		{
			// There isn't a Tx buffer with which to transfer data.
			ret	= -ENOMEM;
			break;
		}

		// Initialize the message structure.

		if (count > (int) fp->tx.size)
			count	= (int) fp->tx.size;

		memset(&msg, 0, sizeof(msg));
		memcpy(fp->tx.ptr, src, count);
		msg.status			= OS_MSG_STS_PASS;
		msg.type			= OS_MSG_TYPE_WRITE;
		msg.u.write.dev_id	= fp->dev_id;
		msg.u.write.count	= count;

		// Send the request.
		ret	= os_msg_xfer(fp, 1, &msg);

		if (ret)
		{
			if (ret > 0)
				ret	= -EIO;

			break;
		}

		// Process the response.

		if (msg.processed == 0)
		{
			// The message was not procecessed for some reason.
			ret	= -EBADE;
			break;
		}

		switch (msg.status)
		{
			default:
			case OS_MSG_STS_MSG_TYPE:

				ret	= -EBADMSG;
				break;

			case OS_MSG_STS_FAIL:

				ret	= -EINVAL;
				break;

			case OS_MSG_STS_PASS:

				ret	= msg.ret;
				break;
		}

		break;
	}

	if (fp)
		os_file_release(fp);

	return(ret);
}


