// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_sem.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"




//*****************************************************************************
// returns err_no: 0 = ok, !=0 = error value
int os_sem_create(os_sem_t* sem)
{
	int	ret;

	ret	= os_sem_create_qty(sem, 1, 1);
	return(ret);
}



//*****************************************************************************
// returns err_no: 0 = ok, !=0 = error value
int os_sem_create_qty(os_sem_t* sem, int cap, int put)
{
	int	ret;

	if ((sem) && (cap > 0) && (put >= 0) && (put <= cap))
	{
		memset(sem, 0, sizeof(os_sem_t));
		sem->handle	= RtCreateSemaphore(NULL, put, cap, NULL);

		if (sem->handle)
			ret	= 0;
		else
			ret	= RtGetLastError();
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}



//*****************************************************************************
// returns err_no: 0 = ok, !=0 = error value
int os_sem_destroy(os_sem_t* sem)
{
	int	ret;

	if (sem == NULL)
	{
		ret	= -EINVAL;
	}
	else
	{
		if (sem->handle)
			RtCloseHandle(sem->handle);

		memset(sem, 0, sizeof(os_sem_t));
		ret	= 0;
	}

	return(ret);
}



//*****************************************************************************
// returns err_no: 0 = ok, !=0 = error value
int os_sem_lock(os_sem_t* sem)
{
	DWORD	dw;
	int		ret;

	if (sem == NULL)
	{
		ret	= -EINVAL;
	}
	else
	{
		dw	= RtWaitForSingleObject(sem->handle, INFINITE);
		ret	= (dw == WAIT_OBJECT_0) ? 0 : RtGetLastError();
	}

	return(ret);
}



//*****************************************************************************
// returns err_no: 0 = ok, !=0 = error value
int os_sem_unlock(os_sem_t* sem)
{
	int	ret;

	if ((sem == NULL) || (sem->handle == NULL))
	{
		ret	= -EINVAL;
	}
	else
	{
		RtReleaseSemaphore(sem->handle, 1, NULL);
		ret	= 0;
	}

	return(ret);
}


