// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_open.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_open(int index)
{
	os_file_t*	fp		= NULL;
	os_msg_t	msg;
	char		name[OS_RESOURCE_NAME_MAX_LEN];
	int			ret;

	for (;;)
	{
		// Validate the arguments.

		if ((index < -1) || (strlen(DEV_NAME) >= (sizeof(name) - 5)))
		{
			ret	= -EINVAL;
			break;
		}

		// Allocate a file structure.
		ret	= os_file_create(&fp);

		if (ret)
		{
			if (ret > 0)
				ret	= -EIO;

			break;
		}

		if (fp == NULL)
		{
			// This should never happen!
			ret	= -ENOMEM;
			break;
		}

		// Gain exclusive access so we can make changes.
		ret	= os_sem_lock(&fp->sem);

		if (ret)
		{
			if (ret > 0)
				ret	= -EIO;

			os_file_destroy(fp);
			break;
		}

		// Acquire the shared resources and all handles.
		sprintf(name, "%s.%d", DEV_NAME, index);
		ret	= os_res_acquire(fp, DEV_NAME, name);

		if (ret)
		{
			if (ret > 0)
				ret	= -EIO;

			os_res_release(fp);
			os_file_destroy(fp);
			break;
		}

		// Initialize the message structure.
		memset(&msg, 0, sizeof(os_msg_t));
		msg.status			= OS_MSG_STS_PASS;
		msg.type			= OS_MSG_TYPE_OPEN;
		msg.u.open.index	= index;

		// Send the request.
		ret	= os_msg_xfer(fp, 0, &msg);

		if (ret)
		{
			if (ret > 0)
				ret	= -EIO;

			os_res_release(fp);
			os_file_destroy(fp);
			break;
		}

		// Process the response.

		if (msg.processed == 0)
		{
			// The message was not procecessed for some reason.
			os_res_release(fp);
			os_file_destroy(fp);
			ret	= -EBADE;
			break;
		}

		switch (msg.status)
		{
			default:
			case OS_MSG_STS_MSG_TYPE:

				os_res_release(fp);
				os_file_destroy(fp);
				ret	= -EBADMSG;
				break;

			case OS_MSG_STS_FAIL:

				os_res_release(fp);
				os_file_destroy(fp);
				ret	= -EINVAL;
				break;

			case OS_MSG_STS_PASS:

				if (msg.ret)
				{
					os_res_release(fp);
					os_file_destroy(fp);
					ret	= -EIO;
					break;
				}

				fp->dev_id	= msg.u.open.dev_id;
				ret			= fp->fd;
				os_sem_unlock(&fp->sem);
				os_file_release(fp);
				break;
		}

		break;
	}

	return(ret);
}


