// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_msg.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
static int _msg_xfer(os_msg_set_t* set, os_msg_t* msg)
{
	int	ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if ((set == NULL) || (msg == NULL))
		{
			ret	= -EINVAL;
			break;
		}

		// 1. Lock the .xfer semaphore.
		ret	= os_sem_lock(&set->xfer);

		if (ret)
			break;

		// 2. Put the data into the message.
		memcpy(set->msg, msg, sizeof(os_msg_t));

		// 3. Unlock the .to_dev semaphore.
		ret	= os_sem_unlock(&set->to_dev);

		if (ret)
		{
			os_sem_unlock(&set->xfer);
			break;
		}

		// 4. Lock the .to_app semaphore.
		ret	= os_sem_lock(&set->to_app);

		if (ret)
		{
			os_sem_unlock(&set->xfer);
			break;
		}

		// 5. Pull the data from the message.
		memcpy(msg, set->msg, sizeof(os_msg_t));

		// 6. Unlock the .xfer semaphore.
		ret	= os_sem_unlock(&set->xfer);
		break;
	}

	return(ret);
}



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
static int _index_alloc(os_file_t* fp, u8* index)
{
	os_msg_t	msg;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if ((fp == NULL) || (index == NULL))
		{
			ret	= -EINVAL;
			break;
		}

		// Initialize the message structure.
		memset(&msg, 0, sizeof(msg));
		msg.status		= OS_MSG_STS_PASS;
		msg.type		= OS_MSG_TYPE_INDEX_ALLOC;
		ret				= _msg_xfer(&fp->primary.msg_set, &msg);

		if (ret)
			break;

		if (msg.processed == 0)
		{
			// The message was not procecessed for some reason.
			ret	= -EBADE;
			break;
		}

		// Process the response.

		switch (msg.status)
		{
			default:
			case OS_MSG_STS_MSG_TYPE:

				ret	= -EBADMSG;
				break;

			case OS_MSG_STS_FAIL:

				ret	= -EINVAL;
				break;

			case OS_MSG_STS_PASS:

				ret			= msg.ret;
				index[0]	= msg.u.index_alloc.index;
				break;
		}

		break;
	}

	return(ret);
}



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
static int _index_free(os_file_t* fp, u8 index)
{
	os_msg_t	msg;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if (fp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		// Initialize the message structure.
		memset(&msg, 0, sizeof(msg));
		msg.status				= OS_MSG_STS_PASS;
		msg.type				= OS_MSG_TYPE_INDEX_FREE;
		msg.u.index_free.index	= index;
		ret	= _msg_xfer(&fp->primary.msg_set, &msg);

		if (ret)
			break;

		// Process the response.

		switch (msg.status)
		{
			default:
			case OS_MSG_STS_MSG_TYPE:

				ret	= -EBADMSG;
				break;

			case OS_MSG_STS_PASS:

				ret	= msg.ret;
				break;
		}

		break;
	}

	return(ret);
}



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_msg_xfer(os_file_t* fp, int unlock, os_msg_t* msg)
{
	u8	index	= 0;
	int	ret;


	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if ((fp == NULL) || (msg == NULL))
		{
			ret	= -EINVAL;
			break;
		}

		// Acquire a free message list entry.
		ret	= _index_alloc(fp, &index);

		if (ret)
			break;

		if (index >= OS_MSG_LIST_SIZE)
		{
			_index_free(fp, index);
			ret	= -EINVAL;
			break;
		}

		// Transfer the message.
		ret	= _msg_xfer(&fp->msg_list[index], msg);
		_index_free(fp, index);
		break;
	}

	return(ret);
}


