// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_main.h $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#ifndef __OS_LIB_MAIN_H__
#define __OS_LIB_MAIN_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "os_common.h"
#include "os_lib.h"
#include "Rtapi.h"



// #defines *******************************************************************

#define	VERSION_LIB_OS					"1"
// 1	Initial release.

#define	SIZEOFARRAY(a)					(sizeof((a))/sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	HANDLE				handle;
	void*				ptr;
	u32					size;	// Size of driver's memory buffer.
} os_mem_t;

typedef struct
{
	HANDLE				handle;
} os_sem_t;

typedef struct
{
	os_sem_t			xfer;	// a named semaphore from the driver
	os_sem_t			to_dev;	// a named semaphore from the driver
	os_sem_t			to_app;	// a named semaphore from the driver
	os_msg_t*			msg;	// inside driver's named memory region
} os_msg_set_t;

typedef struct
{
	os_sem_t			sem;
	int					fd;
	int					users;	// the number of threads using the structure
	s32					dev_id;	// get via open, used in all other dev calls

	struct
	{
		os_mem_t		mem;
		os_main_mem_t*	ptr;
	} main_mem;

	struct
	{
		os_msg_set_t	msg_set;	// named semaphores for primary message access
		os_mem_t		mem;		// named memory for primary message access
	} primary;

	struct
	{
		os_mem_t		mem;		// message data memory
		os_msg_t*		msgs;		// message data memory
	} msg_mem;

	os_msg_set_t		msg_list[OS_MSG_LIST_SIZE];
	os_mem_t			rx;
	os_mem_t			tx;

} os_file_t;

typedef struct
{
	os_sem_t			sem;
	int					loaded;			// Has the DLL already been loaded?

	struct
	{
		os_file_t*		fp;
	} file_list[OS_MSG_LIST_SIZE];
} gsc_global_t;



// variables ******************************************************************

extern	gsc_global_t	gsc_global;



// prototypes *****************************************************************

int		os_close(int fd);
int		os_ioctl(int fd, int cmd, void* buf);
int		os_open(int index);
int		os_read(int fd, void *dst, int count);
int		os_write(int fd, const void *src, int count);

// All of the following are for internal use only.

int		os_file_acquire(int fd, os_file_t** fp);	// increment user count
int		os_file_create(os_file_t** fpp);
int		os_file_destroy(os_file_t* fp);
int		os_file_release(os_file_t* fp);				// decrement user count

int		os_msg_xfer(os_file_t* fp, int unlock, os_msg_t* msg);

int		os_res_acquire(os_file_t* fp, const char* base, const char* name);
void	os_res_release(os_file_t* fp);

int		os_sem_create(os_sem_t* sem);
int		os_sem_create_qty(os_sem_t* sem, int cap, int put);
int		os_sem_destroy(os_sem_t* sem);
int		os_sem_lock(os_sem_t* sem);
int		os_sem_unlock(os_sem_t* sem);



#endif
