// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_main.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



// variables ******************************************************************

gsc_global_t	gsc_global;



//*****************************************************************************
BOOL APIENTRY DllMain(HMODULE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
	int		i;
	BOOL	ret	= TRUE;

	// Calls here are serialized.

	switch (ul_reason_for_call)
	{
		case DLL_PROCESS_ATTACH:

				if (gsc_global.loaded == 0)
				{
					gsc_global.loaded		= 1;

					i	= os_sem_create(&gsc_global.sem);

					if (i)
						ret	= FALSE;
				}

		case DLL_PROCESS_DETACH:

				// We ignore this as there is little guarantee that we can
				// perform a graceful shutdown. We therefore let Windows clean
				// things up when the DLL is unloaded.

		case DLL_THREAD_ATTACH:
		case DLL_THREAD_DETACH:

				// We ignore these as we have no per thread processing.
				break;
	}

	return(ret);
}


