// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_ioctl.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_ioctl(int fd, int cmd, void* buf)
{
	os_file_t*	fp		= NULL;
	os_msg_t	msg;
	int			ret;
	int			size	= OS_IOCTL_SIZE_DECODE(cmd);

	for (;;)	// A convenience loop.
	{
		// Access the file.
		ret	= os_file_acquire(fd, &fp);

		if (ret)
			break;

		if (fp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		// Initialize the message structure.
		memset(&msg, 0, sizeof(msg));
		msg.status			= OS_MSG_STS_PASS;
		msg.type			= OS_MSG_TYPE_IOCTL;
		msg.u.ioctl.dev_id	= fp->dev_id;
		msg.u.ioctl.cmd		= cmd;

		if (size > sizeof(msg.u.ioctl.buf))
		{
			ret	= -ENOBUFS;
			break;
		}

		if (size == 0)
			msg.u.ioctl.val	= (u32) buf;
		else if (cmd & OS_IOCTL_DIR_WRITE)
			memcpy(msg.u.ioctl.buf, buf, size);

		// Send the request.
		ret	= os_msg_xfer(fp, 1, &msg);

		if (ret)
			break;

		// Process the response.

		if (msg.processed == 0)
		{
			// The message was not procecessed for some reason.
			ret	= -EBADE;
			break;
		}

		switch (msg.status)
		{
			default:
			case OS_MSG_STS_MSG_TYPE:

				ret	= -EBADMSG;
				break;

			case OS_MSG_STS_FAIL:

				ret	= -EINVAL;
				break;

			case OS_MSG_STS_PASS:

				ret	= msg.ret;

				if ((size) && (cmd & OS_IOCTL_DIR_READ))
					memcpy(buf, msg.u.ioctl.buf, size);

				break;
		}

		break;
	}

	if (fp)
		os_file_release(fp);

	return(ret);
}


