// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_file.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



//*****************************************************************************
// Returned: 0 = OK, <0 = -errno, >0 = GetLastResults()
int os_file_create(os_file_t** fpp)
{
	os_file_t*	fp	= NULL;
	int			i;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if (fpp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		fpp[0]	= NULL;

		// Allocate a structure.
		fp	= malloc(sizeof(os_file_t));

		if (fp == NULL)
		{
			ret	= -ENOMEM;
			break;
		}

		// Initialize the data structure.
		memset(fp, 0, sizeof(os_file_t));
		ret	= os_sem_create(&fp->sem);

		if (ret)
			break;

		ret	= os_sem_lock(&fp->sem);

		if (ret)
			break;

		// Acquire access to the file list.
		ret	= os_sem_lock(&gsc_global.sem);

		if (ret)
			break;

		// Locate an unused entry in the file list.
		ret	= -EINVAL;

		for (i = 0; i < SIZEOFARRAY(gsc_global.file_list); i++)
		{
			if (gsc_global.file_list[i].fp == NULL)
			{
				// Free the entry table entry.
				gsc_global.file_list[i].fp	= fp;
				fp->fd		= i + 100;
				fp->users	= 1;
				fpp[0]		= fp;
				fp			= NULL;
				ret			= 0;
				os_sem_unlock(&fpp[0]->sem);
				break;
			}
		}

		// Release access to the file list.
		os_sem_unlock(&gsc_global.sem);
		break;
	}

	if (fp)
		os_file_destroy(fp);

	return(ret);
}



//*****************************************************************************
int os_file_destroy(os_file_t* fp)
{
	int	i;
	int	ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if (fp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		// Acquire access to the file list.
		ret	= os_sem_lock(&gsc_global.sem);

		if (ret)
			break;

		// Locate the entry in the file list.
		// The structure may not have made it to the file list.

		for (i = 0; i < SIZEOFARRAY(gsc_global.file_list); i++)
		{
			if (gsc_global.file_list[i].fp == fp)
			{
				// Free the entry table entry.
				gsc_global.file_list[i].fp	= NULL;
				ret	= 0;
				break;
			}
		}

		// Release access to the file list.
		os_sem_unlock(&gsc_global.sem);

		if (ret)
			break;

		// Now free all of the resources.
		os_res_release(fp);
		os_sem_destroy(&fp->sem);
		memset(fp, 0, sizeof(os_file_t));
		free(fp);
		break;
	}

	return(ret);
}



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_file_acquire(int fd, os_file_t** fpp)
{
	os_file_t*	fp	= NULL;
	int			i;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if (fpp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		// Acquire access to the file list.
		ret	= os_sem_lock(&gsc_global.sem);

		if (ret)
			break;

		// Locate the specified file.
		fpp[0]	= NULL;
		ret		= -EINVAL;

		for (i = 0; i < SIZEOFARRAY(gsc_global.file_list); i++)
		{
			if (gsc_global.file_list[i].fp == NULL)
				continue;

			if (gsc_global.file_list[i].fp->fd == fd)
			{
				fpp[0]	= gsc_global.file_list[i].fp;
				ret		= 0;
				break;
			}
		}

		os_sem_unlock(&gsc_global.sem);
		break;
	}

	return(ret);
}



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_file_release(os_file_t* fp)
{
	int	ret;

	for (;;)	// A convenience loop.
	{
		// Validate the arguments.

		if (fp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		// Acquire access to the file list.
		ret	= os_sem_lock(&fp->sem);

		if (ret)
			break;

		if (fp->users > 0)
			fp->users--;

		os_sem_unlock(&fp->sem);
		break;
	}

	return(ret);
}


