// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/lib/rtx/os_close.c $
// $Rev: 33966 $
// $Date: 2015-11-05 18:39:22 -0600 (Thu, 05 Nov 2015) $

// RTX 2012 library

#include "main.h"



//*****************************************************************************
// returns 0 = ok, <0 = -errno, >0 = error code for Jungo or Windows
int os_close(int fd)
{
	os_file_t*	fp;
	os_msg_t	msg;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Access the file.
		ret	= os_file_acquire(fd, &fp);

		if (ret)
			break;

		if (fp == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		// Gain exclusive access so we can make changes.
		ret	= os_sem_lock(&fp->sem);

		if (ret)
		{
			os_file_release(fp);
			break;
		}

		if (fp->users > 1)
		{
			// One or more other threads are still accessing the devise.
			ret	= -EBUSY;
			os_sem_unlock(&fp->sem);
			os_file_release(fp);
			break;
		}

		// Initialize the message structure.
		memset(&msg, 0, sizeof(os_msg_t));
		msg.status			= OS_MSG_STS_PASS;
		msg.type			= OS_MSG_TYPE_CLOSE;
		msg.u.close.dev_id	= fp->dev_id;

		// Send the request.
		ret	= os_msg_xfer(fp, 0, &msg);
		os_res_release(fp);
		os_file_destroy(fp);

		if (ret)
			break;

		// Process the response.

		if (msg.processed == 0)
		{
			// The message was not procecessed for some reason.
			ret	= -EBADE;
			break;
		}

		switch (msg.status)
		{
			default:
			case OS_MSG_STS_MSG_TYPE:

				ret	= -EBADMSG;
				break;

			case OS_MSG_STS_FAIL:

				ret	= -EINVAL;
				break;

			case OS_MSG_STS_PASS:

				ret	= msg.ret;
				break;
		}

		break;
	}

	return(ret);
}


