// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/led/main.c $
// $Rev: 33957 $
// $Date: 2015-11-01 15:22:53 -0600 (Sun, 01 Nov 2015) $

#include "main.h"



// variables ******************************************************************

static	int		_continuous		= 0;
static	int		_ignore_errors	= 0;
static	int		_def_index		= 0;
static	long	_minute_limit	= 0;
static	int		_test_limit		= -1;





//*****************************************************************************
static int _parse_args(int argc, char** argv)
{
	char	buf[32];
	char	c;
	int		errs	= 0;
	int		i;
	int		j;
	int		k;

	printf("led - Illuminate the LEDs on the board (Version %s)\n", VERSION);
	printf("USAGE: led <-c> <-C> <-m#> <-n#> index\n");
	printf("  -c     Continue testing until an error occurs.\n");
	printf("  -C     Continue testing even if errors occur.\n");
	printf("  -m#    Run for at most # minutes (a decimal number).\n");
	printf("  -n#    Repeat test at most # times (a decimal number).\n");
	printf("  index  The zero based index of the channel to access (default is 0).\n");

	gsc_label_level_inc();

	for (i = 0; i < argc; i++)
	{
		sprintf(buf, "Argument %d", i);
		gsc_label(buf);
		printf("%s\n", argv[i]);
	}

	gsc_label_level_dec();

	for (i = 1; i < argc; i++)
	{
		if (strcmp(argv[i], "-c") == 0)
		{
			_continuous		= 1;
			_ignore_errors	= 0;
			continue;
		}

		if (strcmp(argv[i], "-C") == 0)
		{
			_continuous		= 1;
			_ignore_errors	= 1;
			continue;
		}

		if ((argv[i][0] == '-') && (argv[i][1] == 'm') && (argv[i][2]))
		{
			j	= sscanf(&argv[i][2], "%d%c", &k, &c);

			if ((j == 1) && (k > 0))
			{
				_minute_limit	= k;
				continue;
			}

			errs	= 1;
			printf("ERROR: invalid argument: %s\n", argv[i]);
			break;
		}

		if ((argv[i][0] == '-') && (argv[i][1] == 'n') && (argv[i][2]))
		{
			j	= sscanf(&argv[i][2], "%d%c", &k, &c);

			if ((j == 1) && (k > 0))
			{
				_test_limit	= k;
				continue;
			}

			errs	= 1;
			printf("ERROR: invalid argument: %s\n", argv[i]);
			break;
		}

		j	= sscanf(argv[i], "%d%c", &k, &c);

		if ((j == 1) && (k >= 0))
		{
			_def_index	= k;
			continue;
		}

		errs	= 1;
		printf("ERROR: invalid board selection: %s\n", argv[i]);
		break;
	}

	return(errs);
}



//*****************************************************************************
static int _channels_open(int index, int* fd)
{
	int	chan;
	int	errs	= 0;
	int	i;

	for (i = 0; i <= 3; i++)
	{
		chan	= (index * 4) + i;
		fd[i]	= sio4_dev_open(chan, chan, 1);

		if (fd[i] < 0)
			errs++;
	}

	return(errs);
}



//*****************************************************************************
static int _channels_close(int* fd)
{
	int	chan;
	int	errs	= 0;
	int	i;

	for (i = 0; i <= 3; i++)
	{
		chan	= (_def_index * 4) + i;
		errs	+= sio4_dev_close(fd[i], chan, 1);
	}

	return(errs);
}



//*****************************************************************************
static int _perform_tests(int* fd)
{
	int			errs	= 0;
	const char*	psz;
	struct tm*	stm;
	time_t		tt;

	time(&tt);
	stm	= localtime(&tt);
	psz	= asctime(stm);
	gsc_label("Performing Test");
	printf("%s", psz);

	errs	+= sio4_id_board(fd[0], -1);

	errs	+= led_tests(fd, _def_index);

	return(errs);
}



/******************************************************************************
*
*	Function:	main
*
*	Purpose:
*
*		Control the overall operation of the application.
*
*	Arguments:
*
*		argc	The number of command line arguments.
*
*		argv	The list of command line arguments.
*
*	Returned:
*
*		EXIT_SUCCESS	No errors were encounterred.
*		EXIT_FAILURE	One or more errors were encounterred.
*
******************************************************************************/

int main(int argc, char** argv)
{
	int		errs		= 0;
	time_t	exec		= time(NULL);
	long	failures	= 0;
	int		fd[4]		= { -1, -1, -1, -1 };
	long	hours;
	long	mins;
	time_t	now;
	long	passes		= 0;
	int		qty			= 0;
	int		ret			= EXIT_SUCCESS;
	long	secs;
	time_t	t_limit;
	time_t	test;
	long	tests		= 0;

	for (;;)
	{
		gsc_label_init(24);
		test	= time(NULL);
		errs	= _parse_args(argc, argv);

		if (errs)
			break;

		os_id_host();
		errs	+= os_id_driver(SIO4_BASE_NAME);

		if (errs)
			break;

		t_limit	= exec + (_minute_limit * 60);
		qty		= os_count_boards(SIO4_BASE_NAME);

		if (qty <= 0)
			break;

		gsc_label("Testing Board Index");
		printf("%d\n", _def_index);

		errs	+= _channels_open(_def_index, fd);

		if (errs == 0)
		{
			errs	= _perform_tests(fd);
		}

		errs	+= _channels_close(fd);
		now		= time(NULL);
		tests++;

		if (errs)
		{
			failures++;
			printf(	"\nRESULTS: FAIL <---  (%d error%s)",
					errs,
					(errs == 1) ? "" : "s");
		}
		else
		{
			passes++;
			printf("\nRESULTS: PASS");
		}

		secs	= (long) (now - test);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(" (duration %ld:%ld:%02ld)\n", hours, mins, secs);

		secs	= (long) (now - exec);
		hours	= secs / 3600;
		secs	= secs % 3600;
		mins	= secs / 60;
		secs	= secs % 60;
		printf(	"SUMMARY: tests %ld, pass %ld, fail %ld"
				" (duration %ld:%ld:%02ld)\n\n",
				tests,
				passes,
				failures,
				hours,
				mins,
				secs);

		if ((_test_limit > 0) && (_test_limit <= tests))
			break;

		if (_continuous == 0)
			break;

		if ((_ignore_errors == 0) && (errs))
			break;

		if ((_minute_limit) && (now >= t_limit))
			break;
	}

	if ((qty <= 0) || (errs) || (failures))
		ret	= EXIT_FAILURE;

	return(ret);
}



