// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/led/led.c $
// $Rev: 33937 $
// $Date: 2015-10-07 15:25:23 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _main_led_apply(int fd, int wait, s32 value)
{
	int	errs;
	int	ret;

	ret		= sio4_ioctl(fd, SIO4_IOCTL_LED_MAIN, &value);
	errs	= (ret < 0) ? 1 : 0;

	if (wait)
		os_sleep_ms(500);

	return(errs);
}



//*****************************************************************************
static int _channel_led_apply(int fd, int wait, s32 value)
{
	int	errs;
	int	ret;

	ret		= sio4_ioctl(fd, SIO4_IOCTL_LED_CHANNEL, &value);
	errs	= (ret < 0) ? 1 : 0;

	if (wait)
		os_sleep_ms(500);

	return(errs);
}



//*****************************************************************************
static int _walking_bit_apply(int* fd, int qty_m, int qty_c, u32 bits)
{
	int	errs	= 0;
	int	i;
	u32	mask;

	if (qty_c)
	{
		mask	= GSC_FIELD_ENCODE(0xFFFFFFFF, qty_c - 1, 0);

		for (i = 0; i <= 3; i++)
		{
			errs	+= _channel_led_apply(fd[i], 0, bits & mask);
			bits	>>= qty_c;
		}
	}

	if (qty_m)
	{
		mask	= GSC_FIELD_ENCODE(0xFFFFFFFF, qty_m - 1, 0);
		errs	+= _main_led_apply(fd[0], 0, bits & mask);
	}

	os_sleep_ms(500);
	return(errs);
}



//*****************************************************************************
static int _main_leds(int fd)
{
	int	errs;
	int	i;
	u32	mask;
	s32	qty;

	gsc_label("Main LEDs");
	errs	= sio4_query(fd, SIO4_QUERY_LED_MAIN, &qty);

	if (errs == 0)
	{
		printf("%ld LED%s\n", (long) qty, (qty == 1) ? "" : "s");

		if (qty > 0)
		{
			gsc_label_level_inc();
			gsc_label("Flashing");

			mask	= GSC_FIELD_ENCODE(0xFFFFFFFF, qty - 1, 0);

			errs	+= _main_led_apply(fd, 1, mask);
			errs	+= _main_led_apply(fd, 1, 0);
			errs	+= _main_led_apply(fd, 1, mask);
			errs	+= _main_led_apply(fd, 1, 0);

			for (i = 0; i < qty; i++)
				errs	+= _main_led_apply(fd, 1, 1 << i);

			errs	+= _main_led_apply(fd, 1, 0);
			errs	+= _main_led_apply(fd, 1, mask);
			errs	+= _main_led_apply(fd, 1, 0);
			errs	+= _main_led_apply(fd, 1, mask);
			errs	+= _main_led_apply(fd, 1, 0);

			if (errs == 0)
				printf("Done\n");

			gsc_label_level_dec();
		}
	}

	return(errs);
}



//*****************************************************************************
static int _channel_leds_test(int fd, int index)
{
	int	errs;
	int	i;
	u32	mask;
	s32	qty;

	gsc_label_index("Channel", index);
	errs	= sio4_query(fd, SIO4_QUERY_LED_CHANNEL, &qty);

	if (errs == 0)
	{
		printf("%ld LED%s\n", (long) qty, (qty == 1) ? "" : "s");

		if (qty > 0)
		{
			gsc_label_level_inc();
			gsc_label("Flashing");

			mask	= GSC_FIELD_ENCODE(0xFFFFFFFF, qty - 1, 0);

			errs	+= _channel_led_apply(fd, 1, mask);
			errs	+= _channel_led_apply(fd, 1, 0);
			errs	+= _channel_led_apply(fd, 1, mask);
			errs	+= _channel_led_apply(fd, 1, 0);

			for (i = 0; i < qty; i++)
				errs	+= _channel_led_apply(fd, 1, 1 << i);

			errs	+= _channel_led_apply(fd, 1, 0);
			errs	+= _channel_led_apply(fd, 1, mask);
			errs	+= _channel_led_apply(fd, 1, 0);
			errs	+= _channel_led_apply(fd, 1, mask);
			errs	+= _channel_led_apply(fd, 1, 0);

			if (errs == 0)
				printf("Done\n");

			gsc_label_level_dec();
		}
	}

	return(errs);
}



//*****************************************************************************
static int _channel_leds(int* fd, int index)
{
	int	errs;
	int	i;
	s32	qty;

	gsc_label("Channel LEDs");
	errs	= sio4_query(fd[0], SIO4_QUERY_LED_CHANNEL, &qty);

	if (errs == 0)
	{
		printf("%ld LED%s\n", (long) qty, (qty == 1) ? "" : "s");

		for (i = 0; i <= 3; i++)
			errs	+= _channel_leds_test(fd[i], i + 4 * index);
	}

	return(errs);
}



//*****************************************************************************
static int _walking_bit(int* fd)
{
	int	errs;
	int	i;
	u32	mask;
	s32	qty;
	s32	qty_c;
	s32	qty_m;

	gsc_label("Walking Bit");
	errs	= sio4_query(fd[0], SIO4_QUERY_LED_CHANNEL, &qty_c);
	errs	= sio4_query(fd[0], SIO4_QUERY_LED_MAIN, &qty_m);

	if (errs)
	{
	}
	else if ((qty_c == 0) && (qty_m == 0))
	{
		printf("SKIPPED  (No LEDs.)\n");
	}
	else
	{
		qty		= qty_m + 4 * qty_c;
		mask	= GSC_FIELD_ENCODE(0xFFFFFFFF, qty - 1, 0);

		errs	+= _walking_bit_apply(fd, qty_m, qty_c, mask);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, 0);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, mask);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, 0);

		for (i = 0; i < qty; i++)
			errs	+= _walking_bit_apply(fd, qty_m, qty_c, 1 << i);

		errs	+= _walking_bit_apply(fd, qty_m, qty_c, 0);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, mask);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, 0);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, mask);
		errs	+= _walking_bit_apply(fd, qty_m, qty_c, 0);

		if (errs == 0)
			printf("Done\n");
	}

	return(errs);
}



//*****************************************************************************
int led_tests(int* fd, int index)
{
	int	errs	= 0;

	errs	+= _channel_leds(fd, index);
	errs	+= _main_leds(fd[0]);
	errs	+= _walking_bit(fd);

	return(errs);
}


