// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/utils/isoc_util_write.c $
// $Rev: 33930 $
// $Date: 2015-10-07 15:09:54 -0500 (Wed, 07 Oct 2015) $

#include "sio4_isoc_utils.h"



//*****************************************************************************
int isoc_util_write(int fd, int index, int verbose, const void* buf, size_t size)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Isochronous Write", index);

	ret		= sio4_isoc_write(fd, buf, size);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
		;
	else if (errs)
		printf("FAIL <---  (isoc_util_write)\n");
	else
		printf("PASS\n");

	return(errs);
}


