// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/utils/isoc_util_init.c $
// $Rev: 33930 $
// $Date: 2015-10-07 15:09:54 -0500 (Wed, 07 Oct 2015) $

#include "sio4_isoc_utils.h"



//*****************************************************************************
int isoc_util_init(int fd, int index, int verbose, const sio4_isoc_init_t* init, sio4_isoc_t* isoc, const char** err)
{
	int			errs;
	const char*	psz;
	int			ret;

	if (err == NULL)
		err	= &psz;

	if (verbose)
		gsc_label_index("Isochronous Init", index);

	ret		= sio4_isoc_init(fd, init, isoc, err);
	errs	= (ret < 0) ? 1 : 0;

	if (verbose == 0)
	{
	}
	else if (errs)
	{
		printf("FAIL <---  (sio4_isoc_init, %s)\n", err[0]);
	}
	else if (err[0])
	{
		errs	= 1;
		printf("FAIL <---  (sio4_isoc_init, %s)\n", err[0]);
	}
	else
	{
		printf("PASS\n");
	}

	return(errs);
}


