// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/usc_tx_txc.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC TxC");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ISOC_USC_TX_TXC_IN_OSC:

			ptr	= "Input the Oscillator";
			break;

		case SIO4_ISOC_USC_TX_TXC_IN_OSC_INV:

			ptr	= "Input the Inverted Oscillator";
			break;

		case SIO4_ISOC_USC_TX_TXC_IN_0:

			ptr	= "Input a Low";
			break;

		case SIO4_ISOC_USC_TX_TXC_IN_1:

			ptr	= "Input a High";
			break;

		case SIO4_ISOC_USC_TX_TXC_IN_CBL_RXC:

			ptr	= "Input the Cable RxC Signal";
			break;

		case SIO4_ISOC_USC_TX_TXC_IN_CBL_RXAUX:

			ptr	= "Input the Cable RxAuxC Signal";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_CLK:

			ptr	= "Output the Tx Clock";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_BYTE_CLK:

			ptr	= "Output the Tx Byte Clock";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_COMP:

			ptr	= "Output the Tx Complete Signal";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_BRG0:

			ptr	= "Output the BRG0 Output";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_BRG1:

			ptr	= "Output the BRG1 Output";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_CTR1:

			ptr	= "Output the CTR1 Output";
			break;

		case SIO4_ISOC_USC_TX_TXC_OUT_DPLL_TX:

			ptr	= "Output the DPLL's Tx Clock";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_isoc_t_usc_tx_txc(
	int					fd,
	s32*				arg,
	sio4_isoc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "isoc->usc.tx.txc"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ISOC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_txc_cfg(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ISOC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ISOC_USC_TX_TXC_IN_OSC;
				break;

		case SIO4_ISOC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_txc_cfg(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ISOC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ISOC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:				errs	= 1;	break;
					case -1:
					case SIO4_ISOC_USC_TX_TXC_IN_OSC:
					case SIO4_ISOC_USC_TX_TXC_IN_OSC_INV:
					case SIO4_ISOC_USC_TX_TXC_IN_0:
					case SIO4_ISOC_USC_TX_TXC_IN_1:
					case SIO4_ISOC_USC_TX_TXC_IN_CBL_RXC:
					case SIO4_ISOC_USC_TX_TXC_IN_CBL_RXAUX:
					case SIO4_ISOC_USC_TX_TXC_OUT_CLK:
					case SIO4_ISOC_USC_TX_TXC_OUT_BYTE_CLK:
					case SIO4_ISOC_USC_TX_TXC_OUT_COMP:
					case SIO4_ISOC_USC_TX_TXC_OUT_BRG0:
					case SIO4_ISOC_USC_TX_TXC_OUT_BRG1:
					case SIO4_ISOC_USC_TX_TXC_OUT_CTR1:
					case SIO4_ISOC_USC_TX_TXC_OUT_DPLL_TX:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


