// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/usc_ctr1_clk_src.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC CTR1 Clock Source");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_ISOC_USC_CTR1_CLK_SRC_DISABLE:

			ptr	= "Disable";
			break;

		case SIO4_ISOC_USC_CTR1_CLK_SRC_RXC_PIN:

			ptr	= "RxC Pin";
			break;

		case SIO4_ISOC_USC_CTR1_CLK_SRC_TXC_PIN:

			ptr	= "TxC Pin";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_isoc_t_usc_ctr1_clk_src(
	int					fd,
	s32*				arg,
	sio4_isoc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "isoc->usc.ctr1.clk_src"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ISOC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_ctr1_clk_src(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ISOC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ISOC_USC_CTR1_CLK_SRC_DISABLE;
				break;

		case SIO4_ISOC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_usc_ctr1_clk_src(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ISOC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ISOC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:					errs	= 1;	break;
					case -1:
					case SIO4_ISOC_USC_CTR1_CLK_SRC_DISABLE:
					case SIO4_ISOC_USC_CTR1_CLK_SRC_RXC_PIN:
					case SIO4_ISOC_USC_CTR1_CLK_SRC_TXC_PIN:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


