// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/tx_mode.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;

	gsc_label("USC Tx Mode");

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this board.";
			break;

		case SIO4_USC_MODE_ASYNC:

			ptr	= "Asynchronous";
			break;

		case SIO4_USC_MODE_ISOC:

			ptr	= "Isochronous";
			break;

		case SIO4_USC_MODE_ASY_CV:

			ptr	= "Asynchronous w/ Code Violations";
			break;

		case SIO4_USC_MODE_MONO:

			ptr	= "Monosync";
			break;

		case SIO4_USC_MODE_BSC:

			ptr	= "Bisync";
			break;

		case SIO4_USC_MODE_HDLC:

			ptr	= "HDLC";
			break;

		case SIO4_USC_MODE_TBSC:

			ptr	= "Transparent Bisync";
			break;

		case SIO4_USC_MODE_NBIP:

			ptr	= "Nine-Bit Interprocessor Protocol";
			break;

		case SIO4_USC_MODE_8023:

			ptr	= "IEEE 802.3";
			break;

		case SIO4_USC_MODE_S_MONO:

			ptr	= "Slaved Monosync";
			break;

		case SIO4_USC_MODE_HDLC_L:

			ptr	= "HDLC Loop";
			break;
	}

	printf("%s\n", ptr);
	return(errs);
}



//*****************************************************************************
void sio4_isoc_t_tx_mode(
	int					fd,
	s32*				arg,
	sio4_isoc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "isoc->tx.mode"
	int			errs	= 0;
	const char*	sts		= NULL;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ISOC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_usc_tx_mode(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ISOC_ACTION_INIT:

				errs	= 0;
				arg[0]	= SIO4_ISOC_TX_MODE_ISOC;
				break;

		case SIO4_ISOC_ACTION_SET:

				errs	= sio4_usc_tx_mode(fd, -1, 0, arg[0], NULL);
				break;

		case SIO4_ISOC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ISOC_ACTION_VERIFY:

				switch (arg[0])
				{
					default:		errs	= 1;	break;
					case -1:
					case SIO4_ISOC_TX_MODE_ISOC:	break;
				}

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


