// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/tx_fifo_size.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Tx FIFO Size");

	if (set == -1)
	{
		printf("This service is not supported by this board.\n");
	}
	else if ((set < 0) || (set > 0xFFFF))
	{
		errs++;
		printf("Invalid value: %ld\n", (long) set);
	}
	else if (set % 1024)
	{
		gsc_label_long_comma(set);
		printf(" bytes\n");
	}
	else
	{
		gsc_label_long_comma(set / 1024);
		printf("K bytes\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_isoc_t_tx_fifo_size(
	int					fd,
	s32*				arg,
	sio4_isoc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "isoc->tx.fifo.size"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ISOC_ACTION_GET:
		case SIO4_ISOC_ACTION_INIT:

				errs	= sio4_query(fd, SIO4_QUERY_FIFO_SIZE_TX, arg);
				break;

		case SIO4_ISOC_ACTION_SET:

				// We do nothing here.
				break;

		case SIO4_ISOC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ISOC_ACTION_VERIFY:

				errs	= sio4_query(fd, SIO4_QUERY_FIFO_SIZE_TX, &tmp);

				if ((errs == 0) && (tmp != arg[0]))
					errs	= 1;

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


