// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/tx.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



/******************************************************************************
*
*	Function:	tx_open
*
*	Purpose:
*
*		Initialize Tx use of a channel being opened.
*
*	Arguments:
*
*		dev		The structure for the channel being accessed.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int tx_open(device_t* dev)
{
	int	ret;

	if (dev)
	{
		memset(&dev->tx, 0, sizeof(dev->tx));
		ret	= os_sem_create(&dev->tx.sem);
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	tx_close
*
*	Purpose:
*
*		Cleanup Tx use of a channel being closed.
*
*	Arguments:
*
*		dev		The structure for the channel being accessed.
*
*	Returned:
*
*		None.
*
******************************************************************************/

void tx_close(device_t* dev)
{
	if (dev)
	{
		os_sem_destroy(&dev->tx.sem);
		memset(&dev->tx, 0, sizeof(dev->tx));
	}
}


