// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/show.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_isoc_show
*
*	Purpose:
*
*		Display the provided Isochronous settings.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		isoc	The settings to display.
*
*		err		If a field value is invalid, this will name the field.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_isoc_show(int fd, const sio4_isoc_t* isoc, const char** err)
{
	device_t*	dev;
	const char*	psz		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_isoc_lib_init();

		if (ret)
		{
			psz	= "sio4_isoc_lib_init";
			break;
		}

		// Validate the received arguments.

		if (isoc == NULL)
		{
			psz	= "sio4_isoc_set(,isoc,)";
			break;
		}

		// Gain access to the device.
		dev	= lib_fd_find_inc(fd);

		if (dev == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		// Begin working.
		psz	= sio4_isoc_t_access(dev, (sio4_isoc_t*) isoc, SIO4_ISOC_ACTION_SHOW);

		if (psz)
			ret	= -EINVAL;

		lib_dev_dec(dev);
		break;
	}

	if (err)
		err[0]	= psz;

	return(ret);
}


