// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/rx.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



/******************************************************************************
*
*	Function:	rx_open
*
*	Purpose:
*
*		Initialize Rx use of a channel being opened.
*
*	Arguments:
*
*		dev		The structure for the channel being accessed.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int rx_open(device_t* dev)
{
	int	ret;

	if (dev)
	{
		memset(&dev->rx, 0, sizeof(dev->rx));
		ret	= os_sem_create(&dev->rx.sem);
	}
	else
	{
		ret	= -EINVAL;
	}

	return(ret);
}



/******************************************************************************
*
*	Function:	rx_close
*
*	Purpose:
*
*		Cleanup Rx use of a channel being closed.
*
*	Arguments:
*
*		dev		The structure for the channel being accessed.
*
*	Returned:
*
*		-1		The request failed.
*		0		The request was successful.
*
******************************************************************************/

void rx_close(device_t* dev)
{
	if (dev)
	{
		os_sem_destroy(&dev->rx.sem);
		memset(&dev->rx, 0, sizeof(dev->rx));
	}
}



