// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/read.c $
// $Rev: 33921 $
// $Date: 2015-10-07 14:49:23 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _args_validate(int fd, void* buf, size_t size, device_t** dev)
{
	int	ret;

	for (;;)	// A convenience loop.
	{
		if (buf == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		if (size < 0)
		{
			ret	= -EINVAL;
			break;
		}

		if (dev == NULL)
		{
			ret	= -EINVAL;
			break;
		}

		dev[0]	= lib_fd_find_inc(fd);

		if (dev[0] == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		ret	= 0;
		break;
	}

	return(ret);
}



//*****************************************************************************
static int _env_validate(device_t* dev)
{
	int	ret;

	ret	= dev->rx.reading ? -EBUSY : 0;
	return(ret);
}



//*****************************************************************************
static int _loc_read(device_t* dev, void* buf, size_t size)
{
	int	ret;

	ret	= sio4_read(dev->fd, buf, size);
	return(ret);
}



/******************************************************************************
*
*	Function:	sio4_isoc_read
*
*	Purpose:
*
*		Read in a block of data.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		buf		The data read goes here.
*
*		size	Read no more than this number of bytes.
*
*	Returned:
*
*		>= 0	The number of bytes read.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_isoc_read(int fd, void* buf, size_t size)
{
	device_t*	dev		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_isoc_lib_init();

		if (ret)
			break;

		// Validate the arguments.
		ret	= _args_validate(fd, buf, size, &dev);

		if (ret)
			break;

		// Gain exclusive access to the device.
		ret	= os_sem_lock(&dev->sem);

		if (ret)
			break;

		// Validate the state.
		ret	= _env_validate(dev);

		if (ret)
		{
			os_sem_unlock(&dev->sem);
			break;
		}

		// Gain exclusive access to the Rx stream.
		ret	= os_sem_lock(&dev->rx.sem);
		os_sem_unlock(&dev->sem);

		if (ret)
			break;

		// Record our presence.
		dev->rx.reading	= 1;
		os_sem_unlock(&dev->rx.sem);

		// Perform the operation.
		ret	= _loc_read(dev, buf, size);

		// Cleanup.
		dev->rx.reading	= 0;
		break;
	}

	if (dev)
		lib_dev_dec(dev);

	return(ret);
}


