// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/osc_ref.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



//*****************************************************************************
static int _show(s32 set)
{
	int	errs	= 0;

	gsc_label("Oscillator Reference");

	if (set == -1)
	{
		printf("This service is not supported by this board.\n");
	}
	else if (set < 1)
	{
		errs++;
		printf("Invalid value: %ld\n", (long) set);
	}
	else
	{
		gsc_label_long_comma(set);
		printf(" Hz\n");
	}

	return(errs);
}



//*****************************************************************************
void sio4_isoc_t_osc_ref(
	int					fd,
	s32*				arg,
	sio4_isoc_action_t	action,
	const char**		err)
{
	#define		ERROR	  "isoc->osc.ref"
	int			errs	= 0;
	const char*	sts		= NULL;
	s32			tmp;

	switch (action)
	{
		default:

				sts		= ERROR;
				break;

		case SIO4_ISOC_ACTION_GET:

				arg[0]	= -1;
				errs	= sio4_osc_reference(fd, -1, 0, arg[0], arg);
				break;

		case SIO4_ISOC_ACTION_INIT:

				errs	= 0;
				arg[0]	= 20000000L;
				break;

		case SIO4_ISOC_ACTION_SET:

				tmp		= arg[0];
				errs	= sio4_osc_reference(fd, -1, 0, tmp, NULL);
				break;

		case SIO4_ISOC_ACTION_SHOW:

				errs	= _show(arg[0]);
				break;

		case SIO4_ISOC_ACTION_VERIFY:

				errs	= sio4_osc_reference(fd, -1, 0, -1, &tmp);

				if ((errs == 0) && (tmp != arg[0]) && (arg[0] != -1))
					errs	= 1;

				break;
	}

	if (errs)
		sts		= ERROR;

	if ((err) && (sts))
		err[0]	= sts;
}


