// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/open.c $
// $Rev: 33921 $
// $Date: 2015-10-07 14:49:23 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_isoc_open
*
*	Purpose:
*
*		Open an SIO4 channel for Isochronous use.
*
*	Arguments:
*
*		index	The index of the SIO4 channel to access.
*
*	Returned:
*
*		>= 0	All went well. This is the valid file handle.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_isoc_open(int index)
{
	device_t*	dev	= NULL;
	int			fd	= -1;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_isoc_lib_init();

		if (ret)
			break;

		// Verify that the channel isn't already open.
		dev	= lib_fd_find_inc(fd);

		if (dev)
		{
			fd	= -EALREADY;
			lib_dev_dec(dev);
			break;
		}

		// Begin opening access to the SIO4 channel.
		fd	= sio4_open(index);

		if (fd < 0)
			break;

		dev	= lib_dev_alloc_inc();

		if (dev == NULL)
		{
			sio4_close(fd);
			fd	= -ENOMEM;
			break;
		}

		memset(dev, 0, sizeof(dev[0]));
		dev->fd	= fd;
		ret		= os_sem_create(&dev->sem);

		if (ret == 0)
			ret	= rx_open(dev);

		if (ret == 0)
			ret	= tx_open(dev);

		if (ret)
		{
			lib_dev_dec(dev);
			sio4_isoc_close(fd);
			fd	= (ret < 0) ? ret : -EINVAL;
		}

		break;
	}

	return(fd);
}



