// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/main.h $
// $Rev: 33921 $
// $Date: 2015-10-07 14:49:23 -0500 (Wed, 07 Oct 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "sio4_dsl.h"
#include "sio4_utils.h"
#include "sio4_isoc.h"



// #defines *******************************************************************

#define	SIO4_ISOC_LIB_VER	"1.3"
// 1.3	API prototypes and return values mimic the SIO4 API services.
// 1.2	Made corrections to some legacy cable interface macros.
//		Removed error status when oscillator program frequency is not recorded."
// 1.1	The osc_prog values of -1, 0 and 1 now have special meanings.
// 1.0	Initial release.

#define	ARRAY_ELEMENTS(a)		(sizeof((a))/sizeof((a)[0]))

#undef	ERROR



// data types *****************************************************************

typedef struct
{
	os_sem_t		sem;
	int				fd;
	int				users;

	struct
	{
		os_sem_t	sem;

		// These maintain the state of these activities.
		int			reading;		// Number of active Rx Read calls.
	} rx;

	struct
	{
		os_sem_t	sem;

		// These maintain the state of these activities.
		int			writing;		// Number of active write calls.
	} tx;

} device_t;



// prototypes *****************************************************************

device_t*	lib_dev_alloc_inc(void);			// returns NULL or valid pointer
int			lib_dev_dec(device_t* dev);			// returns 0 or -errno
int			lib_dev_dec_release(device_t* dev);	// returns 0 or -errno
device_t*	lib_fd_find_inc(int fd);			// returns NULL for error

void		rx_close(device_t* dev);
int			rx_open(device_t* dev);				// returns 0 or -errno

const char*	sio4_isoc_t_access(device_t* dev, sio4_isoc_t* isoc, sio4_isoc_action_t action);	// returns NULL or error

void		tx_close(device_t* dev);
int			tx_open(device_t* dev);				// returns 0 or -errno



#endif
