// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/init.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



//*****************************************************************************
static const char* _sio4_isoc_init_t_validate(const sio4_isoc_init_t* init)
{
	const char*	psz	= NULL;

	for (;;)	// A convenience loop.
	{
		if (init == NULL)
		{
			psz	= "_sio4_isoc_init_t_validate(init)";
			break;
		}

		if ((init->rx_bit_rate < 1) || (init->rx_bit_rate > 20000000L))
		{
			psz	= "init->rx_bit_rate";
			break;
		}

		if ((init->tx_bit_rate < 1) || (init->tx_bit_rate > 20000000L))
		{
			psz	= "init->tx_bit_rate";
			break;
		}

		break;
	}

	return(psz);
}



/******************************************************************************
*
*	Function:	sio4_isoc_init
*
*	Purpose:
*
*		Initialize the Isochronous settings for the specified SIO4.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to access.
*
*		init	This provides preliminary settings upon which various device
*				clocking parameters are based.
*
*		isoc	The initialized settings are recorded here.
*
*		err		If a field value is invalid, this will name the field.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_isoc_init(
	int						fd,
	const sio4_isoc_init_t*	init,
	sio4_isoc_t*			isoc,
	const char**			err)
{
	device_t*	dev;
	const char*	psz		= NULL;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_isoc_lib_init();

		if (ret)
		{
			psz	= "sio4_isoc_lib_init";
			break;
		}

		// Validate the received arguments.

		if (init == NULL)
		{
			psz	= "sio4_isoc_init(,init,,)";
			ret	= -EINVAL;
			break;
		}

		if (isoc == NULL)
		{
			psz	= "sio4_isoc_init(,,isoc,)";
			ret	= -EINVAL;
			break;
		}

		// Gain access to the device.
		dev	= lib_fd_find_inc(fd);

		if (dev == NULL)
		{
			ret	= -ENODEV;
			psz	= "dev";
			break;
		}

		// Begin initialization.
		psz	= _sio4_isoc_init_t_validate(init);

		if (psz)
		{
			ret	= -EINVAL;
		}
		else
		{
			memset(isoc, 0, sizeof(sio4_isoc_t));
			psz	= sio4_isoc_t_access(dev, isoc, SIO4_ISOC_ACTION_INIT);
		}

		if (psz)
		{
			ret	= -EINVAL;
		}
		else
		{
			psz	= sio4_isoc_t_access(dev, isoc, SIO4_ISOC_ACTION_VERIFY);
		}

		if (psz)
			ret	= -EINVAL;

		isoc->osc.prog		= init->tx_bit_rate;
		isoc->tx.bit_rate	= init->tx_bit_rate;
		isoc->rx.bit_rate	= init->rx_bit_rate;
		lib_dev_dec(dev);
		break;
	}

	if (err)
		err[0]	= psz;

	return(ret);
}


