// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/lib/close.c $
// $Rev: 31479 $
// $Date: 2014-12-04 13:12:00 -0600 (Thu, 04 Dec 2014) $

#include "main.h"



/******************************************************************************
*
*	Function:	sio4_isoc_close
*
*	Purpose:
*
*		Close a channel that has been opened to an SIO4 channel for Isochronous
*		use.
*
*	Arguments:
*
*		fd		The file descriptor for the SIO4 channel to close.
*
*	Returned:
*
*		0		All went well.
*		-errno	There was a problem.
*
******************************************************************************/

int sio4_isoc_close(int fd)
{
	device_t*	dev;
	int			ret;

	for (;;)	// A convenience loop.
	{
		// Make sure the library is initialized.
		ret	= sio4_isoc_lib_init();

		if (ret)
			break;

		// Gain access to the device.
		dev	= lib_fd_find_inc(fd);

		if (dev == NULL)
		{
			ret	= -ENODEV;
			break;
		}

		// Begin closing access.
		ret	= lib_dev_dec_release(dev);

		if (ret)
			break;

		rx_close(dev);
		tx_close(dev);
		sio4_close(fd);
		os_sem_destroy(&dev->sem);
		memset(dev, 0, sizeof(dev[0]));
		free(dev);
		break;
	}

	return(ret);
}



