// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_tx_abort_sent.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int	errs	= 0;

	// Generate a GSC interrupt: USC Tx Idle Sent
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable			(fd, -1, 0, SIO4_IRQ_USC_TX_ABORT_SENT,			NULL);
	errs	+= sio4_osc_program				(fd, -1, 0, 20000000,							NULL);
	errs	+= sio4_loop_back				(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_usc_tx_mode				(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_tx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_NORMAL,			NULL);
	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_tx_cmd				(fd, -1, 0, SIO4_USC_TX_CMD_SEND_ABORT,			NULL);

	// Wait for the abort to be sent.
	os_sleep_ms(50);
	return(errs);
}



//*****************************************************************************
int usc_tx_abort_sent_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


