// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_rxreq_up.c $
// $Rev: 33936 $
// $Date: 2015-10-07 15:24:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	char	buf[16];
	int		errs	= 0;
	int		sts;

	memset(buf, 0, sizeof(buf));

	// Generate a PCI interrupt: I/O Pin RxReq Rise
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable			(fd, -1, 0, SIO4_IRQ_USC_IOP_RXREQ_RISE,		NULL);
	errs	+= sio4_osc_program				(fd, -1, 0, 20000000,							NULL);
	errs	+= sio4_z16_sync_byte			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_loop_back				(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_z16_rx_sts_wrd_enable	(fd, -1, 0, SIO4_Z16_RX_STS_WRD_ENABLE_NO,		NULL);
	errs	+= sio4_rx_fifo_full_cfg		(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_OVER,			NULL);
	errs	+= sio4_rx_fifo_full_cfg_glb	(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_GLB_OVER,		NULL);
	errs	+= sio4_tx_fifo_empty_cfg		(fd, -1, 0, SIO4_TX_FIFO_EMPTY_CFG_IGNORE,		NULL);

	errs	+= sio4_usc_rx_mode				(fd, -1, 0, SIO4_USC_MODE_ASYNC,				NULL);
	errs	+= sio4_usc_async_rx_clk_rate	(fd, -1, 0, SIO4_USC_ASYNC_CLK_RATE_16X,		NULL);
	errs	+= sio4_usc_rx_char_len			(fd, -1, 0, SIO4_USC_CHAR_LEN_8,				NULL);
	errs	+= sio4_usc_rx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_usc_rx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZ,			NULL);
	errs	+= sio4_usc_rx_par_enable		(fd, -1, 0, SIO4_USC_PAR_ENABLE_NO,				NULL);

	errs	+= sio4_usc_tx_mode				(fd, -1, 0, SIO4_USC_MODE_ASYNC,				NULL);
	errs	+= sio4_usc_async_tx_clk_rate	(fd, -1, 0, SIO4_USC_ASYNC_CLK_RATE_16X,		NULL);
	errs	+= sio4_usc_async_tx_stop_bit	(fd, -1, 0, SIO4_USC_ASYNC_TX_STOP_BIT_1,		NULL);
	errs	+= sio4_usc_tx_char_len			(fd, -1, 0, SIO4_USC_CHAR_LEN_8,				NULL);
	errs	+= sio4_usc_tx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_usc_tx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZ,			NULL);
	errs	+= sio4_usc_tx_idle_cond		(fd, -1, 0, SIO4_USC_TX_IDLE_COND_DEFAULT,		NULL);
	errs	+= sio4_usc_tx_par_enable		(fd, -1, 0, SIO4_USC_PAR_ENABLE_NO,				NULL);

	errs	+= sio4_usc_brg0_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,				NULL);
	errs	+= sio4_usc_brg1_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,				NULL);
	errs	+= sio4_usc_ctr0_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_DISABLE,		NULL);
	errs	+= sio4_usc_ctr1_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_DISABLE,		NULL);
	errs	+= sio4_usc_dpll_mode			(fd, -1, 0, SIO4_USC_DPLL_MODE_DISABLE,			NULL);
	errs	+= sio4_usc_tc0					(fd, -1, 0, 0,									NULL);
	errs	+= sio4_usc_tc1					(fd, -1, 0, 0,									NULL);

	errs	+= sio4_cbl_mode				(fd, -1, 0, SIO4_CBL_MODE_DTE,					NULL);
	errs	+= sio4_xcvr_enable				(fd, -1, 0, SIO4_XCVR_ENABLE_NO,				NULL);
	errs	+= sio4_xcvr_protocol			(fd, -1, 0, SIO4_XCVR_PROTOCOL_DISABLE,			NULL);
	errs	+= sio4_z16_cbl_dcd_cfg			(fd, -1, 0, SIO4_Z16_CBL_DCD_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_cbl_dtr_dsr_cfg		(fd, -1, 0, SIO4_Z16_CBL_DTR_DSR_CFG_TRI,		NULL);
	errs	+= sio4_z16_cbl_rts_cfg			(fd, -1, 0, SIO4_Z16_CBL_RTS_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_cbl_txauxc_cfg		(fd, -1, 0, SIO4_Z16_CBL_TXAUXC_CFG_TRI,		NULL);
	errs	+= sio4_z16_cbl_txc_cfg			(fd, -1, 0, SIO4_Z16_CBL_TXC_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_cbl_txd_cfg			(fd, -1, 0, SIO4_Z16_CBL_TXD_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_leg_rxc				(fd, -1, 0, SIO4_Z16_LEG_RXC_DISABLE,			NULL);
	errs	+= sio4_z16_leg_rxd_dcd_cfg		(fd, -1, 0, SIO4_Z16_LEG_RXD_DCD_CFG_TRI,		NULL);
	errs	+= sio4_z16_leg_txc				(fd, -1, 0, SIO4_Z16_LEG_TXC_DISABLE,			NULL);
	errs	+= sio4_z16_leg_txd_cts_cfg		(fd, -1, 0, SIO4_Z16_LEG_TXD_CTS_CFG_TRI,		NULL);

	errs	+= sio4_usc_cts_cfg				(fd, -1, 0, SIO4_USC_CTS_CFG_TRI,				NULL);
	errs	+= sio4_usc_dcd_cfg				(fd, -1, 0, SIO4_USC_DCD_CFG_DISABLE,			NULL);
	errs	+= sio4_usc_rxc_cfg				(fd, -1, 0, SIO4_USC_RXC_CFG_IN_0,				NULL);
	errs	+= sio4_usc_txc_cfg				(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,			NULL);
	errs	+= sio4_usc_txd_cfg				(fd, -1, 0, SIO4_USC_TXD_CFG_OUT_TXD,			NULL);

	errs	+= sio4_tx_io_timeout			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_tx_io_mode				(fd, -1, 0, GSC_IO_MODE_PIO,					NULL);
	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_rx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_INT_LOOPBACK,	NULL);

	// Send data and wait a bit.
	sts		= sio4_write(fd, buf, sizeof(buf));
	errs	+= (sts < 0) ? 1 : 0;
	os_sleep_ms(50);

	return(errs);
}



//*****************************************************************************
int usc_rxreq_up_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


