// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_rxc_up.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int		errs	= 0;

	// Generate a USC interrupt: I/O Pin RxC Fall
	errs	+= sio4_initialize		(fd, -1, 0, 1,								NULL);
	errs	+= sio4_osc_program		(fd, -1, 0, 20000000,						NULL);

	errs	+= sio4_usc_txc_cfg		(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,		NULL);

	errs	+= sio4_usc_rxc_cfg		(fd, -1, 0, SIO4_USC_RXC_CFG_OUT_BRG0,		NULL);
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x4, 0x7);

	errs	+= sio4_usc_tc0			(fd, -1, 0, 20,								NULL);
	errs	+= sio4_usc_brg0_clk_src(fd, -1, 0, SIO4_USC_BRG_CLK_SRC_TXC_PIN,	NULL);
	errs	+= sio4_usc_brg0_mode	(fd, -1, 0, SIO4_USC_BRG_MODE_CONT,			NULL);
	errs	+= sio4_usc_brg0_enable	(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,			NULL);

	errs	+= sio4_irq_usc_enable	(fd, -1, 0, SIO4_IRQ_USC_IOP_RXC_RISE,		NULL);
	errs	+= sio4_usc_brg0_enable	(fd, -1, 0, SIO4_USC_BRG_ENABLE_YES,		NULL);

	os_sleep_ms(50);
	return(errs);
}



//*****************************************************************************
int usc_rxc_up_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


