// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_rx_overrun.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int	errs	= 0;
	int	i;

	// Generate a PCI interrupt: USC Rx Overrun
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable			(fd, -1, 0, SIO4_IRQ_USC_RX_OVERRUN,			NULL);
	errs	+= sio4_osc_program				(fd, -1, 0, 20000000,							NULL);
	errs	+= sio4_z16_sync_byte			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_loop_back				(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_z16_rx_sts_wrd_enable	(fd, -1, 0, SIO4_Z16_RX_STS_WRD_ENABLE_NO,		NULL);
	errs	+= sio4_rx_fifo_full_cfg		(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_OVER,			NULL);
	errs	+= sio4_rx_fifo_full_cfg_glb	(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_GLB_OVER,		NULL);
	errs	+= sio4_tx_fifo_empty_cfg		(fd, -1, 0, SIO4_TX_FIFO_EMPTY_CFG_IGNORE,		NULL);

	errs	+= sio4_usc_rx_mode				(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_rx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_BRG0,				NULL);
	errs	+= sio4_usc_rx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZI_SPACE,	NULL);

	errs	+= sio4_usc_tx_mode				(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_tx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_BRG0,				NULL);
	errs	+= sio4_usc_tx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZI_SPACE,	NULL);

	errs	+= sio4_usc_tc0					(fd, -1, 0, 20,									NULL);
	errs	+= sio4_usc_brg0_mode			(fd, -1, 0, SIO4_USC_BRG_MODE_CONT,				NULL);
	errs	+= sio4_usc_brg0_clk_src		(fd, -1, 0, SIO4_USC_BRG_CLK_SRC_TXC_PIN,		NULL);
	errs	+= sio4_usc_brg0_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_YES,			NULL);

	errs	+= sio4_usc_cts_cfg				(fd, -1, 0, SIO4_USC_CTS_CFG_TRI,				NULL);
	errs	+= sio4_usc_dcd_cfg				(fd, -1, 0, SIO4_USC_DCD_CFG_DISABLE,			NULL);
	errs	+= sio4_usc_rxc_cfg				(fd, -1, 0, SIO4_USC_RXC_CFG_IN_0,				NULL);
	errs	+= sio4_usc_txc_cfg				(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,			NULL);
	errs	+= sio4_usc_txd_cfg				(fd, -1, 0, SIO4_USC_TXD_CFG_OUT_TXD,			NULL);

	errs	+= sio4_tx_io_timeout			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_tx_io_mode				(fd, -1, 0, GSC_IO_MODE_PIO,					NULL);
	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_rx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_INT_LOOPBACK,	NULL);

	// Disable DMA from the Tx FIFO to the USC.
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x0000, 0x0C00);

	// Put data in the Tx FIFO.

	for (i = 0; i < 1000; i++)
		errs	+= sio4_reg_write(fd, SIO4_GSC_FDR, 0x55);

	os_sleep_ms(10);


	// Let the data procede from the Tx FIFO to the USC.
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x0000, 0x0300);
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x0400, 0x0C00);
	os_sleep_ms(20);	// Wait for data to get to the receiver.

	// Let the data procede from the USC to the Rx FIFO.
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x0100, 0x0300);
	os_sleep_ms(10);

	return(errs);
}



//*****************************************************************************
int usc_rx_overrun_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


