// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_rx_break_abort.c $
// $Rev: 23598 $
// $Date: 2013-10-15 11:04:53 -0500 (Tue, 15 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	char	buf[128];
	int		errs	= 0;

	memset(buf, 0, sizeof(buf));

	// Generate a PCI interrupt: Rx Break/Abort
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable			(fd, -1, 0, SIO4_IRQ_USC_RX_BREAK_ABORT,		NULL);

	errs	+= sio4_osc_program				(fd, -1, 0, 20000000,							NULL);

	errs	+= sio4_usc_rx_mode				(fd, -1, 0, SIO4_USC_MODE_ASYNC,				NULL);
	errs	+= sio4_usc_rx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_xcvr_enable				(fd, -1, 0, SIO4_XCVR_ENABLE_YES,				NULL);
	errs	+= sio4_xcvr_protocol			(fd, -1, 0, SIO4_XCVR_PROTOCOL_RS232,			NULL);
	errs	+= sio4_z16_cbl_txd_cfg			(fd, -1, 0, SIO4_Z16_CBL_TXD_CFG_OUT_USC_TXD,	NULL);
	errs	+= sio4_usc_txc_cfg				(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,			NULL);
	errs	+= sio4_usc_txd_cfg				(fd, -1, 0, SIO4_USC_TXD_CFG_OUT_TXD,			NULL);

	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);
	errs	+= sio4_usc_rx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);
	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_EXT_LOOPBACK,	NULL);

	// Toggle the data line very slowly.
	errs	+= sio4_z16_cbl_txd_cfg			(fd, -1, 0, SIO4_Z16_CBL_TXD_CFG_OUT_USC_TXD,	NULL);

	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x0080, 0x00C0);	// USC TxD: 0
	os_sleep_ms(50);
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x00C0, 0x00C0);	// USC TxD: 1
	os_sleep_ms(50);
	errs	+= sio4_reg_mod(fd, SIO4_USC_IOCR, 0x0000, 0x00C0);	// USC TxD: normal output
	os_sleep_ms(50);

	return(errs);
}



//*****************************************************************************
int usc_rx_break_abort_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


