// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_rcc_underrun.c $
// $Rev: 33936 $
// $Date: 2015-10-07 15:24:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	char	buf[64]	= "";
	int		errs	= 0;
	int		frames;
	s32		sts;

	// Generate a GSC interrupt: USC RCC Underrun
	errs	+= sio4_initialize			(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable		(fd, -1, 0, SIO4_IRQ_USC_MISC_RCC_UNDERRUN,		NULL);
	errs	+= sio4_osc_program			(fd, -1, 0, 20000000,							NULL);
	errs	+= sio4_loop_back			(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_usc_tx_mode			(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_tx_crc_enable	(fd, -1, 0, SIO4_USC_CRC_ENABLE_YES,			NULL);
	errs	+= sio4_usc_tx_crc_on_end	(fd, -1, 0, SIO4_USC_TX_CRC_ON_END_YES,			NULL);
	errs	+= sio4_usc_hdlc_tx_underrun(fd, -1, 0, SIO4_USC_HDLC_TX_UNDERRUN_CRC_F,	NULL);
	errs	+= sio4_usc_txc_cfg			(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,			NULL);
	errs	+= sio4_usc_tx_clk_src		(fd, -1, 0, SIO4_USC_CLK_SRC_BRG0,				NULL);

	errs	+= sio4_tx_io_timeout		(fd, -1, 0, 0,									NULL);
	errs	+= sio4_tx_io_mode			(fd, -1, 0, GSC_IO_MODE_PIO,					NULL);

	errs	+= sio4_usc_rx_mode			(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_rx_clk_src		(fd, -1, 0, SIO4_USC_CLK_SRC_BRG0,				NULL);

	errs	+= sio4_usc_tc0				(fd, -1, 0, 20,									NULL);
	errs	+= sio4_usc_brg0_clk_src	(fd, -1, 0, SIO4_USC_BRG_CLK_SRC_TXC_PIN,		NULL);
	errs	+= sio4_usc_brg0_mode		(fd, -1, 0, SIO4_USC_BRG_MODE_CONT,				NULL);
	errs	+= sio4_usc_brg0_enable		(fd, -1, 0, SIO4_USC_BRG_ENABLE_YES,			NULL);

	errs	+= sio4_usc_oper_mode		(fd, -1, 0, SIO4_USC_OPER_MODE_INT_LOOPBACK,	NULL);
	errs	+= sio4_usc_tx_enable		(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);
	errs	+= sio4_usc_rx_enable		(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_reg_write(fd, SIO4_USC_RCLR, 20);
	errs	+= sio4_usc_send_command	(fd, -1, 0, SIO4_USC_SEND_CMD_LD_RX_CHAR_CNT,	NULL);

	errs	+= sio4_reg_write(fd, SIO4_USC_TCLR, 10);
	errs	+= sio4_usc_send_command	(fd, -1, 0, SIO4_USC_SEND_CMD_LD_TX_CHAR_CNT,	NULL);

	for (frames = 0; frames <= 6; frames++)
	{
		sts		= sio4_write(fd, buf, sizeof(buf));
		errs	+= (sts < 0) ? 1 : 0;
		os_sleep_ms(50);
	}

	return(errs);
}



//*****************************************************************************
int usc_rcc_underrun_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


