// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_dpll_desync.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int	errs	= 0;

	// Generate a PCI interrupt: USC Exited Hunt
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable			(fd, -1, 0, SIO4_IRQ_USC_MISC_DPLL_DESYNC,		NULL);
	errs	+= sio4_osc_program				(fd, -1, 0, 1000000,							NULL);
	errs	+= sio4_z16_sync_byte			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_loop_back				(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_rx_fifo_full_cfg		(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_OVER,			NULL);
	errs	+= sio4_rx_fifo_full_cfg_glb	(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_GLB_OVER,		NULL);
	errs	+= sio4_tx_fifo_empty_cfg		(fd, -1, 0, SIO4_TX_FIFO_EMPTY_CFG_IGNORE,		NULL);

	errs	+= sio4_usc_rx_mode				(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_rx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_DPLL,				NULL);
	errs	+= sio4_usc_rx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZI_SPACE,	NULL);

	errs	+= sio4_usc_tx_mode				(fd, -1, 0, SIO4_USC_MODE_HDLC,					NULL);
	errs	+= sio4_usc_tx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_CTR0,				NULL);
	errs	+= sio4_usc_tx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZI_SPACE,	NULL);

	errs	+= sio4_usc_ctr0_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_TXC_PIN,		NULL);
	errs	+= sio4_usc_ctr0_rate			(fd, -1, 0, SIO4_USC_CTR0_RATE_32X,				NULL);

	errs	+= sio4_usc_cts_cfg				(fd, -1, 0, SIO4_USC_CTS_CFG_TRI,				NULL);
	errs	+= sio4_usc_dcd_cfg				(fd, -1, 0, SIO4_USC_DCD_CFG_DISABLE,			NULL);
	errs	+= sio4_usc_rxc_cfg				(fd, -1, 0, SIO4_USC_RXC_CFG_IN_0,				NULL);
	errs	+= sio4_usc_txc_cfg				(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,			NULL);
	errs	+= sio4_usc_txd_cfg				(fd, -1, 0, SIO4_USC_TXD_CFG_OUT_TXD,			NULL);

	errs	+= sio4_usc_dpll_adj_sync		(fd, -1, 0, SIO4_USC_DPLL_ADJ_SYNC_RISE_EDGE,	NULL);
	errs	+= sio4_usc_dpll_clk_src		(fd, -1, 0, SIO4_USC_DPLL_CLK_SRC_TXC_PIN,		NULL);
	errs	+= sio4_usc_dpll_mode			(fd, -1, 0, SIO4_USC_DPLL_MODE_NRZ_NRZI,		NULL);
	errs	+= sio4_usc_dpll_rate			(fd, -1, 0, SIO4_USC_DPLL_RATE_8X,				NULL);

	errs	+= sio4_tx_io_timeout			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_tx_io_mode				(fd, -1, 0, GSC_IO_MODE_PIO,					NULL);
	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_EXT_LOOPBACK,	NULL);

	errs	+= sio4_usc_rx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);
	errs	+= sio4_usc_dpll_sync			(fd, -1, 0, SIO4_USC_DPLL_SYNC_START,			NULL);

	errs	+= sio4_usc_dpll_mode			(fd, -1, 0, SIO4_USC_DPLL_MODE_BIPH_MS,			NULL);

	os_sleep_ms(50);

	return(errs);
}



//*****************************************************************************
int usc_dpll_desync_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


