// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc_dcd_up.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int		errs	= 0;

	// Generate a USC interrupt: I/O Pin DCD Rise
	errs	+= sio4_initialize		(fd, -1, 0, 1,							NULL);

	errs	+= sio4_usc_dcd_cfg		(fd, -1, 0, SIO4_USC_DCD_CFG_OUT_0,		NULL);
	errs	+= sio4_irq_usc_enable	(fd, -1, 0, SIO4_IRQ_USC_IOP_DCD_RISE,	NULL);

	errs	+= sio4_usc_dcd_cfg		(fd, -1, 0, SIO4_USC_DCD_CFG_DISABLE,	NULL);
	errs	+= sio4_reg_mod			(fd, SIO4_USC_IOCR, 0x0000, 0x3000);
	os_sleep_ms(1);

	errs	+= sio4_usc_dcd_cfg		(fd, -1, 0, SIO4_USC_DCD_CFG_OUT_1,		NULL);
	errs	+= sio4_reg_mod			(fd, SIO4_USC_IOCR, 0x3000, 0x3000);
	os_sleep_ms(1);

	errs	+= sio4_usc_dcd_cfg		(fd, -1, 0, SIO4_USC_DCD_CFG_OUT_1,		NULL);
	errs	+= sio4_reg_mod			(fd, SIO4_USC_IOCR, 0x2000, 0x3000);
	os_sleep_ms(1);

	errs	+= sio4_usc_dcd_cfg		(fd, -1, 0, SIO4_USC_DCD_CFG_OUT_1,		NULL);
	errs	+= sio4_reg_mod			(fd, SIO4_USC_IOCR, 0x3000, 0x3000);
	os_sleep_ms(1);

	errs	+= sio4_initialize		(fd, -1, 0, 1,							NULL);
	return(errs);
}



//*****************************************************************************
int usc_dcd_up_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


