// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/usc.c $
// $Rev: 33936 $
// $Date: 2015-10-07 15:24:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	z16c30;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	char	buf[20]	= "";
	int		errs	= 0;
	int		sts;

	// Generate a GSC interrupt: USC Tx Idle Sent
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_usc_enable			(fd, -1, 0, SIO4_IRQ_USC_TX_DATA,				NULL);
	errs	+= sio4_osc_program				(fd, -1, 0, 20000000,							NULL);
	errs	+= sio4_loop_back				(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_usc_tx_mode				(fd, -1, 0, SIO4_USC_MODE_ASYNC,				NULL);
	errs	+= sio4_usc_async_tx_clk_rate	(fd, -1, 0, SIO4_USC_ASYNC_CLK_RATE_16X,		NULL);
	errs	+= sio4_usc_async_tx_stop_bit	(fd, -1, 0, SIO4_USC_ASYNC_TX_STOP_BIT_1,		NULL);
	errs	+= sio4_usc_tx_char_len			(fd, -1, 0, SIO4_USC_CHAR_LEN_8,				NULL);
	errs	+= sio4_usc_tx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_usc_tx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZ,			NULL);
	errs	+= sio4_usc_tx_idle_cond		(fd, -1, 0, SIO4_USC_TX_IDLE_COND_DEFAULT,		NULL);
	errs	+= sio4_usc_tx_par_enable		(fd, -1, 0, SIO4_USC_PAR_ENABLE_NO,				NULL);

	errs	+= sio4_usc_brg0_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,				NULL);
	errs	+= sio4_usc_brg1_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,				NULL);
	errs	+= sio4_usc_ctr0_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_DISABLE,		NULL);
	errs	+= sio4_usc_ctr1_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_DISABLE,		NULL);
	errs	+= sio4_usc_dpll_mode			(fd, -1, 0, SIO4_USC_DPLL_MODE_DISABLE,			NULL);
	errs	+= sio4_usc_tc0					(fd, -1, 0, 0,									NULL);
	errs	+= sio4_usc_tc1					(fd, -1, 0, 0,									NULL);

	errs	+= sio4_tx_io_timeout			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_tx_io_mode				(fd, -1, 0, GSC_IO_MODE_PIO,					NULL);
	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_NORMAL,			NULL);

	// Send data.
	sts		= sio4_write(fd, buf, sizeof(buf));
	errs	+= (sts < 0) ? 1 : 0;

	// Wait for the idle to be sent.
	os_sleep_ms(50);
	return(errs);
}



//*****************************************************************************
int usc_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


