// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/tx_fifo_full.c $
// $Rev: 23609 $
// $Date: 2013-10-18 09:23:41 -0500 (Fri, 18 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	s32	irq_32;
	int	ret;

	errs	= sio4_query(fd, SIO4_QUERY_IRQ_32, &irq_32);

	if (errs)
		ret	= errs;
	else if (irq_32)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	#define	D11	(1 << 11)

	char	buf[1024]	= "";
	int		errs		= 0;
	int		i;
	u32		reg;
	int		sts;

	// Generate a PCI interrupt: Tx FIFO Full
	errs	+= sio4_initialize		(fd, -1, 0, 1, NULL);
	errs	+= sio4_irq_gsc_enable	(fd, -1, 0, SIO4_IRQ_TX_FIFO_F, NULL);
	errs	+= sio4_tx_io_mode		(fd, -1, 0, GSC_IO_MODE_PIO, NULL);
	errs	+= sio4_tx_io_timeout	(fd, -1, 0, 0, NULL);

	for (i = 0;; i++)
	{
		sts	= sio4_write(fd, buf, sizeof(buf));

		if (sts < 0)
			break;

		errs	+= sio4_reg_read(fd, SIO4_GSC_CSR, &reg);

		if (errs)
			break;

		if ((reg & D11) == 0)
			break;

		if (i > 33000)
		{
			printf("FAIL <---  (Unable to fill Tx FIFO.)\n");
			errs++;
			break;
		}
	}

	return(errs);
}



//*****************************************************************************
int tx_fifo_full_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


