// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/tx_fifo_almost_empty.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	return(STATUS_SUPPORTED);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int		errs	= 0;
	long	i;

	// Generate a PCI interrupt: Tx FIFO Almost Empty
	errs	+= sio4_initialize		(fd, -1, 0, 1, NULL);
	errs	+= sio4_irq_gsc_enable	(fd, -1, 0, SIO4_IRQ_TX_FIFO_AE, NULL);

	for (i = 0; i <= 50; i++)
		errs	+= sio4_reg_write(fd, SIO4_GSC_FDR, 0);

	errs	+= sio4_tx_fifo_reset	(fd, -1, 0, 1, NULL);
	return(errs);
}



//*****************************************************************************
int tx_fifo_almost_empty_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


