// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/rx_spare.c $
// $Rev: 26105 $
// $Date: 2014-05-16 11:12:48 -0500 (Fri, 16 May 2014) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs	= 0;
	int	pstsr;
	int	ret;
	s32	z16c30;

	errs	+= sio4_query(fd, SIO4_QUERY_REG_PSTSR_BITS, &pstsr);
	errs	+= sio4_query(fd, SIO4_QUERY_MODEL_Z16C30, &z16c30);

	if (errs)
		ret	= errs;
	else if (z16c30)
		ret	= STATUS_NOT_SUPPORTED;
	else if ((pstsr & D8) && (pstsr & D9))
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int	errs	= 0;

	// Generate a PCI interrupt: Rx Spare
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize			(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_gsc_enable		(fd, -1, 0, SIO4_IRQ_RX_SPARE,					NULL);
	errs	+= sio4_loop_back			(fd, -1, 0, SIO4_LOOP_BACK_EXTERNAL,			NULL);
	errs	+= sio4_xcvr_enable			(fd, -1, 0, SIO4_XCVR_ENABLE_YES,				NULL);

	errs	+= sio4_sync_txsp_cfg		(fd, -1, 0, SIO4_SYNC_TXSP_CFG_OUT_0,			NULL);
	errs	+= sio4_sync_tx_enable		(fd, -1, 0, SIO4_SYNC_ENABLE_YES,				NULL);

	errs	+= sio4_sync_rx_enable		(fd, -1, 0, SIO4_SYNC_ENABLE_YES,				NULL);

	errs	+= sio4_sync_txsp_cfg		(fd, -1, 0, SIO4_SYNC_TXSP_CFG_OUT_0,			NULL);
	os_sleep_ms(10);
	errs	+= sio4_sync_txsp_cfg		(fd, -1, 0, SIO4_SYNC_TXSP_CFG_OUT_1,			NULL);
	os_sleep_ms(10);
	errs	+= sio4_sync_txsp_cfg		(fd, -1, 0, SIO4_SYNC_TXSP_CFG_OUT_0,			NULL);
	os_sleep_ms(10);
	errs	+= sio4_sync_txsp_cfg		(fd, -1, 0, SIO4_SYNC_TXSP_CFG_OUT_1,			NULL);

	return(errs);
}



//*****************************************************************************
int rx_spare_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


