// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/rx_fifo_almost_full.c $
// $Rev: 33936 $
// $Date: 2015-10-07 15:24:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	return(STATUS_SUPPORTED);
}



//*****************************************************************************
static int _irq_initiate_sync(int fd)
{
	char	buf[256]	= "";
	int		errs		= 0;
	int		loops;
	s32		sts;

	// Generate a PCI interrupt: Rx FIFO Almost Full
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize			(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_gsc_enable		(fd, -1, 0, SIO4_IRQ_RX_FIFO_AF,				NULL);
	errs	+= sio4_osc_program			(fd, -1, 0, 128000 * 2,							NULL);
	errs	+= sio4_loop_back			(fd, -1, 0, SIO4_LOOP_BACK_EXTERNAL,			NULL);
	errs	+= sio4_xcvr_protocol		(fd, -1, 0, SIO4_XCVR_PROTOCOL_RS232,			NULL);
	errs	+= sio4_xcvr_enable			(fd, -1, 0, SIO4_XCVR_ENABLE_YES,				NULL);

	errs	+= sio4_sync_txc_src		(fd, -1, 0, SIO4_SYNC_TXC_SRC_OSC_HALF_RISE,	NULL);
	errs	+= sio4_sync_txc_idle		(fd, -1, 0, SIO4_SYNC_TXC_IDLE_NO,				NULL);
	errs	+= sio4_sync_txc_idle_cfg	(fd, -1, 0, SIO4_SYNC_TXC_IDLE_CFG_ACTIVE,		NULL);
	errs	+= sio4_sync_txe_cfg		(fd, -1, 0, SIO4_SYNC_TXE_CFG_ACTIVE_HI,		NULL);
	errs	+= sio4_tx_fifo_af			(fd, -1, 0, 50,									NULL);
	errs	+= sio4_sync_tx_enable		(fd, -1, 0, SIO4_SYNC_ENABLE_YES,				NULL);

	errs	+= sio4_sync_rxe_cfg		(fd, -1, 0, SIO4_SYNC_RXE_CFG_DISABLE,			NULL);
	errs	+= sio4_rx_fifo_af			(fd, -1, 0, 0x80,								NULL);
	errs	+= sio4_sync_rx_enable		(fd, -1, 0, SIO4_SYNC_ENABLE_YES,				NULL);

	for (loops = 0; loops < 1000; loops++)
	{
		sts		= sio4_write(fd, buf, sizeof(buf));
		errs	+= (sts < 0) ? 1 : 0;

		os_sleep_ms(20);
		errs	+= sio4_rx_fifo_status(fd, -1, 0, -1, &sts);

		if (sts >= SIO4_FIFO_STATUS_ALMOST_FULL)
			break;
	}

	return(errs);
}



//*****************************************************************************
static int _irq_initiate_zilog(int fd)
{
	char	buf[256];
	int		errs	= 0;
	int		loops;
	s32		sts;

	memset(buf, 0, sizeof(buf));

	// Generate a GSC interrupt: Rx FIFO Almost Full
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize				(fd, -1, 0, 1,									NULL);
	errs	+= sio4_irq_gsc_enable			(fd, -1, 0, SIO4_IRQ_RX_FIFO_AF,				NULL);
	errs	+= sio4_osc_program				(fd, -1, 0, 20000000,							NULL);
	errs	+= sio4_z16_sync_byte			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_loop_back				(fd, -1, 0, SIO4_LOOP_BACK_DISABLE,				NULL);

	errs	+= sio4_z16_rx_sts_wrd_enable	(fd, -1, 0, SIO4_Z16_RX_STS_WRD_ENABLE_NO,		NULL);
	errs	+= sio4_rx_fifo_full_cfg		(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_OVER,			NULL);
	errs	+= sio4_rx_fifo_full_cfg_glb	(fd, -1, 0, SIO4_RX_FIFO_FULL_CFG_GLB_OVER,		NULL);
	errs	+= sio4_tx_fifo_empty_cfg		(fd, -1, 0, SIO4_TX_FIFO_EMPTY_CFG_IGNORE,		NULL);

	errs	+= sio4_usc_rx_mode				(fd, -1, 0, SIO4_USC_MODE_ASYNC,				NULL);
	errs	+= sio4_usc_async_rx_clk_rate	(fd, -1, 0, SIO4_USC_ASYNC_CLK_RATE_16X,		NULL);
	errs	+= sio4_usc_rx_char_len			(fd, -1, 0, SIO4_USC_CHAR_LEN_8,				NULL);
	errs	+= sio4_usc_rx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_usc_rx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZ,			NULL);
	errs	+= sio4_usc_rx_par_enable		(fd, -1, 0, SIO4_USC_PAR_ENABLE_NO,				NULL);

	errs	+= sio4_usc_tx_mode				(fd, -1, 0, SIO4_USC_MODE_ASYNC,				NULL);
	errs	+= sio4_usc_async_tx_clk_rate	(fd, -1, 0, SIO4_USC_ASYNC_CLK_RATE_16X,		NULL);
	errs	+= sio4_usc_async_tx_stop_bit	(fd, -1, 0, SIO4_USC_ASYNC_TX_STOP_BIT_1,		NULL);
	errs	+= sio4_usc_tx_char_len			(fd, -1, 0, SIO4_USC_CHAR_LEN_8,				NULL);
	errs	+= sio4_usc_tx_clk_src			(fd, -1, 0, SIO4_USC_CLK_SRC_TXC_PIN,			NULL);
	errs	+= sio4_usc_tx_data_encode		(fd, -1, 0, SIO4_USC_DATA_ENCODE_NRZ,			NULL);
	errs	+= sio4_usc_tx_idle_cond		(fd, -1, 0, SIO4_USC_TX_IDLE_COND_DEFAULT,		NULL);
	errs	+= sio4_usc_tx_par_enable		(fd, -1, 0, SIO4_USC_PAR_ENABLE_NO,				NULL);

	errs	+= sio4_usc_brg0_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,				NULL);
	errs	+= sio4_usc_brg1_enable			(fd, -1, 0, SIO4_USC_BRG_ENABLE_NO,				NULL);
	errs	+= sio4_usc_ctr0_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_DISABLE,		NULL);
	errs	+= sio4_usc_ctr1_clk_src		(fd, -1, 0, SIO4_USC_CTR_CLK_SRC_DISABLE,		NULL);
	errs	+= sio4_usc_dpll_mode			(fd, -1, 0, SIO4_USC_DPLL_MODE_DISABLE,			NULL);
	errs	+= sio4_usc_tc0					(fd, -1, 0, 0,									NULL);
	errs	+= sio4_usc_tc1					(fd, -1, 0, 0,									NULL);

	errs	+= sio4_cbl_mode				(fd, -1, 0, SIO4_CBL_MODE_DTE,					NULL);
	errs	+= sio4_xcvr_enable				(fd, -1, 0, SIO4_XCVR_ENABLE_NO,				NULL);
	errs	+= sio4_xcvr_protocol			(fd, -1, 0, SIO4_XCVR_PROTOCOL_DISABLE,			NULL);
	errs	+= sio4_z16_cbl_dcd_cfg			(fd, -1, 0, SIO4_Z16_CBL_DCD_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_cbl_dtr_dsr_cfg		(fd, -1, 0, SIO4_Z16_CBL_DTR_DSR_CFG_TRI,		NULL);
	errs	+= sio4_z16_cbl_rts_cfg			(fd, -1, 0, SIO4_Z16_CBL_RTS_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_cbl_txauxc_cfg		(fd, -1, 0, SIO4_Z16_CBL_TXAUXC_CFG_TRI,		NULL);
	errs	+= sio4_z16_cbl_txc_cfg			(fd, -1, 0, SIO4_Z16_CBL_TXC_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_cbl_txd_cfg			(fd, -1, 0, SIO4_Z16_CBL_TXD_CFG_OUT_0,			NULL);
	errs	+= sio4_z16_leg_rxc				(fd, -1, 0, SIO4_Z16_LEG_RXC_DISABLE,			NULL);
	errs	+= sio4_z16_leg_rxd_dcd_cfg		(fd, -1, 0, SIO4_Z16_LEG_RXD_DCD_CFG_TRI,		NULL);
	errs	+= sio4_z16_leg_txc				(fd, -1, 0, SIO4_Z16_LEG_TXC_DISABLE,			NULL);
	errs	+= sio4_z16_leg_txd_cts_cfg		(fd, -1, 0, SIO4_Z16_LEG_TXD_CTS_CFG_TRI,		NULL);

	errs	+= sio4_usc_cts_cfg				(fd, -1, 0, SIO4_USC_CTS_CFG_TRI,				NULL);
	errs	+= sio4_usc_dcd_cfg				(fd, -1, 0, SIO4_USC_DCD_CFG_DISABLE,			NULL);
	errs	+= sio4_usc_rxc_cfg				(fd, -1, 0, SIO4_USC_RXC_CFG_IN_0,				NULL);
	errs	+= sio4_usc_txc_cfg				(fd, -1, 0, SIO4_USC_TXC_CFG_IN_OSC,			NULL);
	errs	+= sio4_usc_txd_cfg				(fd, -1, 0, SIO4_USC_TXD_CFG_OUT_TXD,			NULL);

	errs	+= sio4_tx_io_timeout			(fd, -1, 0, 0,									NULL);
	errs	+= sio4_tx_io_mode				(fd, -1, 0, GSC_IO_MODE_PIO,					NULL);
	errs	+= sio4_usc_tx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);

	errs	+= sio4_usc_rx_enable			(fd, -1, 0, SIO4_USC_ENABLE_YES_NOW,			NULL);
	errs	+= sio4_usc_oper_mode			(fd, -1, 0, SIO4_USC_OPER_MODE_INT_LOOPBACK,	NULL);

	for (loops = 0; loops < 1000; loops++)
	{
		sts		= sio4_write(fd, buf, sizeof(buf));
		errs	+= (sts < 0) ? 1 : 0;

		os_sleep_ms(20);
		errs	+= sio4_rx_fifo_status(fd, -1, 0, -1, &sts);

		if (sts >= SIO4_FIFO_STATUS_ALMOST_FULL)
			break;
	}

	return(errs);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int	errs;
	int	sync;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_SYNC, &sync);

	if (errs)
		;
	else if (sync)
		errs	= _irq_initiate_sync(fd);
	else
		errs	= _irq_initiate_zilog(fd);

	return(errs);

}



//*****************************************************************************
int rx_fifo_almost_full_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


