// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/rx_envelope.c $
// $Rev: 23414 $
// $Date: 2013-10-11 10:19:35 -0500 (Fri, 11 Oct 2013) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	int	errs;
	int	ret;
	s32	sync;

	errs	= sio4_query(fd, SIO4_QUERY_MODEL_SYNC, &sync);

	if (errs)
		ret	= errs;
	else if (sync)
		ret	= STATUS_SUPPORTED;
	else
		ret	= STATUS_NOT_SUPPORTED;

	return(ret);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	int	errs	= 0;

	// Generate a PCI interrupt: Rx Envelope
	// Setup the channel for loopback operation.
	errs	+= sio4_initialize			(fd, -1, 0, 1,								NULL);
	errs	+= sio4_irq_gsc_enable		(fd, -1, 0, SIO4_IRQ_RX_ENV,				NULL);

	errs	+= sio4_loop_back			(fd, -1, 0, SIO4_LOOP_BACK_EXTERNAL,		NULL);
	errs	+= sio4_xcvr_protocol		(fd, -1, 0, SIO4_XCVR_PROTOCOL_RS232,		NULL);
	errs	+= sio4_xcvr_enable			(fd, -1, 0, SIO4_XCVR_ENABLE_YES,			NULL);

	errs	+= sio4_sync_txe_cfg		(fd, -1, 0, SIO4_SYNC_TXE_CFG_OUT_1,		NULL);
	errs	+= sio4_sync_tx_enable		(fd, -1, 0, SIO4_SYNC_ENABLE_YES,			NULL);

	errs	+= sio4_sync_rxe_cfg		(fd, -1, 0, SIO4_SYNC_RXE_CFG_ACTIVE_HI,	NULL);
	errs	+= sio4_sync_rx_enable		(fd, -1, 0, SIO4_SYNC_ENABLE_YES,			NULL);

	errs	+= sio4_sync_txe_cfg		(fd, -1, 0, SIO4_SYNC_TXE_CFG_OUT_1,		NULL);
	os_sleep_ms(10);
	errs	+= sio4_sync_txe_cfg		(fd, -1, 0, SIO4_SYNC_TXE_CFG_OUT_0,		NULL);
	os_sleep_ms(10);
	errs	+= sio4_sync_txe_cfg		(fd, -1, 0, SIO4_SYNC_TXE_CFG_OUT_1,		NULL);
	os_sleep_ms(10);
	errs	+= sio4_sync_txe_cfg		(fd, -1, 0, SIO4_SYNC_TXE_CFG_OUT_0,		NULL);

	return(errs);
}



//*****************************************************************************
int rx_envelope_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


