// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/main_dma.c $
// $Rev: 33936 $
// $Date: 2015-10-07 15:24:29 -0500 (Wed, 07 Oct 2015) $

#include "main.h"



//*****************************************************************************
static int _irq_check_support(int fd)
{
	return(STATUS_SUPPORTED);
}



//*****************************************************************************
static int _irq_initiate(int fd)
{
	char	buf[200]	= "";
	int		errs		= 0;
	int		sts;

	// Generate a DMA interrupt.
	errs	+= sio4_initialize	(fd, -1, 0, 1, NULL);
	errs	+= sio4_tx_io_mode	(fd, -1, 0, GSC_IO_MODE_DMA, NULL);
	sts		= sio4_write(fd, buf, sizeof(buf));

	if ((sts < 0) || (sts != sizeof(buf)))
	{
		errs++;
		printf("ERROR: sio4_write() failure\n");
	}

	return(errs);
}



//*****************************************************************************
int main_dma_irq_test(int fd, int supported)
{
	int	ret;

	if (supported)
		ret	= _irq_check_support(fd);
	else
		ret	= _irq_initiate(fd);

	return(ret);
}


