// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/irq/main.h $
// $Rev: 33971 $
// $Date: 2015-11-05 18:55:28 -0600 (Thu, 05 Nov 2015) $

#ifndef __MAIN_H__
#define __MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "sio4_lib.h"
#include "sio4_dsl.h"
#include "sio4_utils.h"



// #defines *******************************************************************

#define	VERSION			"2.11"
// 2.11	Removed a useless call.
// 2.10	Set the default channel selection to zero.
// 2.9	Updated per changes to API prototypes and return values.
//		Simplified error messages.
// 2.8	Fixed a bug in the Rx Spare detection logic.
// 2.7	Changed the output indenting.
//		Z16C30 interrupt tests are performed only when supported.
// 2.6	Additional LINTing.
// 2.5	LINTing for INtime.
// 2.4	LINTed the sources.
//		Channel selection is now required on the command line.
//		Updated open/close error handling.
//		Corrected continuous testing error when using the -C command line option.
//		Updated the TX FIFO Full IRQ test to accommodate older firmware.
//		Renamed numerous test routines and source file names.
//		Made corrections to the USC Rx Break/Abort test.
// 2.3	Updated the displayed output for proper alignment.
// 2.2	Modified per changes to common utility code.
//		EXIT_FAILURE is now returned for any error occurrence.
//		Added where needed: SIO4_IOCTL_RX_FIFO_FULL_CFG_GLB
//		Updated the prototype for sio4_id_board.
//		Updated the help text.
// 2.1	Added more tests.
// 2.0	Ported to the 2.x driver.

#define	STATUS_NOT_IMPLEMENTED		(-2)
#define	STATUS_NOT_SUPPORTED		(-1)
#define	STATUS_SUPPORTED			(0)

#define	D8							(1 << 8)
#define	D9							(1 << 9)



// prototypes *****************************************************************

int		irq_tests(int fd);

int		main_dma_irq_test(int fd, int supported);
int		main_gsc_irq_test(int fd, int supported);
int		main_pci_irq_test(int fd, int supported);

int		rx_envelope_test(int fd, int supported);
int		rx_fifo_almost_full_test(int fd, int supported);
int		rx_fifo_empty_test(int fd, int supported);
int		rx_fifo_full_test(int fd, int supported);
int		rx_spare_test(int fd, int supported);

int		sync_detected_test(int fd, int supported);

int		tx_fifo_almost_empty_test(int fd, int supported);
int		tx_fifo_empty_test(int fd, int supported);
int		tx_fifo_full_test(int fd, int supported);

int		usc_brg0_zero_test(int fd, int supported);
int		usc_brg1_zero_test(int fd, int supported);
int		usc_cts_down_test(int fd, int supported);
int		usc_cts_up_test(int fd, int supported);
int		usc_dcd_down_test(int fd, int supported);
int		usc_dcd_up_test(int fd, int supported);
int		usc_dpll_desync_test(int fd, int supported);
int		usc_rcc_underrun_test(int fd, int supported);
int		usc_rx_abort_pe_test(int fd, int supported);
int		usc_rx_bound_test(int fd, int supported);
int		usc_rx_break_abort_test(int fd, int supported);
int		usc_rx_data_test(int fd, int supported);
int		usc_rx_exited_hunt_test(int fd, int supported);
int		usc_rx_idle_received_test(int fd, int supported);
int		usc_rx_overrun_test(int fd, int supported);
int		usc_rxc_down_test(int fd, int supported);
int		usc_rxc_up_test(int fd, int supported);
int		usc_rxreq_down_test(int fd, int supported);
int		usc_rxreq_up_test(int fd, int supported);
int		usc_test(int fd, int supported);
int		usc_tx_abort_sent_test(int fd, int supported);
int		usc_tx_crc_sent_test(int fd, int supported);
int		usc_tx_data_test(int fd, int supported);
int		usc_tx_eof_eom_sent_test(int fd, int supported);
int		usc_tx_idle_sent_test(int fd, int supported);
int		usc_tx_preamble_sent_test(int fd, int supported);
int		usc_tx_underrun_test(int fd, int supported);
int		usc_txc_down_test(int fd, int supported);
int		usc_txc_up_test(int fd, int supported);
int		usc_txreq_down_test(int fd, int supported);
int		usc_txreq_up_test(int fd, int supported);



#endif
