// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/utils/sio4_utils.h $
// $Rev: 32491 $
// $Date: 2015-07-04 15:05:04 -0500 (Sat, 04 Jul 2015) $

#ifndef __SIO4_UTILS_H__
#define	__SIO4_UTILS_H__

#include "sio4_lib.h"
#include "sio4_dsl.h"
#include "gsc_utils.h"


// prototypes *****************************************************************


int	sio4_cbl_mode(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_CBL_MODE
int	sio4_cbl_pin_status(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_CBL_PIN_STATUS

int	sio4_dev_close(int fd, int index, int verbose);
int	sio4_dev_open(int index, int show_index, int verbose);

int	sio4_fifo_space_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_FIFO_SPACE_CFG

int	sio4_gpio_direction_out(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_GPIO_DIRECTION_OUT
int	sio4_gpio_input_latching(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_GPIO_INPUT_LATCHING
int	sio4_gpio_input_read(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_GPIO_INPUT_READ
int	sio4_gpio_output_write(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_GPIO_OUTPUT_WRITE
int	sio4_gpio_polarity(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_GPIO_POLARITY
int	sio4_gpio_sense_edge(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_GPIO_SENSE_EDGE

int	sio4_id_board(int fd, int index);
int	sio4_id_fifo_size_total(int fd, int dash, const char** name);
int	sio4_id_form_factor(int fd, const char** name, int dash);
int	sio4_id_model(int fd, const char** name);
int	sio4_id_type(int fd, const char** name);
int	sio4_initialize(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_INITIALIZE
int	sio4_irq_gsc_cfg_high(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_IRQ_GSC_CFG_HIGH
int	sio4_irq_gsc_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_IRQ_GSC_ENABLE
int	sio4_irq_usc_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_IRQ_USC_ENABLE

int	sio4_led_channel(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_LED_CHANNEL
int	sio4_led_main(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_LED_MAIN
int	sio4_loop_back(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_LOOP_BACK

int	sio4_osc_measure(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_OSC_MEASURE
int	sio4_osc_program(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_OSC_PROGRAM
int	sio4_osc_reference(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_OSC_REFERENCE

int	sio4_query(int fd, s32 set, s32* get);											// SIO4_IOCTL_QUERY

int	sio4_reg_list(int fd, int gsc, int gsc_detail, int usc, int usc_detail);
int	sio4_reg_list_cy22393(int fd, int cy22393, int detail);
int	sio4_reg_mod(int fd, u32 reg, u32 set, u32 mask);								// SIO4_IOCTL_REG_MOD
int	sio4_reg_read(int fd, u32 reg, u32* get);										// SIO4_IOCTL_REG_READ
int	sio4_reg_read_raw(int fd, u32 index, u32* get);									// SIO4_IOCTL_REG_READ_RAW
int	sio4_reg_write(int fd, u32 reg, u32 set);										// SIO4_IOCTL_REG_WRITE

int	sio4_rx_fifo_ae(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_RX_FIFO_AE
int	sio4_rx_fifo_af(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_RX_FIFO_AF
int	sio4_rx_fifo_fill_level(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_RX_FIFO_FILL_LEVEL
int	sio4_rx_fifo_full_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_RX_FIFO_FULL_CFG
int	sio4_rx_fifo_full_cfg_glb(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_RX_FIFO_FULL_CFG_GLB
int	sio4_rx_fifo_overrun(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_RX_FIFO_OVERRUN
int	sio4_rx_fifo_reset(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_RX_FIFO_RESET
int	sio4_rx_fifo_status(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_RX_FIFO_STATUS
int	sio4_rx_fifo_underrun(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_RX_FIFO_UNDERRUN
int	sio4_rx_io_abort(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_RX_IO_ABORT
int	sio4_rx_io_mode(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_RX_IO_MODE
int	sio4_rx_io_overrun(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_RX_IO_OVERRUN
int	sio4_rx_io_pio_threshold(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_RX_IO_PIO_THRESHOLD
int	sio4_rx_io_timeout(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_RX_IO_TIMEOUT
int	sio4_rx_io_underrun(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_RX_IO_UNDERRUN

int	sio4_sync_leg_rxd_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_LEG_RXD_CFG
int	sio4_sync_leg_txd_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_LEG_TXD_CFG
int	sio4_sync_mode(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_SYNC_MODE
int	sio4_sync_rx_bit_count(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_RX_BIT_COUNT
int	sio4_sync_rx_bit_order(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_RX_BIT_ORDER
int	sio4_sync_rx_count_error(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_SYNC_RX_COUNT_ERROR
int	sio4_sync_rx_count_reset(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_SYNC_RX_COUNT_RESET
int	sio4_sync_rx_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RX_ENABLE
int	sio4_sync_rx_gap_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_RX_GAP_ENABLE
int	sio4_sync_rxc_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RXC_CFG
int	sio4_sync_rxc_leg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RXC_LEG
int	sio4_sync_rxc_pol(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RXC_POL
int	sio4_sync_rxd_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RXD_CFG
int	sio4_sync_rxe_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RXE_CFG
int	sio4_sync_rxe_pol(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_RXE_POL
int	sio4_sync_tx_bit_order(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_TX_BIT_ORDER
int	sio4_sync_tx_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TX_ENABLE
int	sio4_sync_tx_gap_size(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_TX_GAP_SIZE
int	sio4_sync_tx_word_size(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_TX_WORD_SIZE
int	sio4_sync_txauxc_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_TXAUXC_CFG
int	sio4_sync_txc_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXC_CFG
int	sio4_sync_txc_idle(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXC_IDLE
int	sio4_sync_txc_idle_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_TXC_IDLE_CFG
int	sio4_sync_txc_pol(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXC_POL
int	sio4_sync_txc_src(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXC_SRC
int	sio4_sync_txd_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXD_CFG
int	sio4_sync_txd_idle_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_SYNC_TXD_IDLE_CFG
int	sio4_sync_txe_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXE_CFG
int	sio4_sync_txe_pol(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXE_POL
int	sio4_sync_txsp_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_SYNC_TXSP_CFG

int	sio4_time_stamp_count(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_TIME_STAMP_COUNT
int	sio4_time_stamp_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_TIME_STAMP_ENABLE
int	sio4_time_stamp_src(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TIME_STAMP_SRC
int	sio4_time_stamp_val(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TIME_STAMP_VAL
int	sio4_tx_fifo_ae(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_TX_FIFO_AE
int	sio4_tx_fifo_af(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_TX_FIFO_AF
int	sio4_tx_fifo_empty_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_TX_FIFO_EMPTY_CFG
int	sio4_tx_fifo_fill_level(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_TX_FIFO_FILL_LEVEL
int	sio4_tx_fifo_overrun(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_TX_FIFO_OVERRUN
int	sio4_tx_fifo_reset(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TX_FIFO_RESET
int	sio4_tx_fifo_status(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TX_FIFO_STATUS
int	sio4_tx_io_abort(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TX_IO_ABORT
int	sio4_tx_io_mode(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_TX_IO_MODE
int	sio4_tx_io_overrun(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TX_IO_OVERRUN
int	sio4_tx_io_pio_threshold(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_TX_IO_PIO_THRESHOLD
int	sio4_tx_io_timeout(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_TX_IO_TIMEOUT

int	sio4_usc_8023_rx_adrs_srch(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_8023_RX_ADRS_SRCH
int	sio4_usc_8023_tx_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_8023_TX_UNDERRUN
int	sio4_usc_accept_cv(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_ACCEPT_CV
int	sio4_usc_acv_rx_ext_w(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_ACV_RX_EXT_W
int	sio4_usc_acv_tx_cv_pol(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_ACV_TX_CV_POL
int	sio4_usc_acv_tx_ext_w(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_ACV_TX_EXT_W
int	sio4_usc_acv_tx_stop_bit(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_ACV_TX_STOP_BIT
int	sio4_usc_async_rx_clk_rate(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_ASYNC_RX_CLK_RATE
int	sio4_usc_async_tx_clk_rate(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_ASYNC_TX_CLK_RATE
int	sio4_usc_async_tx_stop_bit(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_ASYNC_TX_STOP_BIT
int	sio4_usc_brg0_clk_src(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BRG0_CLK_SRC
int	sio4_usc_brg0_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BRG0_ENABLE
int	sio4_usc_brg0_mode(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_BRG0_MODE
int	sio4_usc_brg1_clk_src(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BRG1_CLK_SRC
int	sio4_usc_brg1_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BRG1_ENABLE
int	sio4_usc_brg1_mode(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_BRG1_MODE
int	sio4_usc_bsc_rx_short(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_RX_SHORT
int	sio4_usc_bsc_rx_strip(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_RX_STRIP
int	sio4_usc_bsc_rx_syn0(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_RX_SYN0
int	sio4_usc_bsc_rx_syn1(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_RX_SYN1
int	sio4_usc_bsc_tx_preamble(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_BSC_TX_PREAMBLE
int	sio4_usc_bsc_tx_short(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_TX_SHORT
int	sio4_usc_bsc_tx_syn0(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_TX_SYN0
int	sio4_usc_bsc_tx_syn1(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_BSC_TX_SYN1
int	sio4_usc_bsc_tx_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_BSC_TX_UNDERRUN
int	sio4_usc_ctr0_clk_src(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_CTR0_CLK_SRC
int	sio4_usc_ctr0_rate(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_CTR0_RATE
int	sio4_usc_ctr1_clk_src(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_CTR1_CLK_SRC
int	sio4_usc_ctr1_rate(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_CTR1_RATE
int	sio4_usc_cts_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_CTS_CFG
int	sio4_usc_cts_leg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_CTS_LEG
int	sio4_usc_dcd_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_DCD_CFG
int	sio4_usc_dcd_leg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_DCD_LEG
int	sio4_usc_dpll_adj_sync(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_DPLL_ADJ_SYNC
int	sio4_usc_dpll_clk_src(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_DPLL_CLK_SRC
int	sio4_usc_dpll_miss_1(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_DPLL_MISS_1
int	sio4_usc_dpll_miss_2(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_DPLL_MISS_2
int	sio4_usc_dpll_mode(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_DPLL_MODE
int	sio4_usc_dpll_rate(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_DPLL_RATE
int	sio4_usc_dpll_sync(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_DPLL_SYNC
int	sio4_usc_hdlc_rx_adrs_ctrl(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLC_RX_ADRS_CTRL
int	sio4_usc_hdlc_tx_l_chr_len(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLC_TX_L_CHR_LEN
int	sio4_usc_hdlc_tx_preamble(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLC_TX_PREAMBLE
int	sio4_usc_hdlc_tx_share_0(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLC_TX_SHARE_0
int	sio4_usc_hdlc_tx_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLC_TX_UNDERRUN
int	sio4_usc_hdlcl_tx_active(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLCL_TX_ACTIVE
int	sio4_usc_hdlcl_tx_share_0(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLCL_TX_SHARE_0
int	sio4_usc_hdlcl_tx_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_HDLCL_TX_UNDERRUN
int	sio4_usc_isoc_tx_stop_bit(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_ISOC_TX_STOP_BIT
int	sio4_usc_loop_sending(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_LOOP_SENDING
int	sio4_usc_mono_rx_short(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_MONO_RX_SHORT
int	sio4_usc_mono_rx_strip(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_MONO_RX_STRIP
int	sio4_usc_mono_rx_sync(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_MONO_RX_SYNC
int	sio4_usc_mono_tx_crc_under(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_MONO_TX_CRC_UNDER
int	sio4_usc_mono_tx_preamble(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_MONO_TX_PREAMBLE
int	sio4_usc_mono_tx_short(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_MONO_TX_SHORT
int	sio4_usc_mono_tx_sync(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_MONO_TX_SYNC
int	sio4_usc_nbip_rx_clk_rate(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_NBIP_RX_CLK_RATE
int	sio4_usc_nbip_rx_parity(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_NBIP_RX_PARITY
int	sio4_usc_nbip_tx_adrs_bit(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_NBIP_TX_ADRS_BIT
int	sio4_usc_nbip_tx_clk_rate(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_NBIP_TX_CLK_RATE
int	sio4_usc_nbip_tx_parity(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_NBIP_TX_PARITY
int	sio4_usc_on_loop(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_ON_LOOP
int	sio4_usc_oper_mode(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_OPER_MODE
int	sio4_usc_rcc_fifo_clear(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RCC_FIFO_CLEAR
int	sio4_usc_rcc_fifo_overrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_RCC_FIFO_OVERRUN
int	sio4_usc_rcc_fifo_valid(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RCC_FIFO_VALID
int	sio4_usc_reset(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_USC_RESET
int	sio4_usc_rx_char_cnt(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_CHAR_CNT
int	sio4_usc_rx_char_cnt_lim(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_RX_CHAR_CNT_LIM
int	sio4_usc_rx_char_len(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_CHAR_LEN
int	sio4_usc_rx_clk_src(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_RX_CLK_SRC
int	sio4_usc_rx_cmd(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_USC_RX_CMD
int	sio4_usc_rx_crc_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_CRC_ENABLE
int	sio4_usc_rx_crc_preset(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_CRC_PRESET
int	sio4_usc_rx_crc_type(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_CRC_TYPE
int	sio4_usc_rx_data_encode(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_DATA_ENCODE
int	sio4_usc_rx_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_RX_ENABLE
int	sio4_usc_rx_mode(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_RX_MODE
int	sio4_usc_rx_par_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_PAR_ENABLE
int	sio4_usc_rx_par_type(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_PAR_TYPE
int	sio4_usc_rx_queue_abort(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_RX_QUEUE_ABORT
int	sio4_usc_rx_status(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_RX_STATUS
int	sio4_usc_rx_status_block(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_RX_STATUS_BLOCK
int	sio4_usc_rx_wait_dma_trig(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_RX_WAIT_DMA_TRIG
int	sio4_usc_rxc_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_RXC_CFG
int	sio4_usc_rxc_leg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_RXC_LEG
int	sio4_usc_send_command(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_SEND_COMMAND
int	sio4_usc_smono_rx_sync(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_SMONO_RX_SYNC
int	sio4_usc_smono_tx_active(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_SMONO_TX_ACTIVE
int	sio4_usc_smono_tx_short(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_SMONO_TX_SHORT
int	sio4_usc_smono_tx_sync(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_SMONO_TX_SYNC
int	sio4_usc_smono_tx_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_SMONO_TX_UNDERRUN
int	sio4_usc_tbsc_rx_encoding(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TBSC_RX_ENCODING
int	sio4_usc_tbsc_tx_encoding(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TBSC_TX_ENCODING
int	sio4_usc_tbsc_tx_preamble(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TBSC_TX_PREAMBLE
int	sio4_usc_tbsc_tx_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TBSC_TX_UNDERRUN
int	sio4_usc_tc0(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_USC_TC0
int	sio4_usc_tc1(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_USC_TC1
int	sio4_usc_tx_char_cnt(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CHAR_CNT
int	sio4_usc_tx_char_cnt_lim(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TX_CHAR_CNT_LIM
int	sio4_usc_tx_char_len(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CHAR_LEN
int	sio4_usc_tx_clk_src(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_TX_CLK_SRC
int	sio4_usc_tx_cmd(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_USC_TX_CMD
int	sio4_usc_tx_crc_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CRC_ENABLE
int	sio4_usc_tx_crc_on_end(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CRC_ON_END
int	sio4_usc_tx_crc_preset(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CRC_PRESET
int	sio4_usc_tx_crc_type(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CRC_TYPE
int	sio4_usc_tx_ctrl_block(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_CTRL_BLOCK
int	sio4_usc_tx_data_encode(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_DATA_ENCODE
int	sio4_usc_tx_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_TX_ENABLE
int	sio4_usc_tx_idle_cond(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_IDLE_COND
int	sio4_usc_tx_mode(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_TX_MODE
int	sio4_usc_tx_par_enable(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_PAR_ENABLE
int	sio4_usc_tx_par_type(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_USC_TX_PAR_TYPE
int	sio4_usc_tx_preamble_flag(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TX_PREAMBLE_FLAG
int	sio4_usc_tx_preamble_len(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TX_PREAMBLE_LEN
int	sio4_usc_tx_preamble_pat(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TX_PREAMBLE_PAT
int	sio4_usc_tx_status(int fd, int index, int verbose, s32* get);					// SIO4_IOCTL_USC_TX_STATUS
int	sio4_usc_tx_wait_dma_trig(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TX_WAIT_DMA_TRIG
int	sio4_usc_tx_wait_underrun(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_USC_TX_WAIT_UNDERRUN
int	sio4_usc_txc_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_TXC_CFG
int	sio4_usc_txc_leg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_TXC_LEG
int	sio4_usc_txd_cfg(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_USC_TXD_CFG

int	sio4_wait_cancel(int fd, gsc_wait_t* wait);										// SIO4_IOCTL_WAIT_CANCEL
int	sio4_wait_event(int fd, gsc_wait_t* wait);										// SIO4_IOCTL_WAIT_EVENT
int	sio4_wait_status(int fd, gsc_wait_t* wait);										// SIO4_IOCTL_WAIT_STATUS

int	sio4_xcvr_enable(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_XCVR_ENABLE
int	sio4_xcvr_protocol(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_XCVR_PROTOCOL
int	sio4_xcvr_term(int fd, int index, int verbose, s32 set, s32* get);				// SIO4_IOCTL_XCVR_TERM

int	sio4_z16_cbl_dcd_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_Z16_CBL_DCD_CFG
int	sio4_z16_cbl_dtr_dsr_cfg(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_Z16_CBL_DTR_DSR_CFG
int	sio4_z16_cbl_rts_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_Z16_CBL_RTS_CFG
int	sio4_z16_cbl_txauxc_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_Z16_CBL_TXAUXC_CFG
int	sio4_z16_cbl_txc_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_Z16_CBL_TXC_CFG
int	sio4_z16_cbl_txd_cfg(int fd, int index, int verbose, s32 set, s32* get);		// SIO4_IOCTL_Z16_CBL_TXD_CFG
int	sio4_z16_leg_rxc(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_Z16_LEG_RXC
int	sio4_z16_leg_rxd_dcd_cfg(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_Z16_LEG_RXD_DCD_CFG
int	sio4_z16_leg_txc(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_Z16_LEG_TXC
int	sio4_z16_leg_txd_cts_cfg(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_Z16_LEG_TXD_CTS_CFG
int	sio4_z16_rx_sts_wrd_enable(int fd, int index, int verbose, s32 set, s32* get);	// SIO4_IOCTL_Z16_RX_STS_WRD_ENABLE
int	sio4_z16_sync_byte(int fd, int index, int verbose, s32 set, s32* get);			// SIO4_IOCTL_Z16_SYNC_BYTE

const gsc_reg_def_t*	sio4_reg_get_def_id(int reg);
const gsc_reg_def_t*	sio4_reg_get_def_index(int index);
const char*				sio4_reg_get_desc(int reg);
const char*				sio4_reg_get_name(int reg);


#endif
