// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/driver/sio4_usc.h $
// $Rev: 31491 $
// $Date: 2014-12-04 13:29:58 -0600 (Thu, 04 Dec 2014) $

#ifndef __SIO4_USC_H__
#define __SIO4_USC_H__



#define SIO4_IOCTL_USC_8023_RX_ADRS_SRCH	OS_IOCTL_RW(100, 4, s32)
#define SIO4_IOCTL_USC_8023_TX_UNDERRUN		OS_IOCTL_RW(101, 4, s32)
#define SIO4_IOCTL_USC_ACCEPT_CV			OS_IOCTL_RW(102, 4, s32)
#define SIO4_IOCTL_USC_ACV_RX_EXT_W			OS_IOCTL_RW(103, 4, s32)
#define SIO4_IOCTL_USC_ACV_TX_CV_POL		OS_IOCTL_RW(104, 4, s32)
#define SIO4_IOCTL_USC_ACV_TX_EXT_W			OS_IOCTL_RW(105, 4, s32)
#define SIO4_IOCTL_USC_ACV_TX_STOP_BIT		OS_IOCTL_RW(106, 4, s32)
#define SIO4_IOCTL_USC_ASYNC_RX_CLK_RATE	OS_IOCTL_RW(107, 4, s32)
#define SIO4_IOCTL_USC_ASYNC_TX_CLK_RATE	OS_IOCTL_RW(108, 4, s32)
#define SIO4_IOCTL_USC_ASYNC_TX_STOP_BIT	OS_IOCTL_RW(109, 4, s32)

#define SIO4_IOCTL_USC_BRG0_CLK_SRC			OS_IOCTL_RW(110, 4, s32)
#define SIO4_IOCTL_USC_BRG0_ENABLE			OS_IOCTL_RW(111, 4, s32)
#define SIO4_IOCTL_USC_BRG0_MODE			OS_IOCTL_RW(112, 4, s32)
#define SIO4_IOCTL_USC_BRG1_CLK_SRC			OS_IOCTL_RW(113, 4, s32)
#define SIO4_IOCTL_USC_BRG1_ENABLE			OS_IOCTL_RW(114, 4, s32)
#define SIO4_IOCTL_USC_BRG1_MODE			OS_IOCTL_RW(115, 4, s32)
#define SIO4_IOCTL_USC_BSC_RX_SHORT			OS_IOCTL_RW(116, 4, s32)
#define SIO4_IOCTL_USC_BSC_RX_STRIP			OS_IOCTL_RW(117, 4, s32)
#define SIO4_IOCTL_USC_BSC_RX_SYN0			OS_IOCTL_RW(118, 4, s32)
#define SIO4_IOCTL_USC_BSC_RX_SYN1			OS_IOCTL_RW(119, 4, s32)

#define SIO4_IOCTL_USC_BSC_TX_PREAMBLE		OS_IOCTL_RW(120, 4, s32)
#define SIO4_IOCTL_USC_BSC_TX_SHORT			OS_IOCTL_RW(121, 4, s32)
#define SIO4_IOCTL_USC_BSC_TX_SYN0			OS_IOCTL_RW(122, 4, s32)
#define SIO4_IOCTL_USC_BSC_TX_SYN1			OS_IOCTL_RW(123, 4, s32)
#define SIO4_IOCTL_USC_BSC_TX_UNDERRUN		OS_IOCTL_RW(124, 4, s32)
#define SIO4_IOCTL_USC_CTR0_CLK_SRC			OS_IOCTL_RW(125, 4, s32)
#define SIO4_IOCTL_USC_CTR0_RATE			OS_IOCTL_RW(126, 4, s32)
#define SIO4_IOCTL_USC_CTR1_CLK_SRC			OS_IOCTL_RW(127, 4, s32)
#define SIO4_IOCTL_USC_CTR1_RATE			OS_IOCTL_RW(128, 4, s32)
#define SIO4_IOCTL_USC_CTS_CFG				OS_IOCTL_RW(129, 4, s32)

#define SIO4_IOCTL_USC_DCD_CFG				OS_IOCTL_RW(130, 4, s32)
#define SIO4_IOCTL_USC_DPLL_ADJ_SYNC		OS_IOCTL_RW(131, 4, s32)
#define SIO4_IOCTL_USC_DPLL_CLK_SRC			OS_IOCTL_RW(132, 4, s32)
#define SIO4_IOCTL_USC_DPLL_MISS_1			OS_IOCTL_RW(133, 4, s32)
#define SIO4_IOCTL_USC_DPLL_MISS_2			OS_IOCTL_RW(134, 4, s32)
#define SIO4_IOCTL_USC_DPLL_MODE			OS_IOCTL_RW(135, 4, s32)
#define SIO4_IOCTL_USC_DPLL_RATE			OS_IOCTL_RW(136, 4, s32)
#define SIO4_IOCTL_USC_DPLL_SYNC			OS_IOCTL_RW(137, 4, s32)
#define SIO4_IOCTL_USC_HDLC_RX_ADRS_CTRL	OS_IOCTL_RW(138, 4, s32)
#define SIO4_IOCTL_USC_HDLC_TX_L_CHR_LEN	OS_IOCTL_RW(139, 4, s32)

#define SIO4_IOCTL_USC_HDLC_TX_PREAMBLE		OS_IOCTL_RW(140, 4, s32)
#define SIO4_IOCTL_USC_HDLC_TX_SHARE_0		OS_IOCTL_RW(141, 4, s32)
#define SIO4_IOCTL_USC_HDLC_TX_UNDERRUN		OS_IOCTL_RW(142, 4, s32)
#define SIO4_IOCTL_USC_HDLCL_TX_ACTIVE		OS_IOCTL_RW(143, 4, s32)
#define SIO4_IOCTL_USC_HDLCL_TX_SHARE_0		OS_IOCTL_RW(144, 4, s32)
#define SIO4_IOCTL_USC_HDLCL_TX_UNDERRUN	OS_IOCTL_RW(145, 4, s32)
#define SIO4_IOCTL_USC_ISOC_TX_STOP_BIT		OS_IOCTL_RW(146, 4, s32)
#define SIO4_IOCTL_USC_LOOP_SENDING			OS_IOCTL_RW(147, 4, s32)
#define SIO4_IOCTL_USC_MONO_RX_SHORT		OS_IOCTL_RW(148, 4, s32)
#define SIO4_IOCTL_USC_MONO_RX_STRIP		OS_IOCTL_RW(149, 4, s32)

#define SIO4_IOCTL_USC_MONO_RX_SYNC			OS_IOCTL_RW(150, 4, s32)
#define SIO4_IOCTL_USC_MONO_TX_CRC_UNDER	OS_IOCTL_RW(151, 4, s32)
#define SIO4_IOCTL_USC_MONO_TX_PREAMBLE		OS_IOCTL_RW(152, 4, s32)
#define SIO4_IOCTL_USC_MONO_TX_SHORT		OS_IOCTL_RW(153, 4, s32)
#define SIO4_IOCTL_USC_MONO_TX_SYNC			OS_IOCTL_RW(154, 4, s32)
#define SIO4_IOCTL_USC_NBIP_RX_CLK_RATE		OS_IOCTL_RW(155, 4, s32)
#define SIO4_IOCTL_USC_NBIP_RX_PARITY		OS_IOCTL_RW(156, 4, s32)
#define SIO4_IOCTL_USC_NBIP_TX_ADRS_BIT		OS_IOCTL_RW(157, 4, s32)
#define SIO4_IOCTL_USC_NBIP_TX_CLK_RATE		OS_IOCTL_RW(158, 4, s32)
#define SIO4_IOCTL_USC_NBIP_TX_PARITY		OS_IOCTL_RW(159, 4, s32)

#define SIO4_IOCTL_USC_ON_LOOP				OS_IOCTL_RW(160, 4, s32)
#define SIO4_IOCTL_USC_OPER_MODE			OS_IOCTL_RW(161, 4, s32)
#define SIO4_IOCTL_USC_RCC_FIFO_CLEAR		OS_IOCTL_RW(162, 4, s32)
#define SIO4_IOCTL_USC_RCC_FIFO_OVERRUN		OS_IOCTL_RW(163, 4, s32)
#define SIO4_IOCTL_USC_RCC_FIFO_VALID		OS_IOCTL_RW(164, 4, s32)
#define SIO4_IOCTL_USC_RESET				OS_IOCTL_RW(165, 4, s32)
#define SIO4_IOCTL_USC_RX_CHAR_CNT			OS_IOCTL_RW(166, 4, s32)
#define SIO4_IOCTL_USC_RX_CHAR_CNT_LIM		OS_IOCTL_RW(167, 4, s32)
#define SIO4_IOCTL_USC_RX_CHAR_LEN			OS_IOCTL_RW(168, 4, s32)
#define SIO4_IOCTL_USC_RX_CLK_SRC			OS_IOCTL_RW(169, 4, s32)

#define SIO4_IOCTL_USC_RX_CMD				OS_IOCTL_RW(170, 4, s32)
#define SIO4_IOCTL_USC_RX_CRC_ENABLE		OS_IOCTL_RW(171, 4, s32)
#define SIO4_IOCTL_USC_RX_CRC_PRESET		OS_IOCTL_RW(172, 4, s32)
#define SIO4_IOCTL_USC_RX_CRC_TYPE			OS_IOCTL_RW(173, 4, s32)
#define SIO4_IOCTL_USC_RX_DATA_ENCODE		OS_IOCTL_RW(174, 4, s32)
#define SIO4_IOCTL_USC_RX_ENABLE			OS_IOCTL_RW(175, 4, s32)
#define SIO4_IOCTL_USC_RX_MODE				OS_IOCTL_RW(176, 4, s32)
#define SIO4_IOCTL_USC_RX_PAR_ENABLE		OS_IOCTL_RW(177, 4, s32)
#define SIO4_IOCTL_USC_RX_PAR_TYPE			OS_IOCTL_RW(178, 4, s32)
#define SIO4_IOCTL_USC_RX_QUEUE_ABORT		OS_IOCTL_RW(179, 4, s32)

#define SIO4_IOCTL_USC_RX_STATUS			OS_IOCTL_RW(180, 4, s32)
#define SIO4_IOCTL_USC_RX_STATUS_BLOCK		OS_IOCTL_RW(181, 4, s32)
#define SIO4_IOCTL_USC_RX_WAIT_DMA_TRIG		OS_IOCTL_RW(182, 4, s32)
#define SIO4_IOCTL_USC_RXC_CFG				OS_IOCTL_RW(183, 4, s32)
#define SIO4_IOCTL_USC_SEND_COMMAND			OS_IOCTL_RW(184, 4, s32)
#define SIO4_IOCTL_USC_SMONO_RX_SYNC		OS_IOCTL_RW(185, 4, s32)
#define SIO4_IOCTL_USC_SMONO_TX_ACTIVE		OS_IOCTL_RW(186, 4, s32)
#define SIO4_IOCTL_USC_SMONO_TX_SHORT		OS_IOCTL_RW(187, 4, s32)
#define SIO4_IOCTL_USC_SMONO_TX_SYNC		OS_IOCTL_RW(188, 4, s32)
#define SIO4_IOCTL_USC_SMONO_TX_UNDERRUN	OS_IOCTL_RW(189, 4, s32)

#define SIO4_IOCTL_USC_TBSC_RX_ENCODING		OS_IOCTL_RW(190, 4, s32)
#define SIO4_IOCTL_USC_TBSC_TX_ENCODING		OS_IOCTL_RW(191, 4, s32)
#define SIO4_IOCTL_USC_TBSC_TX_PREAMBLE		OS_IOCTL_RW(192, 4, s32)
#define SIO4_IOCTL_USC_TBSC_TX_UNDERRUN		OS_IOCTL_RW(193, 4, s32)
#define SIO4_IOCTL_USC_TC0					OS_IOCTL_RW(194, 4, s32)
#define SIO4_IOCTL_USC_TC1					OS_IOCTL_RW(195, 4, s32)
#define SIO4_IOCTL_USC_TX_CHAR_CNT			OS_IOCTL_RW(196, 4, s32)
#define SIO4_IOCTL_USC_TX_CHAR_CNT_LIM		OS_IOCTL_RW(197, 4, s32)
#define SIO4_IOCTL_USC_TX_CHAR_LEN			OS_IOCTL_RW(198, 4, s32)
#define SIO4_IOCTL_USC_TX_CLK_SRC			OS_IOCTL_RW(199, 4, s32)

#define SIO4_IOCTL_USC_TX_CMD				OS_IOCTL_RW(200, 4, s32)
#define SIO4_IOCTL_USC_TX_CRC_ENABLE		OS_IOCTL_RW(201, 4, s32)
#define SIO4_IOCTL_USC_TX_CRC_ON_END		OS_IOCTL_RW(202, 4, s32)
#define SIO4_IOCTL_USC_TX_CRC_PRESET		OS_IOCTL_RW(203, 4, s32)
#define SIO4_IOCTL_USC_TX_CRC_TYPE			OS_IOCTL_RW(204, 4, s32)
#define SIO4_IOCTL_USC_TX_DATA_ENCODE		OS_IOCTL_RW(205, 4, s32)
#define SIO4_IOCTL_USC_TX_ENABLE			OS_IOCTL_RW(206, 4, s32)
#define SIO4_IOCTL_USC_TX_IDLE_COND			OS_IOCTL_RW(207, 4, s32)
#define SIO4_IOCTL_USC_TX_MODE				OS_IOCTL_RW(208, 4, s32)
#define SIO4_IOCTL_USC_TX_PAR_ENABLE		OS_IOCTL_RW(209, 4, s32)

#define SIO4_IOCTL_USC_TX_PAR_TYPE			OS_IOCTL_RW(210, 4, s32)
#define SIO4_IOCTL_USC_TX_PREAMBLE_FLAG		OS_IOCTL_RW(211, 4, s32)
#define SIO4_IOCTL_USC_TX_PREAMBLE_LEN		OS_IOCTL_RW(212, 4, s32)
#define SIO4_IOCTL_USC_TX_PREAMBLE_PAT		OS_IOCTL_RW(213, 4, s32)
#define SIO4_IOCTL_USC_TX_STATUS			OS_IOCTL_RW(214, 4, s32)
#define SIO4_IOCTL_USC_TX_CTRL_BLOCK		OS_IOCTL_RW(215, 4, s32)
#define SIO4_IOCTL_USC_TX_WAIT_DMA_TRIG		OS_IOCTL_RW(216, 4, s32)
#define SIO4_IOCTL_USC_TX_WAIT_UNDERRUN		OS_IOCTL_RW(217, 4, s32)
#define SIO4_IOCTL_USC_TXC_CFG				OS_IOCTL_RW(218, 4, s32)
#define SIO4_IOCTL_USC_TXD_CFG				OS_IOCTL_RW(219, 4, s32)

#define SIO4_IOCTL_USC_TXC_LEG				OS_IOCTL_RW(220, 4, s32)
#define SIO4_IOCTL_USC_RXC_LEG				OS_IOCTL_RW(221, 4, s32)
#define SIO4_IOCTL_USC_CTS_LEG				OS_IOCTL_RW(222, 4, s32)
#define SIO4_IOCTL_USC_DCD_LEG				OS_IOCTL_RW(223, 4, s32)
//														224		sio4.h
//														...		sio4.h
//														227		sio4.h

//*****************************************************************************
// SIO4_IOCTL_USC_8023_RX_ADRS_SRCH			USC CMR D4 (802.3)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_8023_RX_ADRS_SRCH_NO		0
#define SIO4_USC_8023_RX_ADRS_SRCH_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_8023_TX_UNDERRUN			USC CMR D15 (802.3)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_8023_TX_UNDERRUN_NONE		0
#define SIO4_USC_8023_TX_UNDERRUN_CRC		1

//*****************************************************************************
// SIO4_IOCTL_USC_ACCEPT_CV					USC HCR D12
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ACCEPT_CV_NO				0
#define SIO4_USC_ACCEPT_CV_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_ACV_RX_EXT_W				USC CMR D4 (Asynchronous w/ CV)
// SIO4_IOCTL_USC_ACV_TX_EXT_W				USC CMR D13 (Asynchronous w/ CV)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ACV_EXT_W_NO				0
#define SIO4_USC_ACV_EXT_W_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_ACV_TX_CV_POL				USC CMR D12 (Asynchronous w/ CV)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ACV_TX_CV_POL_0			0
#define SIO4_USC_ACV_TX_CV_POL_1			1

//*****************************************************************************
// SIO4_IOCTL_USC_ACV_TX_STOP_BIT			USC CMR D14-D15 (Asynchronous w/ CV)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ACV_TX_STOP_BIT_1			0
#define SIO4_USC_ACV_TX_STOP_BIT_2			1
#define SIO4_USC_ACV_TX_STOP_BIT_NONE		2

//*****************************************************************************
// SIO4_IOCTL_USC_ASYNC_RX_CLK_RATE			USC CMR D4-D5 (Asynchronous)
// SIO4_IOCTL_USC_ASYNC_TX_CLK_RATE			USC CMR D12-D13 (Asynchronous)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ASYNC_CLK_RATE_16X			0
#define SIO4_USC_ASYNC_CLK_RATE_32X			1
#define SIO4_USC_ASYNC_CLK_RATE_64X			2

//*****************************************************************************
// SIO4_IOCTL_USC_ASYNC_TX_STOP_BIT			USC CMR D14-D15, CCR D8-D11 (Asynchronous)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ASYNC_TX_STOP_BIT_1		0x00	// upper nibble: CMR D14-D15
#define SIO4_USC_ASYNC_TX_STOP_BIT_2		0x10	// lower nibble: CCR D8-D11, if used

#define SIO4_USC_ASYNC_TX_STOP_BIT_0__9_16	0x28
#define SIO4_USC_ASYNC_TX_STOP_BIT_0_10_16	0x29
#define SIO4_USC_ASYNC_TX_STOP_BIT_0_11_16	0x2A
#define SIO4_USC_ASYNC_TX_STOP_BIT_0_12_16	0x2B
#define SIO4_USC_ASYNC_TX_STOP_BIT_0_13_16	0x2C
#define SIO4_USC_ASYNC_TX_STOP_BIT_0_14_16	0x2D
#define SIO4_USC_ASYNC_TX_STOP_BIT_0_15_16	0x2E

#define SIO4_USC_ASYNC_TX_STOP_BIT_1__1_16	0x30
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__2_16	0x31
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__3_16	0x32
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__4_16	0x33
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__5_16	0x34
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__6_16	0x35
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__7_16	0x36
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__8_16	0x37
#define SIO4_USC_ASYNC_TX_STOP_BIT_1__9_16	0x38
#define SIO4_USC_ASYNC_TX_STOP_BIT_1_10_16	0x39
#define SIO4_USC_ASYNC_TX_STOP_BIT_1_11_16	0x3A
#define SIO4_USC_ASYNC_TX_STOP_BIT_1_12_16	0x3B
#define SIO4_USC_ASYNC_TX_STOP_BIT_1_13_16	0x3C
#define SIO4_USC_ASYNC_TX_STOP_BIT_1_14_16	0x3D
#define SIO4_USC_ASYNC_TX_STOP_BIT_1_15_16	0x3E

//*****************************************************************************
// SIO4_IOCTL_USC_BRG0_CLK_SRC				USC CMCR D8-D9
// SIO4_IOCTL_USC_BRG1_CLK_SRC				USC CMCR D10-D11
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BRG_CLK_SRC_CTR0			0
#define SIO4_USC_BRG_CLK_SRC_CTR1			1
#define SIO4_USC_BRG_CLK_SRC_RXC_PIN		2
#define SIO4_USC_BRG_CLK_SRC_TXC_PIN		3

//*****************************************************************************
// SIO4_IOCTL_USC_BRG0_ENABLE				USC HCR D0
// SIO4_IOCTL_USC_BRG1_ENABLE				USC HCR D4
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BRG_ENABLE_NO				0
#define SIO4_USC_BRG_ENABLE_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_BRG0_MODE					USC HCR D1
// SIO4_IOCTL_USC_BRG1_MODE					USC HCR D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BRG_MODE_CONT				0
#define SIO4_USC_BRG_MODE_SINGLE			1

//*****************************************************************************
// SIO4_IOCTL_USC_BSC_RX_SHORT				USC CMR D4 (Bisync Serial Comm)
// SIO4_IOCTL_USC_BSC_TX_SHORT				USC CMR D12 (Bisync Serial Comm)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BSC_SHORT_NO				0
#define SIO4_USC_BSC_SHORT_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_BSC_RX_STRIP				USC CMR D5 (Bisync Serial Comm)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BSC_RX_STRIP_NO			0
#define SIO4_USC_BSC_RX_STRIP_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_BSC_RX_SYN0				USC RSR D0-D7 (Bisync Serial Comm)
// SIO4_IOCTL_USC_BSC_RX_SYN1				USC RSR D8-D15 (Bisync Serial Comm)
// SIO4_IOCTL_USC_BSC_TX_SYN0				USC TSR D0-D7 (Bisync Serial Comm)
// SIO4_IOCTL_USC_BSC_TX_SYN1				USC TSR D8-D15 (Bisync Serial Comm)
// SIO4_IOCTL_USC_MONO_RX_SYNC				USC RSR D8-D15 (Monosync)
// SIO4_IOCTL_USC_MONO_TX_SYNC				USC TSR D0-D7 (Monosync)
// SIO4_IOCTL_USC_SMONO_RX_SYNC				USC RSR D8-D15 (Slaved Monosync)
// SIO4_IOCTL_USC_SMONO_TX_SYNC				USC TSR D0-D7 (Slaved Monosync)
//
//	Parameter:	s32*
//		Pass in any value from zero to 0xFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_BSC_TX_PREAMBLE			USC CMR D13 (Bisync Serial Comm)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BSC_TX_PREAMBLE_NO			0
#define SIO4_USC_BSC_TX_PREAMBLE_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_BSC_TX_UNDERRUN			USC CMR D14-D15 (Bisync Serial Comm)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_BSC_TX_UNDERRUN_S1			0
#define SIO4_USC_BSC_TX_UNDERRUN_S01		1
#define SIO4_USC_BSC_TX_UNDERRUN_CRC_S1		2
#define SIO4_USC_BSC_TX_UNDERRUN_CRC_S01	3

//*****************************************************************************
// SIO4_IOCTL_USC_CTR0_CLK_SRC				USC CMCR D12-D13
// SIO4_IOCTL_USC_CTR1_CLK_SRC				USC CMCR D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CTR_CLK_SRC_DISABLE		0
#define SIO4_USC_CTR_CLK_SRC_RXC_PIN		2
#define SIO4_USC_CTR_CLK_SRC_TXC_PIN		3

//*****************************************************************************
// SIO4_IOCTL_USC_CTR0_RATE					USC HCR D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CTR0_RATE_32X				0
#define SIO4_USC_CTR0_RATE_16X				1
#define SIO4_USC_CTR0_RATE_8X				2
#define SIO4_USC_CTR0_RATE_4X				3

//*****************************************************************************
// SIO4_IOCTL_USC_CTR1_RATE					USC HCR D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CTR1_RATE_CTR0				0
#define SIO4_USC_CTR1_RATE_DPLL				1

//*****************************************************************************
// SIO4_IOCTL_USC_CTS_CFG					PSRCR D9-D10, USC IOCR D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CTS_CFG_TRI				0x02	// upper nibble: PSRCR D9-D10
#define SIO4_USC_CTS_CFG_IN_CBL_CTS			0x10	// lower nibble: USC IOCR D14-D15
#define SIO4_USC_CTS_CFG_OUT_0				0x32
#define SIO4_USC_CTS_CFG_OUT_1				0x33

//*****************************************************************************
// SIO4_IOCTL_USC_DCD_CFG					PSRCR D11-D12, USC IOCR D12-D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DCD_CFG_DISABLE			0x02	// upper nibble: PSRCR D11-D12
#define SIO4_USC_DCD_CFG_IN_DCD_CBL_DCD		0x10	// lower nibble: USC IOCR D12-D13
#define SIO4_USC_DCD_CFG_IN_SYNC_CBL_DCD	0x11
#define SIO4_USC_DCD_CFG_OUT_0				0x32	// The cable DCD may output alternate signals.
#define SIO4_USC_DCD_CFG_OUT_1				0x33	// See SIO4_IOCTL_Z16_CBL_DCD_CFG for options.

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_ADJ_SYNC				USC CCSR D8-D9
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_ADJ_SYNC_BOTH_EDGE	0
#define SIO4_USC_DPLL_ADJ_SYNC_RISE_EDGE	1
#define SIO4_USC_DPLL_ADJ_SYNC_FALL_EDGE	2
#define SIO4_USC_DPLL_ADJ_SYNC_INHIBIT		3

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_CLK_SRC				USC CMCR D6-D7
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_CLK_SRC_BRG0			0
#define SIO4_USC_DPLL_CLK_SRC_BRG1			1
#define SIO4_USC_DPLL_CLK_SRC_RXC_PIN		2
#define SIO4_USC_DPLL_CLK_SRC_TXC_PIN		3

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_MISS_1				USC CCSR D10
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_MISS_1_NO				0
#define SIO4_USC_DPLL_MISS_1_YES			1
#define SIO4_USC_DPLL_MISS_1_CLEAR			1

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_MISS_2				USC CCSR D11
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_MISS_2_NO				0
#define SIO4_USC_DPLL_MISS_2_YES			1
#define SIO4_USC_DPLL_MISS_2_CLEAR			1

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_MODE					USC HCR D8-D9
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_MODE_DISABLE			0
#define SIO4_USC_DPLL_MODE_NRZ_NRZI			1
#define SIO4_USC_DPLL_MODE_BIPH_MS			2	// Biphase-Mark/Space
#define SIO4_USC_DPLL_MODE_BIPH_LVL			3	// Biphase-Level

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_RATE					USC HCR D10-D11
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_RATE_32X				0
#define SIO4_USC_DPLL_RATE_16X				1
#define SIO4_USC_DPLL_RATE_8X				2
#define SIO4_USC_DPLL_RATE_CTR1_4X			3	// Used only for CRT1 rate

//*****************************************************************************
// SIO4_IOCTL_USC_DPLL_SYNC					USC CCSR D12
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DPLL_SYNC_START			1
// One of the below values is returned when the device is queried.
#define SIO4_USC_DPLL_SYNC_NO				0
#define SIO4_USC_DPLL_SYNC_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_HDLC_RX_ADRS_CTRL			USC CMR D4-D7 (HDLC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_OFF		0x30	// The upper nibble is the mask.
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_16		0x31	// The lower nibble is the value.
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_24		0x72
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_32		0x76
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_EA_16	0xF3
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_EA_24	0xF7
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_EAC8		0xFB
#define	SIO4_USC_HDLC_RX_ADRS_CTRL_EAC16	0xFF

//*****************************************************************************
// SIO4_IOCTL_USC_HDLC_TX_L_CHR_LEN			USC CCSR D2-D4
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLC_TX_L_CHR_LEN_8		0
#define SIO4_USC_HDLC_TX_L_CHR_LEN_1		1
#define SIO4_USC_HDLC_TX_L_CHR_LEN_2		2
#define SIO4_USC_HDLC_TX_L_CHR_LEN_3		3
#define SIO4_USC_HDLC_TX_L_CHR_LEN_4		4
#define SIO4_USC_HDLC_TX_L_CHR_LEN_5		5
#define SIO4_USC_HDLC_TX_L_CHR_LEN_6		6
#define SIO4_USC_HDLC_TX_L_CHR_LEN_7		7

//*****************************************************************************
// SIO4_IOCTL_USC_HDLC_TX_PREAMBLE			USC CMR D13 (HDLC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLC_TX_PREAMBLE_NO		0
#define SIO4_USC_HDLC_TX_PREAMBLE_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_HDLC_TX_SHARE_0			USC CMR D12 (HDLC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLC_TX_SHARE_0_NO			0
#define SIO4_USC_HDLC_TX_SHARE_0_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_HDLC_TX_UNDERRUN			USC CMR D14-D15 (HDLC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLC_TX_UNDERRUN_ABORT		0
#define SIO4_USC_HDLC_TX_UNDERRUN_EXT_A		1
#define SIO4_USC_HDLC_TX_UNDERRUN_FLAG		2
#define SIO4_USC_HDLC_TX_UNDERRUN_CRC_F		3

//*****************************************************************************
// SIO4_IOCTL_USC_HDLCL_TX_ACTIVE			USC CMR D13 (HDLC Loop)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLCL_TX_ACTIVE_NONE		0
#define SIO4_USC_HDLCL_TX_ACTIVE_POLL		1

//*****************************************************************************
// SIO4_IOCTL_USC_HDLCL_TX_SHARE_0			USC CMR D12 (HDLC Loop)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLCL_TX_SHARE_0_NO		0
#define SIO4_USC_HDLCL_TX_SHARE_0_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_HDLCL_TX_UNDERRUN			USC CMR D14-D15 (HDLC Loop)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_HDLCL_TX_UNDERRUN_ABORT	0
#define SIO4_USC_HDLCL_TX_UNDERRUN_E_ABT	1
#define SIO4_USC_HDLCL_TX_UNDERRUN_FLAG		2
#define SIO4_USC_HDLCL_TX_UNDERRUN_CRC_F	3

//*****************************************************************************
// SIO4_IOCTL_USC_ISOC_TX_STOP_BIT			USC CMR D14 (Isochronous)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ISOC_TX_STOP_BIT_1			0
#define SIO4_USC_ISOC_TX_STOP_BIT_2			1

//*****************************************************************************
// SIO4_IOCTL_USC_LOOP_SENDING				USC CCSR D6
//
//	Parameter:	s32*
//		Valid values returned are from the list below,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_LOOP_SENDING_NO			0
#define SIO4_USC_LOOP_SENDING_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_MONO_RX_SHORT				USC CMR D4 (Monosync)
// SIO4_IOCTL_USC_MONO_TX_SHORT				USC CMR D12 (Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_MONO_SHORT_NO				0
#define SIO4_USC_MONO_SHORT_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_MONO_RX_STRIP				USC CMR D5 (Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_MONO_RX_STRIP_NO			0
#define SIO4_USC_MONO_RX_STRIP_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_MONO_TX_CRC_UNDER			USC CMR D15 (Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_MONO_TX_CRC_UNDER_NO		0
#define SIO4_USC_MONO_TX_CRC_UNDER_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_MONO_TX_PREAMBLE			USC CMR D13 (Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_MONO_TX_PREAMBLE_NO		0
#define SIO4_USC_MONO_TX_PREAMBLE_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_NBIP_RX_CLK_RATE			USC CMR D4-D5 (Nine-Bit Mode)
// SIO4_IOCTL_USC_NBIP_TX_CLK_RATE			USC CMR D12-D13 (Nine-Bit Mode)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_NBIP_CLK_RATE_16X			0
#define SIO4_USC_NBIP_CLK_RATE_32X			1
#define SIO4_USC_NBIP_CLK_RATE_64X			2

//*****************************************************************************
// SIO4_IOCTL_USC_NBIP_RX_PARITY			USC CMR D6 (Nine-Bit Mode)
// SIO4_IOCTL_USC_NBIP_TX_PARITY			USC CMR D14 (Nine-Bit Mode)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_NBIP_PARITY_NO				0
#define SIO4_USC_NBIP_PARITY_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_NBIP_TX_ADRS_BIT			USC CMR D15 (Nine-Bit Mode)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_NBIP_TX_ADRS_BIT_NO		0
#define SIO4_USC_NBIP_TX_ADRS_BIT_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_ON_LOOP					USC CCSR D7
//
//	Parameter:	s32*
//		One of the below values is returned.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ON_LOOP_NO					0
#define SIO4_USC_ON_LOOP_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_OPER_MODE					USC CCAR D8-D9
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_OPER_MODE_NORMAL			0
#define SIO4_USC_OPER_MODE_AUTO_ECHO		1
#define SIO4_USC_OPER_MODE_EXT_LOOPBACK		2
#define SIO4_USC_OPER_MODE_INT_LOOPBACK		3

//*****************************************************************************
// SIO4_IOCTL_USC_RCC_FIFO_CLEAR			USC CCSR D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RCC_FIFO_CLEAR_NO			0
#define SIO4_USC_RCC_FIFO_CLEAR_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_RCC_FIFO_OVERRUN			USC CCSR D15
//
//	Parameter:	s32*
//		This service will return one of the below values.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RCC_FIFO_OVERRUN_NO		0
#define SIO4_USC_RCC_FIFO_OVERRUN_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_RCC_FIFO_VALID			USC CCSR D14
//
//	Parameter:	s32*
//		This service will return one of the below values.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RCC_FIFO_VALID_NO			0
#define SIO4_USC_RCC_FIFO_VALID_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_RESET						USC CCSR D10
//
//	Parameter:	s32*
//		Pass in -1 for support information.
//		Pass in 0 to perform the reset.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CHAR_LEN				USC RMR D2-D4
// SIO4_IOCTL_USC_TX_CHAR_LEN				USC TMR D2-D4
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CHAR_LEN_8					0
#define SIO4_USC_CHAR_LEN_1					1
#define SIO4_USC_CHAR_LEN_2					2
#define SIO4_USC_CHAR_LEN_3					3
#define SIO4_USC_CHAR_LEN_4					4
#define SIO4_USC_CHAR_LEN_5					5
#define SIO4_USC_CHAR_LEN_6					6
#define SIO4_USC_CHAR_LEN_7					7

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CHAR_CNT				USC RCCR D0-D15
//
//	Parameter:	s32*
//		Pass in -1.
//		The value returned is from 0 to 0xFFFF.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CHAR_CNT_LIM			USC RCLR D0-D15
// SIO4_IOCTL_USC_TX_CHAR_CNT_LIM			USC TCLR D0-D15
//
//	Parameter:	s32*
//		Pass in any value in the range from 0 to 0xFFFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CLK_SRC				USC CMCR D0-D2
// SIO4_IOCTL_USC_TX_CLK_SRC				USC CMCR D3-D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CLK_SRC_DISABLE			0
#define SIO4_USC_CLK_SRC_RXC_PIN			1
#define SIO4_USC_CLK_SRC_TXC_PIN			2
#define SIO4_USC_CLK_SRC_DPLL				3
#define SIO4_USC_CLK_SRC_BRG0				4
#define SIO4_USC_CLK_SRC_BRG1				5
#define SIO4_USC_CLK_SRC_CTR0				6
#define SIO4_USC_CLK_SRC_CTR1				7

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CMD					USC RCSR D12-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RX_CMD_NULL				0
#define SIO4_USC_RX_CMD_PRESET_CRC			2
#define SIO4_USC_RX_CMD_ENTER_HUNT_MODE		3
#define SIO4_USC_RX_CMD_SEL_FIFO_STATUS		5
#define SIO4_USC_RX_CMD_SEL_FIFO_INT_LVL	6
#define SIO4_USC_RX_CMD_SEL_FIFO_STS_LVL	7

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CRC_ENABLE				USC RMR D9
// SIO4_IOCTL_USC_TX_CRC_ENABLE				USC TMR D9
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CRC_ENABLE_NO				0
#define SIO4_USC_CRC_ENABLE_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CRC_PRESET				USC RMR D10
// SIO4_IOCTL_USC_TX_CRC_PRESET				USC TMR D10
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CRC_PRESET_ALL_0			0
#define SIO4_USC_CRC_PRESET_ALL_1			1

//*****************************************************************************
// SIO4_IOCTL_USC_RX_CRC_TYPE				USC RMR D11-D12
// SIO4_IOCTL_USC_TX_CRC_TYPE				USC TMR D11-D12
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CRC_TYPE_CCITT				0
#define SIO4_USC_CRC_TYPE_16				1
#define SIO4_USC_CRC_TYPE_32				2

//*****************************************************************************
// SIO4_IOCTL_USC_RX_DATA_ENCODE			USC RMR D13-D15
// SIO4_IOCTL_USC_TX_DATA_ENCODE			USC TMR D13-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DATA_ENCODE_NRZ			0
#define SIO4_USC_DATA_ENCODE_NRZB			1
#define SIO4_USC_DATA_ENCODE_NRZI_MARK		2
#define SIO4_USC_DATA_ENCODE_NRZI_SPACE		3
#define SIO4_USC_DATA_ENCODE_BI_MARK		4
#define SIO4_USC_DATA_ENCODE_BI_SPACE		5
#define SIO4_USC_DATA_ENCODE_BI_LEVEL		6
#define SIO4_USC_DATA_ENCODE_D_BI_LEVEL		7

//*****************************************************************************
// SIO4_IOCTL_USC_RX_ENABLE					USC RMR D0-D1
// SIO4_IOCTL_USC_TX_ENABLE					USC TMR D0-D1
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_ENABLE_NO_NOW				0
#define SIO4_USC_ENABLE_NO_AFTER			1
#define SIO4_USC_ENABLE_YES_NOW				2
#define SIO4_USC_ENABLE_YES_W_AE			3

//*****************************************************************************
// SIO4_IOCTL_USC_RX_MODE					USC CMR D0-D3
// SIO4_IOCTL_USC_TX_MODE					USC CMR D8-D11
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_MODE_ASYNC					0	// Rx Tx	Asynchronous
#define SIO4_USC_MODE_E_SYNC				1	// Rx --	External Synchronous
#define SIO4_USC_MODE_ISOC					2	// Rx Tx	Isochronous
#define SIO4_USC_MODE_ASY_CV				3	// Rx Tx	Asynchronous w/ Code Violations
#define SIO4_USC_MODE_MONO					4	// Rx Tx	Monosync
#define SIO4_USC_MODE_BSC					5	// Rx Tx	Bisync
#define SIO4_USC_MODE_HDLC					6	// Rx Tx	HDLC
#define SIO4_USC_MODE_TBSC					7	// Rx Tx	Transparent Bisync
#define SIO4_USC_MODE_NBIP					8	// Rx Tx	Nine-Bit Interprocessor Protocol
#define SIO4_USC_MODE_8023					9	// Rx Tx	802.3
#define SIO4_USC_MODE_S_MONO				12	// -- Tx	Slaved Monosync
#define SIO4_USC_MODE_HDLC_L				14	// -- Tx	HDLC Loop

//*****************************************************************************
// SIO4_IOCTL_USC_RX_PAR_ENABLE				USC RMR D5
// SIO4_IOCTL_USC_TX_PAR_ENABLE				USC TMR D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_PAR_ENABLE_NO				0
#define SIO4_USC_PAR_ENABLE_YES				1

//*****************************************************************************
// SIO4_IOCTL_USC_RX_PAR_TYPE				USC RMR D6-D7
// SIO4_IOCTL_USC_TX_PAR_TYPE				USC TMR D6-D7
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_PAR_TYPE_EVEN				0
#define SIO4_USC_PAR_TYPE_ODD				1
#define SIO4_USC_PAR_TYPE_ZERO				2
#define SIO4_USC_PAR_TYPE_ONE				3

//*****************************************************************************
// SIO4_IOCTL_USC_RX_QUEUE_ABORT			USC RMR D8
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RX_QUEUE_ABORT_NO			0
#define SIO4_USC_RX_QUEUE_ABORT_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_RX_STATUS					USC RCSR D0-D11, D14-D15
//
//	Parameter:	s32*
//		Pass in the value -1.
//		The value returned is the value from the register.
//		Unused bits are cleared.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_RX_STATUS_BLOCK			USC CCR D6-D7
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_STATUS_BLOCK_NO			0
#define SIO4_USC_STATUS_BLOCK_1_WORD		1
#define SIO4_USC_STATUS_BLOCK_2_WORD		2

//*****************************************************************************
// SIO4_IOCTL_USC_RX_WAIT_DMA_TRIG			USC CCR D5
// SIO4_IOCTL_USC_TX_WAIT_DMA_TRIG			USC CCR D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_WAIT_DMA_TRIG_NO			0
#define SIO4_USC_WAIT_DMA_TRIG_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_RXC_CFG					PSRCR D3-D5, USC IOCR D0-D2
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RXC_CFG_IN_OSC				0x00	// lower nibble: PSRCR D3-D5
#define SIO4_USC_RXC_CFG_IN_OSC_INV			0x01	// upper nibble: USC IOCR D0-D2
#define SIO4_USC_RXC_CFG_IN_0				0x02
#define SIO4_USC_RXC_CFG_IN_1				0x03
#define SIO4_USC_RXC_CFG_IN_CBL_RXC			0x04
#define SIO4_USC_RXC_CFG_IN_CBL_RXAUXC		0x05
#define SIO4_USC_RXC_CFG_OUT_RX_CLK			0x17
#define SIO4_USC_RXC_CFG_OUT_RX_BYTE_CLK	0x27
#define SIO4_USC_RXC_CFG_OUT_SYNC			0x37
#define SIO4_USC_RXC_CFG_OUT_BRG0			0x47
#define SIO4_USC_RXC_CFG_OUT_BRG1			0x57
#define SIO4_USC_RXC_CFG_OUT_CTR0			0x67
#define SIO4_USC_RXC_CFG_OUT_DPLL_RX		0x77

//*****************************************************************************
// SIO4_IOCTL_USC_SEND_COMMAND				USC CCAR D11-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_SEND_CMD_NONE				0x00
#define SIO4_USC_SEND_CMD_RESET_H_IUS		0x02	// Reset Highest Serial IUS
#define SIO4_USC_SEND_CMD_TRIG_LD_DMA		0x04	// Trigger Channel Load DMA
#define SIO4_USC_SEND_CMD_TRIG_RX_DMA		0x05	// Trigger Rx DMA
#define SIO4_USC_SEND_CMD_TRIG_TX_DMA		0x06	// Trigger Tx DMA
#define SIO4_USC_SEND_CMD_TRIG_TX_RX_DMA	0x07	// Trigger Rx and Tx DMA
#define SIO4_USC_SEND_CMD_RX_FIFO_PURGE		0x09	// Purge Rx FIFO
#define SIO4_USC_SEND_CMD_TX_FIFO_PURGE		0x0A	// Purge Tx FIFO
#define SIO4_USC_SEND_CMD_FIFOS_PURGE		0x0B	// Purge Rx and Tx FIFO
#define SIO4_USC_SEND_CMD_LD_RX_CHAR_CNT	0x0D	// Load RCC
#define SIO4_USC_SEND_CMD_LD_TX_CHAR_CNT	0x0E	// Load TCC
#define SIO4_USC_SEND_CMD_LD_CHAR_CNTS		0x0F	// Load RCC and TCC
#define SIO4_USC_SEND_CMD_LD_TC0			0x11	// Load TC0
#define SIO4_USC_SEND_CMD_LD_TC1			0x12	// Load TC1
#define SIO4_USC_SEND_CMD_LD_TC0_TC1		0x13	// Load TC0 and TC1
#define SIO4_USC_SEND_CMD_SEL_LSB_FIRST		0x14	// Select Serial LSBit First, see manual
#define SIO4_USC_SEND_CMD_SEL_MSB_FIRST		0x15	// Select Serial MSBit First, see manual
#define SIO4_USC_SEND_CMD_SEL_STRAIT_MEM	0x16	// Select D15-D8 First
#define SIO4_USC_SEND_CMD_SEL_SWAP_MEM		0x17	// Select D7-D0 First
#define SIO4_USC_SEND_CMD_RX_PURGE			0x19	// Purge Rx

//*****************************************************************************
// SIO4_IOCTL_USC_SMONO_TX_ACTIVE			USC CMR D13 (Slaved Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_SMONO_TX_ACTIVE_WAIT		0
#define SIO4_USC_SMONO_TX_ACTIVE_ON_SYNC	1

//*****************************************************************************
// SIO4_IOCTL_USC_SMONO_TX_SHORT			USC CMR D12 (Slaved Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_SMONO_TX_SHORT_NO			0
#define SIO4_USC_SMONO_TX_SHORT_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_SMONO_TX_UNDERRUN			USC CMR D15 (Slaved Monosync)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_SMONO_TX_UNDERRUN_NONE		0
#define SIO4_USC_SMONO_TX_UNDERRUN_CRC		1

//*****************************************************************************
// SIO4_IOCTL_USC_TBSC_RX_ENCODING			USC CMR D4 (Transparent BSC)
// SIO4_IOCTL_USC_TBSC_TX_ENCODING			USC CMR D12 (Transparent BSC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TBSC_ENCODING_ASCII		0
#define SIO4_USC_TBSC_ENCODING_EBCDIC		1

//*****************************************************************************
// SIO4_IOCTL_USC_TBSC_TX_PREAMBLE			USC CMR D13 (Transparent BSC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TBSC_TX_PREAMBLE_NO		0
#define SIO4_USC_TBSC_TX_PREAMBLE_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_TBSC_TX_UNDERRUN			USC CMR D14-D15 (Transparent BSC)
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TBSC_TX_UNDERRUN_S			0
#define SIO4_USC_TBSC_TX_UNDERRUN_D_S		1
#define SIO4_USC_TBSC_TX_UNDERRUN_C_S		2
#define SIO4_USC_TBSC_TX_UNDERRUN_C_D_S		3

//*****************************************************************************
// SIO4_IOCTL_USC_TC0						USC TC0R D0-D15
// SIO4_IOCTL_USC_TC1						USC TC1R D0-D15
//
//	Parameter:	s32*
//		Pass in any value in the range from 0 to 0xFFFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_TX_CHAR_CNT				USC TCCR D0-D15
//
//	Parameter:	s32*
//		Pass in any value from zero to 0xFFFF,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_TX_CMD					USC TCSR D12-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_CMD_NULL				0
#define SIO4_USC_TX_CMD_PRESET_CRC			2	// Clear Tx CRC Generator
#define SIO4_USC_TX_CMD_ENTER_HUNT_MODE		3	// Enter Hunt Mode
#define SIO4_USC_TX_CMD_SEL_FIFO_STATUS		5	// Select TICRHi=FIFO Status
#define SIO4_USC_TX_CMD_SEL_FIFO_INT_LVL	6	// Select TICRHi=/INT Level
#define SIO4_USC_TX_CMD_SEL_FIFO_STS_LVL	7	// Select TICRHi=/TxREQ Level
#define SIO4_USC_TX_CMD_SEND_FRM_MSG		8	// Send Frame/Message
#define SIO4_USC_TX_CMD_SEND_ABORT			9	// Send Abort
#define SIO4_USC_TX_CMD_RST_DLE_INHIBIT		12	// Enable DLE Insertion
#define SIO4_USC_TX_CMD_SET_DLE_INHIBIT		13	// Disable DLE Insertion
#define SIO4_USC_TX_CMD_RST_EOF_EOM			14	// Clear EOF/EOM
#define SIO4_USC_TX_CMD_SET_EOF_EOM			15	// Set EOF/EOM

//*****************************************************************************
// SIO4_IOCTL_USC_TX_CRC_ON_END				USC TMR D8
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_CRC_ON_END_NO			0
#define SIO4_USC_TX_CRC_ON_END_YES			1

//*****************************************************************************
// SIO4_IOCTL_USC_TX_CTRL_BLOCK				USC CCR D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CTRL_BLOCK_NO				0
#define SIO4_USC_CTRL_BLOCK_1_WORD			1
#define SIO4_USC_CTRL_BLOCK_2_WORD			2

//*****************************************************************************
// SIO4_IOCTL_USC_TX_IDLE_COND				USC TCSR D8-D10
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_IDLE_COND_DEFAULT		0
#define SIO4_USC_TX_IDLE_COND_0_1			1
#define SIO4_USC_TX_IDLE_COND_0				2
#define SIO4_USC_TX_IDLE_COND_1				3
#define SIO4_USC_TX_IDLE_COND_MARK_SPACE	5
#define SIO4_USC_TX_IDLE_COND_SPACE			6
#define SIO4_USC_TX_IDLE_COND_MARK			7

//*****************************************************************************
// SIO4_IOCTL_USC_TX_PREAMBLE_FLAG			USC CCR D12
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_PREAMBLE_FLAG_NO		0
#define SIO4_USC_TX_PREAMBLE_FLAG_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_TX_PREAMBLE_LEN			USC CCR D10-D11
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_PREAMBLE_LEN_8_BITS		0
#define SIO4_USC_TX_PREAMBLE_LEN_16_BITS	1
#define SIO4_USC_TX_PREAMBLE_LEN_32_BITS	2
#define SIO4_USC_TX_PREAMBLE_LEN_64_BITS	3

//*****************************************************************************
// SIO4_IOCTL_USC_TX_PREAMBLE_PAT			USC CCR D8-D9
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_PREAMBLE_PAT_0			0
#define SIO4_USC_TX_PREAMBLE_PAT_1			1
#define SIO4_USC_TX_PREAMBLE_PAT_10			2
#define SIO4_USC_TX_PREAMBLE_PAT_01			3

//*****************************************************************************
// SIO4_IOCTL_USC_TX_STATUS					USC TCSR D0-D7
//
//	Parameter:	s32*
//		Pass in the value -1.
//		Values returned are from 0 to 0xFF.
//		The value -1 is returned if the feature is not supported.

//*****************************************************************************
// SIO4_IOCTL_USC_TX_WAIT_UNDERRUN			USC TCSR D11
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TX_WAIT_UNDERRUN_NO		0
#define SIO4_USC_TX_WAIT_UNDERRUN_YES		1

//*****************************************************************************
// SIO4_IOCTL_USC_TXC_CFG					PSRCR D0-D2, USC IOCR D3-D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TXC_CFG_IN_OSC				0x00	// Lower nibble: PSRCR D0-D2
#define SIO4_USC_TXC_CFG_IN_OSC_INV			0x01	// Upper nibble: USC IOCR D3-D5
#define SIO4_USC_TXC_CFG_IN_0				0x02
#define SIO4_USC_TXC_CFG_IN_1				0x03
#define SIO4_USC_TXC_CFG_IN_CBL_RXC			0x04
#define SIO4_USC_TXC_CFG_IN_CBL_RXAUXC		0x05
#define SIO4_USC_TXC_CFG_OUT_TX_CLK			0x17
#define SIO4_USC_TXC_CFG_OUT_TX_BYTE_CLK	0x27
#define SIO4_USC_TXC_CFG_OUT_TX_COMP		0x37
#define SIO4_USC_TXC_CFG_OUT_BRG0			0x47
#define SIO4_USC_TXC_CFG_OUT_BRG1			0x57
#define SIO4_USC_TXC_CFG_OUT_CTR1			0x67
#define SIO4_USC_TXC_CFG_OUT_DPLL_TX		0x77

//*****************************************************************************
// SIO4_IOCTL_USC_TXD_CFG					USC IOCR D6-D7
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TXD_CFG_OUT_TXD			0
#define SIO4_USC_TXD_CFG_TRI				1
#define SIO4_USC_TXD_CFG_OUT_0				2
#define SIO4_USC_TXD_CFG_OUT_1				3

//*****************************************************************************
// SIO4_IOCTL_USC_TXC_LEG					USC IOCR D3-D5
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_TXC_LEG_IN					0x0
#define SIO4_USC_TXC_LEG_OUT_TX_CLK			0x1
#define SIO4_USC_TXC_LEG_OUT_TX_BYTE_CLK	0x2
#define SIO4_USC_TXC_LEG_OUT_TX_COMP		0x3
#define SIO4_USC_TXC_LEG_OUT_BRG0			0x4
#define SIO4_USC_TXC_LEG_OUT_BRG1			0x5
#define SIO4_USC_TXC_LEG_OUT_CTR1			0x6
#define SIO4_USC_TXC_LEG_OUT_DPLL_TX		0x7

//*****************************************************************************
// SIO4_IOCTL_USC_RXC_LEG					USC IOCR D0-D2
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_RXC_LEG_IN					0x0
#define SIO4_USC_RXC_LEG_OUT_RX_CLK			0x1
#define SIO4_USC_RXC_LEG_OUT_RX_BYTE_CLK	0x2
#define SIO4_USC_RXC_LEG_OUT_SYNC			0x3
#define SIO4_USC_RXC_LEG_OUT_BRG0			0x4
#define SIO4_USC_RXC_LEG_OUT_BRG1			0x5
#define SIO4_USC_RXC_LEG_OUT_CTR0			0x6
#define SIO4_USC_RXC_LEG_OUT_DPLL_RX		0x7

//*****************************************************************************
// SIO4_IOCTL_USC_CTS_LEG					USC IOCR D14-D15
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_CTS_LEG_IN					0x0
#define SIO4_USC_CTS_LEG_OUT_0				0x2
#define SIO4_USC_CTS_LEG_OUT_1				0x3

//*****************************************************************************
// SIO4_IOCTL_USC_DCD_LEG					USC IOCR D12-D13
//
//	Parameter:	s32*
//		Pass in any value from the below list,
//		or -1 to read the current setting.
//		The value -1 is returned if the feature is not supported.
#define SIO4_USC_DCD_LEG_IN_DCD				0x0
#define SIO4_USC_DCD_LEG_IN_SYNC			0x1
#define SIO4_USC_DCD_LEG_OUT_0				0x2
#define SIO4_USC_DCD_LEG_OUT_1				0x3



#endif
