// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/sync/lib/sio4_sync.h $
// $Rev: 25416 $
// $Date: 2014-02-26 14:06:35 -0600 (Wed, 26 Feb 2014) $

#ifndef	_SIO4_SYNC_H_
#define	_SIO4_SYNC_H_

#include "sio4_lib.h"



// #defines *******************************************************************

// Control/Status Register
#define	SIO4_SYNC_CSR_RX_ENABLE			0x01000000
#define	SIO4_SYNC_CSR_TX_ENABLE			0x02000000
#define	SIO4_SYNC_CSR_TX_AUTO_DIS		0x04000000
#define	SIO4_SYNC_CSR_RX_LSB_FIRST		0x08000000
#define	SIO4_SYNC_CSR_TX_LSB_FIRST		0x10000000
#define	SIO4_SYNC_CSR_RX_CNT_ERR_RST	0x20000000
#define	SIO4_SYNC_CSR_RX_CNT_ERR_STS	0x80000000

// Pin Source Register
#define	SIO4_SYNC_PSRCR_TXC				0x00000007 // Tx Clock
#define	SIO4_SYNC_PSRCR_TXC_IDLE		0x00000008 // Tx Clock Idle
#define	SIO4_SYNC_PSRCR_TXE				0x00000030 // Tx Envelope
#define	SIO4_SYNC_PSRCR_TXD				0x000001C0 // Tx Data
#define	SIO4_SYNC_PSRCR_TXAC			0x00000600 // Tx Aux Clock
#define	SIO4_SYNC_PSRCR_TXSP			0x00001800 // Tx Spare
#define	SIO4_SYNC_PSRCR_RXC				0x00002000 // Rx Clock
#define	SIO4_SYNC_PSRCR_RXE				0x0000C000 // Rx Envelope
#define	SIO4_SYNC_PSRCR_RXD				0x00030000 // Rx Data
#define	SIO4_SYNC_PSRCR_LB_INT			0x00800000 // Internal Loopback
#define	SIO4_SYNC_PSRCR_DCE_EN			0x10000000 // DCE Enable (if D31 set)
#define	SIO4_SYNC_PSRCR_LB_EXT			0x20000000 // External Loopback
#define	SIO4_SYNC_PSRCR_DCE_DTE_EN		0x80000000 // DCE/DTE Enable

// Pin Status Register
#define	SIO4_SYNC_PSTSR_GPIO			0x000003FF // D0-D9



// typedefs *******************************************************************

typedef struct
{
	int		dce_enable;	// 0 = No, !0 = Yes (Precidence over DTE.)
	int		dte_enable;	// 0 = No, !0 = Yes (If DCE disabled.)

	struct
	{
		int	enable;		// 0 = No (disble), !0 = Yes (enable)
		int	internal;	// 0 = No (Extern), !0 = Yes (Intern)
	} lb;
} sio4_sync_t;

typedef struct
{
	int		enable;		// SIO4_IOCTL_SYNC_RX_ENABLE
	int		bit_order;	// SIO4_IOCTL_SYNC_RX_BIT_ORDER
	int		reset;		// 0 = no error/reset, !0 = error/reset
	u16		word_size;	// SIO4_IOCTL_SYNC_RX_BIT_COUNT, READ-ONLY

	struct
	{
		s32	cfg;		// SIO4_IOCTL_SYNC_RXC_CFG
		s32	pol;		// SIO4_IOCTL_SYNC_RXC_POL
	} clock;

	struct
	{
		s32	cfg;		// SIO4_IOCTL_SYNC_RXE_CFG
		s32	pol;		// SIO4_IOCTL_SYNC_RXE_POL
	} env;

	struct
	{
		s32	cfg;		// SIO4_IOCTL_SYNC_RXD_CFG
		s32	legacy;		// SIO4_IOCTL_SYNC_LEG_RXD_CFG
	} data;
} sio4_sync_rx_t;

typedef struct
{
	s32		enable;		// SIO4_IOCTL_SYNC_TX_ENABLE
	s32		empty_cfg;	// SIO4_IOCTL_TX_FIFO_EMPTY_CFG
	s32		bit_order;	// SIO4_IOCTL_SYNC_TX_BIT_ORDER
	u16		word_size;	// SIO4_IOCTL_SYNC_TX_WORD_SIZE
	u16		gap_size;	// SIO4_IOCTL_SYNC_TX_GAP_SIZE

	struct
	{
		s32	cfg;		// SIO4_IOCTL_SYNC_TXC_CFG
		s32	pol;		// SIO4_IOCTL_SYNC_TXC_POL
		s32	src;		// SIO4_IOCTL_SYNC_TXC_SRC
		s32	idle;		// SIO4_IOCTL_SYNC_TXC_IDLE
		s32	idle_cfg;	// SIO4_IOCTL_SYNC_TXC_IDLE_CFG
	} clock;

	struct
	{
		s32	cfg;		// SIO4_IOCTL_SYNC_TXE_CFG
		s32	pol;		// SIO4_IOCTL_SYNC_TXE_POL
	} env;

	struct
	{
		s32	cfg;		// SIO4_IOCTL_SYNC_TXD_CFG
		s32	idle;		// SIO4_IOCTL_SYNC_TXD_IDLE_CFG
		s32	legacy;		// SIO4_IOCTL_SYNC_LEG_TXD_CFG
	} data;

	s32		aux_clock;	// SIO4_IOCTL_SYNC_TXAUXC_CFG
	s32		spare;		// SIO4_IOCTL_SYNC_TXSP_CFG
} sio4_sync_tx_t;



// functions ******************************************************************

void	sio4_sync_version(const char** version, const char** built);

int		sio4_sync_get(int fd, sio4_sync_t* sync);
int		sio4_sync_set(int fd, const sio4_sync_t* sync);

int		sio4_sync_gpio_rx(int fd, u32* value);
int		sio4_sync_gpio_tx(int fd, u32 value);

int		sio4_sync_rx_get(int fd, sio4_sync_rx_t* rx);
int		sio4_sync_rx_set(int fd, const sio4_sync_rx_t* rx);

int		sio4_sync_tx_get(int fd, sio4_sync_tx_t* tx);
int		sio4_sync_tx_set(int fd, const sio4_sync_tx_t* tx);



#endif
