// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/isoc/utils/sio4_isoc_utils.h $
// $Rev: 31509 $
// $Date: 2014-12-09 18:36:57 -0600 (Tue, 09 Dec 2014) $

#ifndef __SIO4_ISOC_UTILS_H__
#define __SIO4_ISOC_UTILS_H__

#include "sio4_dsl.h"
#include "sio4_utils.h"
#include "sio4_isoc.h"



// prototypes *****************************************************************

int		isoc_util_close		(int fd, int index, int verbose);
int		isoc_util_get		(int fd, int index, int verbose, sio4_isoc_t* isoc, const char** err);
int		isoc_util_init		(int fd, int index, int verbose, const sio4_isoc_init_t* init, sio4_isoc_t* isoc, const char** err);
int		isoc_util_ioctl		(int fd, int index, int verbose, int cmd, void* arg);
int		isoc_util_lib_init	(					int verbose);
int		isoc_util_open		(		 int index, int verbose, int show_index);
int		isoc_util_read		(int fd, int index, int verbose, void* buf, size_t size);
int		isoc_util_set		(int fd, int index, int verbose, const sio4_isoc_t* isoc, const char** err);
int		isoc_util_show		(int fd, int index, int verbose, const sio4_isoc_t* isoc, const char** err);
void	isoc_util_version	(					int verbose, const char** version, const char** built);
int		isoc_util_write		(int fd, int index, int verbose, const void* buf, size_t size);



#endif
