// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/utils/sio4_hdlc_utils.h $
// $Rev: 25391 $
// $Date: 2014-02-26 13:35:05 -0600 (Wed, 26 Feb 2014) $

#ifndef __SIO4_HDLC_UTILS_H__
#define __SIO4_HDLC_UTILS_H__

#include "sio4_dsl.h"
#include "sio4_utils.h"
#include "sio4_hdlc.h"



// prototypes *****************************************************************

int		hdlc_util_close		(int fd, int index, int verbose);
int		hdlc_util_get		(int fd, int index, int verbose, sio4_hdlc_t* hdlc, const char** err);
int		hdlc_util_init		(int fd, int index, int verbose, const sio4_hdlc_init_t* init, sio4_hdlc_t* hdlc, const char** err);
int		hdlc_util_ioctl		(int fd, int index, int verbose, int cmd, void* arg);
int		hdlc_util_lib_init	(		 int index, int verbose);
int		hdlc_util_open		(		 int index, int show_index, int verbose);
int		hdlc_util_rx_flush	(int fd, int index, int verbose);
int		hdlc_util_rx_frame	(int fd, int index, int verbose, sio4_hdlc_rx_frame_t* rx);
int		hdlc_util_set		(int fd, int index, int verbose, const sio4_hdlc_t* hdlc, const char** err);
int		hdlc_util_tx_abort	(int fd, int index, int verbose, int wait);
int		hdlc_util_tx_flush	(int fd, int index, int verbose, int timeout);
int		hdlc_util_tx_frame	(int fd, int index, int verbose, sio4_hdlc_tx_frame_t* tx);
int		hdlc_util_tx_wait	(int fd, int index, int verbose, int timeout, int* done);
void	hdlc_util_version	(		 int index, int verbose, const char** version, const char** built);



#endif
