// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/hdlc/lib/sio4_hdlc.h $
// $Rev: 25475 $
// $Date: 2014-02-26 14:57:53 -0600 (Wed, 26 Feb 2014) $

#ifndef __SIO4_HDLC_H__
#define __SIO4_HDLC_H__

#include "sio4.h"



// #defines *******************************************************************

//*****************************************************************************
// sio4_hdlc_rx_frame_t.flags
#define	SIO4_HDLC_RX_FLAG_ABORT				0x0001	// USC RCSR D5, D2 (if Abort is queued)
#define	SIO4_HDLC_RX_FLAG_CRC_ERR			0x0002	// USC RCSR D3
#define	SIO4_HDLC_RX_FLAG_DATA				0x0004	// Date returned in call.
#define	SIO4_HDLC_RX_FLAG_DATA_LOSS			0x0008	// Data was lost by some means.
#define	SIO4_HDLC_RX_FLAG_DATA_OVERRUN		0x0010	// CSR D16, USC RCSR D1
#define	SIO4_HDLC_RX_FLAG_DATA_UNDERRUN		0x0020	// CSR D18
#define	SIO4_HDLC_RX_FLAG_DPLL_CV			0x0040	// USC CCSR D10/D11 (via isr)
#define	SIO4_HDLC_RX_FLAG_DPLL_CV1			0x0080	// USC CCSR D10
#define	SIO4_HDLC_RX_FLAG_DPLL_CV2			0x0100	// USC CCSR D11
#define	SIO4_HDLC_RX_FLAG_EOF				0x0200	// End of Frame indicator
#define	SIO4_HDLC_RX_FLAG_FRAME_OVERRUN		0x0400	// USC CCSR D15
#define	SIO4_HDLC_RX_FLAG_FRAME_SHORT		0x0800	// USC RCSR D8
#define	SIO4_HDLC_RX_FLAG_PARITY			0x1000	// USC R.S.B. D2, USC RCSR D2 (if Abort not queued)

//*****************************************************************************
// sio4_hdlc_rx_frame_t.last				// USC RCSR D9-D11
#define SIO4_HDLC_RX_LAST_CHAR_LEN_1		SIO4_USC_CHAR_LEN_1
#define SIO4_HDLC_RX_LAST_CHAR_LEN_2		SIO4_USC_CHAR_LEN_2
#define SIO4_HDLC_RX_LAST_CHAR_LEN_3		SIO4_USC_CHAR_LEN_3
#define SIO4_HDLC_RX_LAST_CHAR_LEN_4		SIO4_USC_CHAR_LEN_4
#define SIO4_HDLC_RX_LAST_CHAR_LEN_5		SIO4_USC_CHAR_LEN_5
#define SIO4_HDLC_RX_LAST_CHAR_LEN_6		SIO4_USC_CHAR_LEN_6
#define SIO4_HDLC_RX_LAST_CHAR_LEN_7		SIO4_USC_CHAR_LEN_7
#define SIO4_HDLC_RX_LAST_CHAR_LEN_8		SIO4_USC_CHAR_LEN_8

//*****************************************************************************
// sio4_hdlc_tx_frame_t.last				// USC CCSR D2-D4
#define SIO4_HDLC_TX_LAST_CHAR_LEN_1		SIO4_USC_HDLC_TX_L_CHR_LEN_1
#define SIO4_HDLC_TX_LAST_CHAR_LEN_2		SIO4_USC_HDLC_TX_L_CHR_LEN_2
#define SIO4_HDLC_TX_LAST_CHAR_LEN_3		SIO4_USC_HDLC_TX_L_CHR_LEN_3
#define SIO4_HDLC_TX_LAST_CHAR_LEN_4		SIO4_USC_HDLC_TX_L_CHR_LEN_4
#define SIO4_HDLC_TX_LAST_CHAR_LEN_5		SIO4_USC_HDLC_TX_L_CHR_LEN_5
#define SIO4_HDLC_TX_LAST_CHAR_LEN_6		SIO4_USC_HDLC_TX_L_CHR_LEN_6
#define SIO4_HDLC_TX_LAST_CHAR_LEN_7		SIO4_USC_HDLC_TX_L_CHR_LEN_7
#define SIO4_HDLC_TX_LAST_CHAR_LEN_8		SIO4_USC_HDLC_TX_L_CHR_LEN_8

//*****************************************************************************
// sio4_hdlc_tx_frame_t.flags
#define	SIO4_HDLC_TX_FLAG_EOF				0x00010000	// Frame end written to board?
#define	SIO4_HDLC_TX_FLAG_ERROR				0x00020000	// An unspecified error.
#define	SIO4_HDLC_TX_FLAG_OVERRUN			0x00040000	// CSR D17
#define	SIO4_HDLC_TX_FLAG_UNDERRUN			0x00080000	// USC TCSR D1: premature frame end

//*****************************************************************************
// sio4_hdlc_init_t.rx_bit_rate
// Specified by caller before calling sio4_hdlc_init().

//*****************************************************************************
// sio4_hdlc_init_t.rx_uses_cbl_rxc
// Specified by caller before calling sio4_hdlc_init().
#define SIO4_HDLC_RX_USES_CBL_RXC_NO		0
#define SIO4_HDLC_RX_USES_CBL_RXC_YES		1

//*****************************************************************************
// sio4_hdlc_init_t.tx_bit_rate
// Specified by caller before calling sio4_hdlc_init().

//*****************************************************************************
// sio4_hdlc_t.cable.dcd					// PSRCR D15-D16
// sio4_hdlc_t_cable_dcd()
#define SIO4_HDLC_CABLE_DCD_OUT_USC_DCD		SIO4_Z16_CBL_DCD_CFG_OUT_USC_DCD	// default
#define SIO4_HDLC_CABLE_DCD_OUT_RTS			SIO4_Z16_CBL_DCD_CFG_OUT_RTS		// Rx FIFO Almost Full
#define SIO4_HDLC_CABLE_DCD_OUT_0			SIO4_Z16_CBL_DCD_CFG_OUT_0
#define SIO4_HDLC_CABLE_DCD_OUT_1			SIO4_Z16_CBL_DCD_CFG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.cable.mode					// PSRCR D28, else DCE
// sio4_hdlc_t_cable_mode()
#define SIO4_HDLC_CABLE_MODE_DTE			SIO4_CBL_MODE_DTE	// default
#define SIO4_HDLC_CABLE_MODE_DCE			SIO4_CBL_MODE_DCE

//*****************************************************************************
// sio4_hdlc_t.cable.dtr_dsr				// PSRCR D21-D22
// sio4_hdlc_t_cable_dtr_dsr()
#define SIO4_HDLC_CABLE_DTR_DSR_TRI			SIO4_Z16_CBL_DTR_DSR_CFG_TRI		// default
#define SIO4_HDLC_CABLE_DTR_DSR_IN			SIO4_Z16_CBL_DTR_DSR_CFG_IN			// DSR
#define SIO4_HDLC_CABLE_DTR_DSR_OUT_0		SIO4_Z16_CBL_DTR_DSR_CFG_OUT_0
#define SIO4_HDLC_CABLE_DTR_DSR_OUT_1		SIO4_Z16_CBL_DTR_DSR_CFG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.cable.enable					// PSRCR D31
// sio4_hdlc_t_cable_enable()
#define SIO4_HDLC_CABLE_ENABLE_NO			SIO4_XCVR_ENABLE_NO
#define SIO4_HDLC_CABLE_ENABLE_YES			SIO4_XCVR_ENABLE_YES				// default

//*****************************************************************************
// sio4_hdlc_t.cable.legacy.rxc				// CCR D2-D3, D6-D7, D10-D11, D14-D15
// sio4_hdlc_t_cable_legacy_rxc()
#define SIO4_HDLC_CABLE_LEGACY_RXC_DISABLE	SIO4_Z16_LEG_RXC_DISABLE
#define SIO4_HDLC_CABLE_LEGACY_RXC_UP		SIO4_Z16_LEG_RXC_UPPER
#define SIO4_HDLC_CABLE_LEGACY_RXC_LOW		SIO4_Z16_LEG_RXC_LOWER				// default

//*****************************************************************************
// sio4_hdlc_t.cable.legacy.rxd_dcd				// CSR D4-D5
// sio4_hdlc_t_cable_legacy_rxd_dcd()
#define SIO4_HDLC_CABLE_LEGACY_RXD_DCD_DISABLE	SIO4_SYNC_LEG_RXD_CFG_TRI
#define SIO4_HDLC_CABLE_LEGACY_RXD_DCD_UP		SIO4_SYNC_LEG_RXD_CFG_LOW
#define SIO4_HDLC_CABLE_LEGACY_RXD_DCD_LOW		SIO4_SYNC_LEG_RXD_CFG_UP		// default

//*****************************************************************************
// sio4_hdlc_t.cable.legacy.txc				// CCR D0-D1, D4-D5, D8-D9, D12-D13
// sio4_hdlc_t_cable_legacy_txc()
#define SIO4_HDLC_CABLE_LEGACY_TXC_DISABLE	SIO4_Z16_LEG_TXC_DISABLE
#define SIO4_HDLC_CABLE_LEGACY_TXC_UP		SIO4_Z16_LEG_TXC_UPPER				// default
#define SIO4_HDLC_CABLE_LEGACY_TXC_LOW		SIO4_Z16_LEG_TXC_LOWER
#define SIO4_HDLC_CABLE_LEGACY_TXC_BOTH		SIO4_Z16_LEG_TXC_BOTH

//*****************************************************************************
// sio4_hdlc_t.cable.legacy.txd_cts			// CSR D2-D3
// sio4_hdlc_t_cable_legacy_txd_cts()
#define SIO4_HDLC_CABLE_LEGACY_TXD_CTS_TRI	SIO4_SYNC_LEG_TXD_CFG_TRI
#define SIO4_HDLC_CABLE_LEGACY_TXD_CTS_UP	SIO4_SYNC_LEG_TXD_CFG_LOW			// default
#define SIO4_HDLC_CABLE_LEGACY_TXD_CTS_LOW	SIO4_SYNC_LEG_TXD_CFG_UP
#define SIO4_HDLC_CABLE_LEGACY_TXD_CTS_BOTH	SIO4_SYNC_LEG_TXD_CFG_UP_LOW

//*****************************************************************************
// sio4_hdlc_t.cable.loopback.mode			// PSRCR D23, D29
// sio4_hdlc_t_cable_loopback_mode()
#define SIO4_HDLC_LOOPBACK_MODE_DISABLE		SIO4_LOOP_BACK_DISABLE				// default
#define SIO4_HDLC_LOOPBACK_MODE_INTERNAL	SIO4_LOOP_BACK_INTERNAL
#define SIO4_HDLC_LOOPBACK_MODE_EXTERNAL	SIO4_LOOP_BACK_EXTERNAL

//*****************************************************************************
// sio4_hdlc_t.cable.protocol					// PSRCR D24-D27
// sio4_hdlc_t_cable_protocol()
#define SIO4_HDLC_CABLE_PROTOCOL_RS422_RS485	SIO4_XCVR_PROTOCOL_RS422_RS485	// default, if supported
#define SIO4_HDLC_CABLE_PROTOCOL_RS423			SIO4_XCVR_PROTOCOL_RS423
#define SIO4_HDLC_CABLE_PROTOCOL_RS232			SIO4_XCVR_PROTOCOL_RS232
#define SIO4_HDLC_CABLE_PROTOCOL_RS530			SIO4_XCVR_PROTOCOL_RS530		// or RS-530 Mode 1
#define SIO4_HDLC_CABLE_PROTOCOL_RS530A			SIO4_XCVR_PROTOCOL_RS530A		// or RS-530 Mode 2
#define SIO4_HDLC_CABLE_PROTOCOL_V35			SIO4_XCVR_PROTOCOL_V35			// or V.35 Mode 1
#define SIO4_HDLC_CABLE_PROTOCOL_V35A			SIO4_XCVR_PROTOCOL_V35A			// or V.35 Mode 2
#define SIO4_HDLC_CABLE_PROTOCOL_RS422_423_1	SIO4_XCVR_PROTOCOL_RS422_RS423_1// or RS-422/RS-423 Mixed Mode 1
#define SIO4_HDLC_CABLE_PROTOCOL_RS422_423_2	SIO4_XCVR_PROTOCOL_RS422_RS423_2// or RS-422/RS-423 Mixed Mode 2
#define	SIO4_HDLC_CABLE_PROTOCOL_DISABLE		SIO4_XCVR_PROTOCOL_DISABLE		// Hi Impediance
#define	SIO4_HDLC_CABLE_PROTOCOL_UNKNOWN		SIO4_XCVR_PROTOCOL_UNKNOWN

//*****************************************************************************
// sio4_hdlc_t.cable.rts					// PSRCR D13-D14
// sio4_hdlc_t_cable_rts()
#define SIO4_HDLC_CABLE_RTS_OUT_CTS			SIO4_Z16_CBL_RTS_CFG_OUT_USC_CTS	// from USC
#define SIO4_HDLC_CABLE_RTS_OUT_RTS			SIO4_Z16_CBL_RTS_CFG_OUT_RTS		// Rx FIFO Almost Full, default
#define SIO4_HDLC_CABLE_RTS_OUT_0			SIO4_Z16_CBL_RTS_CFG_OUT_0
#define SIO4_HDLC_CABLE_RTS_OUT_1			SIO4_Z16_CBL_RTS_CFG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.cable.term.enable			// PSRCR D30
// sio4_hdlc_t_cable_term_enable()
#define SIO4_HDLC_CABLE_TERM_ENABLE_YES		SIO4_XCVR_TERM_ENABLE
#define SIO4_HDLC_CABLE_TERM_ENABLE_NO		SIO4_XCVR_TERM_DISABLE				// default

//*****************************************************************************
// sio4_hdlc_t.cable.txaux					// PSRCR D17-D18
// sio4_hdlc_t_cable_txaux()
#define SIO4_HDLC_CABLE_TXAUX_TRI			SIO4_Z16_CBL_TXAUXC_CFG_TRI			// default
#define SIO4_HDLC_CABLE_TXAUX_OUT_OSC		SIO4_Z16_CBL_TXAUXC_CFG_OUT_OSC
#define SIO4_HDLC_CABLE_TXAUX_OUT_0			SIO4_Z16_CBL_TXAUXC_CFG_OUT_0
#define SIO4_HDLC_CABLE_TXAUX_OUT_1			SIO4_Z16_CBL_TXAUXC_CFG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.cable.txc					// PSRCR D6-D8
// sio4_hdlc_t_cable_txc()
#define SIO4_HDLC_CABLE_TXC_OUT_OSC			SIO4_Z16_CBL_TXC_CFG_OUT_OSC
#define SIO4_HDLC_CABLE_TXC_OUT_OSC_INV		SIO4_Z16_CBL_TXC_CFG_OUT_OSC_INV
#define SIO4_HDLC_CABLE_TXC_OUT_0			SIO4_Z16_CBL_TXC_CFG_OUT_0
#define SIO4_HDLC_CABLE_TXC_OUT_1			SIO4_Z16_CBL_TXC_CFG_OUT_1
#define SIO4_HDLC_CABLE_TXC_OUT_USC_TXC		SIO4_Z16_CBL_TXC_CFG_OUT_USC_TXC	// preferred default
#define SIO4_HDLC_CABLE_TXC_OUT_USC_RXC		SIO4_Z16_CBL_TXC_CFG_OUT_USC_RXC
#define SIO4_HDLC_CABLE_TXC_OUT_CBL_RXC		SIO4_Z16_CBL_TXC_CFG_OUT_CBL_RXC
#define SIO4_HDLC_CABLE_TXC_OUT_CBL_RXA		SIO4_Z16_CBL_TXC_CFG_OUT_CBL_RXA

//*****************************************************************************
// sio4_hdlc_t.cable.txd					// PSRCR D19-D20
// sio4_hdlc_t_cable_txd()
#define SIO4_HDLC_CABLE_TXD_OUT_USC_TXD		SIO4_Z16_CBL_TXD_CFG_OUT_USC_TXD	// default
#define SIO4_HDLC_CABLE_TXD_OUT_0			SIO4_Z16_CBL_TXD_CFG_OUT_0
#define SIO4_HDLC_CABLE_TXD_OUT_1			SIO4_Z16_CBL_TXD_CFG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.osc.prog
// sio4_hdlc_t_osc_prog()
// Any value supported by the current oscillator.

//*****************************************************************************
// sio4_hdlc_t.osc.ref
// sio4_hdlc_t_osc_ref()
// Any value supported by the current oscillator.

//*****************************************************************************
// sio4_hdlc_t.rx.adrs_ctrl					// USC CMR D4-D7
// sio4_hdlc_t_rx_adrs_ctrl()
#define	SIO4_HDLC_RX_ADRS_CTRL_OFF			SIO4_USC_HDLC_RX_ADRS_CTRL_OFF
#define	SIO4_HDLC_RX_ADRS_CTRL_16			SIO4_USC_HDLC_RX_ADRS_CTRL_16		// default
#define	SIO4_HDLC_RX_ADRS_CTRL_24			SIO4_USC_HDLC_RX_ADRS_CTRL_24
#define	SIO4_HDLC_RX_ADRS_CTRL_32			SIO4_USC_HDLC_RX_ADRS_CTRL_32
#define	SIO4_HDLC_RX_ADRS_CTRL_EA_16		SIO4_USC_HDLC_RX_ADRS_CTRL_EA_16
#define	SIO4_HDLC_RX_ADRS_CTRL_EA_24		SIO4_USC_HDLC_RX_ADRS_CTRL_EA_24
#define	SIO4_HDLC_RX_ADRS_CTRL_EAC8			SIO4_USC_HDLC_RX_ADRS_CTRL_EAC8
#define	SIO4_HDLC_RX_ADRS_CTRL_EAC16		SIO4_USC_HDLC_RX_ADRS_CTRL_EAC16

//*****************************************************************************
// sio4_hdlc_t.rx.adrs						// USC RSR D0-D7
// sio4_hdlc_t_rx_adrs()
// Any value from 0x00 to 0xFF. The default is 0xFF.

//*****************************************************************************
// sio4_hdlc_t.rx.bit_rate
// sio4_hdlc_t_rx_bit_rate()
// This is the value computed from sio4_hdlc_init_t.rx_bit_rate.

//*****************************************************************************
// sio4_hdlc_t.rx.char_len					// USC RMR D2-D4
// sio4_hdlc_t_rx_char_len()
#define SIO4_HDLC_RX_CHAR_LEN_1				SIO4_USC_CHAR_LEN_1
#define SIO4_HDLC_RX_CHAR_LEN_2				SIO4_USC_CHAR_LEN_2
#define SIO4_HDLC_RX_CHAR_LEN_3				SIO4_USC_CHAR_LEN_3
#define SIO4_HDLC_RX_CHAR_LEN_4				SIO4_USC_CHAR_LEN_4
#define SIO4_HDLC_RX_CHAR_LEN_5				SIO4_USC_CHAR_LEN_5
#define SIO4_HDLC_RX_CHAR_LEN_6				SIO4_USC_CHAR_LEN_6
#define SIO4_HDLC_RX_CHAR_LEN_7				SIO4_USC_CHAR_LEN_7
#define SIO4_HDLC_RX_CHAR_LEN_8				SIO4_USC_CHAR_LEN_8					// default

//*****************************************************************************
// sio4_hdlc_t.rx.crc.enable				// USC RMR D9
// sio4_hdlc_t_rx_crc_enable()
#define SIO4_HDLC_RX_CRC_ENABLE_NO			SIO4_USC_CRC_ENABLE_NO
#define SIO4_HDLC_RX_CRC_ENABLE_YES			SIO4_USC_CRC_ENABLE_YES				// default

//*****************************************************************************
// sio4_hdlc_t.rx.crc.preset				// USC RMR D10
// sio4_hdlc_t_rx_crc_preset()
#define SIO4_HDLC_RX_CRC_PRESET_ALL_0		SIO4_USC_CRC_PRESET_ALL_0
#define SIO4_HDLC_RX_CRC_PRESET_ALL_1		SIO4_USC_CRC_PRESET_ALL_1			// default

//*****************************************************************************
// sio4_hdlc_t.rx.crc.type					// USC RMR D11-D12
// sio4_hdlc_t_rx_crc_type()
#define SIO4_HDLC_RX_CRC_TYPE_CCITT			SIO4_USC_CRC_TYPE_CCITT				// default
#define SIO4_HDLC_RX_CRC_TYPE_16			SIO4_USC_CRC_TYPE_16
#define SIO4_HDLC_RX_CRC_TYPE_32			SIO4_USC_CRC_TYPE_32

//*****************************************************************************
// sio4_hdlc_t.rx.enable					// USC RMR D0-D1
// sio4_hdlc_t_rx_enable()
#define SIO4_HDLC_RX_ENABLE_NO_NOW			SIO4_USC_ENABLE_NO_NOW
#define SIO4_HDLC_RX_ENABLE_NO_AFTER		SIO4_USC_ENABLE_NO_AFTER
#define SIO4_HDLC_RX_ENABLE_YES_NOW			SIO4_USC_ENABLE_YES_NOW				// default
#define SIO4_HDLC_RX_ENABLE_YES_W_AE		SIO4_USC_ENABLE_YES_W_AE

//*****************************************************************************
// sio4_hdlc_t.rx.encoding					// USC RMR D13-D15
// sio4_hdlc_t_rx_encoding()
#define SIO4_HDLC_RX_ENCODING_NRZ			SIO4_USC_DATA_ENCODE_NRZ
#define SIO4_HDLC_RX_ENCODING_NRZB			SIO4_USC_DATA_ENCODE_NRZB
#define SIO4_HDLC_RX_ENCODING_NRZI_MARK		SIO4_USC_DATA_ENCODE_NRZI_MARK		// FM1
#define SIO4_HDLC_RX_ENCODING_NRZI_SPACE	SIO4_USC_DATA_ENCODE_NRZI_SPACE		// FM0, default
#define SIO4_HDLC_RX_ENCODING_BI_MARK		SIO4_USC_DATA_ENCODE_BI_MARK
#define SIO4_HDLC_RX_ENCODING_BI_SPACE		SIO4_USC_DATA_ENCODE_BI_SPACE
#define SIO4_HDLC_RX_ENCODING_BI_LEVEL		SIO4_USC_DATA_ENCODE_BI_LEVEL		// Manchester
#define SIO4_HDLC_RX_ENCODING_D_BI_LEVEL	SIO4_USC_DATA_ENCODE_D_BI_LEVEL

//*****************************************************************************
// sio4_hdlc_t.rx.fifo.ae					// RAR D0-D15
// sio4_hdlc_t_rx_fifo_ae()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_hdlc_t.rx.fifo.af					// RAR D16-D31
// sio4_hdlc_t_rx_fifo_af()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_hdlc_t.rx.fifo.full_cfg				// CSR D19
// sio4_hdlc_t_rx_fifo_full_cfg				// CSR D19
#define SIO4_HDLC_RX_FIFO_FULL_CFG_OVER		SIO4_RX_FIFO_FULL_CFG_OVER			// default
#define SIO4_HDLC_RX_FIFO_FULL_CFG_DISABLE	SIO4_RX_FIFO_FULL_CFG_DISABLE

//*****************************************************************************
// sio4_hdlc_t.rx.fifo.size					// FSR D16-D21, read-only
// sio4_hdlc_t_rx_fifo_size()
// This field is filled in by the sio4_hdlc_init().

//*****************************************************************************
// sio4_hdlc_t.rx.io.mode
// sio4_hdlc_t_rx_io_mode()
#define SIO4_HDLC_RX_IO_MODE_PIO			GSC_IO_MODE_PIO						// default
#define SIO4_HDLC_RX_IO_MODE_DMA			GSC_IO_MODE_DMA
#define SIO4_HDLC_RX_IO_MODE_DMDMA			GSC_IO_MODE_DMDMA

//*****************************************************************************
// sio4_hdlc_t.rx.io.overrun
// sio4_hdlc_t_rx_io_overrun()
#define	SIO4_HDLC_RX_IO_OVERRUN_IGNORE		SIO4_IO_OVERRUN_IGNORE				// default
#define	SIO4_HDLC_RX_IO_OVERRUN_CHECK		SIO4_IO_OVERRUN_CHECK

//*****************************************************************************
// sio4_hdlc_t.rx.io.pio_thresh
// sio4_hdlc_t_rx_io_pio_thresh()
// Any non-negative value. The default is 64.

//*****************************************************************************
// sio4_hdlc_t.rx.io.timeout
// sio4_hdlc_t_rx_io_timeout()
#define SIO4_HDLC_RX_IO_TIMEOUT_DEFAULT		SIO4_IO_TIMEOUT_DEFAULT				// default
#define SIO4_HDLC_RX_IO_TIMEOUT_NO_SLEEP	SIO4_IO_TIMEOUT_NO_SLEEP			// PIO only
#define SIO4_HDLC_RX_IO_TIMEOUT_MIN			SIO4_IO_TIMEOUT_MIN
#define SIO4_HDLC_RX_IO_TIMEOUT_MAX			SIO4_IO_TIMEOUT_MAX

//*****************************************************************************
// sio4_hdlc_t.rx.io.underrun
// sio4_hdlc_t_rx_io_underrun()
#define	SIO4_HDLC_RX_IO_UNDERRUN_IGNORE		SIO4_IO_UNDERRUN_IGNORE				// default
#define	SIO4_HDLC_RX_IO_UNDERRUN_CHECK		SIO4_IO_UNDERRUN_CHECK

//*****************************************************************************
// sio4_hdlc_t.rx.mode						// USC CMR D0-D3
// sio4_hdlc_t_rx_mode()
#define SIO4_HDLC_RX_MODE_HDLC				SIO4_USC_MODE_HDLC					// Required!

//*****************************************************************************
// sio4_hdlc_t.rx.parity.enable				// USC RMR D5
// sio4_hdlc_t_rx_parity_enable()
#define SIO4_HDLC_RX_PARITY_ENABLE_NO		SIO4_USC_PAR_ENABLE_NO				// default
#define SIO4_HDLC_RX_PARITY_ENABLE_YES		SIO4_USC_PAR_ENABLE_YES

//*****************************************************************************
// sio4_hdlc_t.rx.parity.type				// USC RMR D6-D7
// sio4_hdlc_t_rx_parity_type()
#define SIO4_HDLC_RX_PARITY_TYPE_EVEN		SIO4_USC_PAR_TYPE_EVEN				// default
#define SIO4_HDLC_RX_PARITY_TYPE_ODD		SIO4_USC_PAR_TYPE_ODD
#define SIO4_HDLC_RX_PARITY_TYPE_ZERO		SIO4_USC_PAR_TYPE_ZERO
#define SIO4_HDLC_RX_PARITY_TYPE_ONE		SIO4_USC_PAR_TYPE_ONE

//*****************************************************************************
// sio4_hdlc_t.rx.queue_abort				// USC RMR D8
// sio4_hdlc_t_rx_queue_abort()
#define SIO4_HDLC_RX_QUEUE_ABORT_NO			SIO4_USC_RX_QUEUE_ABORT_NO
#define SIO4_HDLC_RX_QUEUE_ABORT_YES		SIO4_USC_RX_QUEUE_ABORT_YES			// default

//*****************************************************************************
// sio4_hdlc_t.rx.status_word				// CSR D3
// sio4_hdlc_t_rx_status_word()
#define SIO4_HDLC_RX_STATUS_WORD_DISABLE	SIO4_Z16_RX_STS_WRD_ENABLE_NO		// default
#define SIO4_HDLC_RX_STATUS_WORD_ENABLE		SIO4_Z16_RX_STS_WRD_ENABLE_YES

//*****************************************************************************
// sio4_hdlc_t.rx.sync_byte					// SBR D0-D7
// sio4_hdlc_t_rx_sync_byte()
// Any value from 0x00 to 0xFF. The default is zero.

//*****************************************************************************
// sio4_hdlc_t.rx.time_stamp.enable			// CSR D2
// sio4_hdlc_t_rx_time_stamp_enable()
#define SIO4_HDLC_RX_TIME_STAMP_ENABLE_NO	SIO4_TIME_STAMP_ENABLE_NO			// default
#define SIO4_HDLC_RX_TIME_STAMP_ENABLE_YES	SIO4_TIME_STAMP_ENABLE_YES

//*****************************************************************************
// sio4_hdlc_t.rx.time_stamp.clk_src		// BCR D22
// sio4_hdlc_t_rx_time_stamp_clk_src()
#define SIO4_HDLC_RX_TIME_STAMP_CLK_SRC_INT	SIO4_TIME_STAMP_SRC_INT				// default
#define SIO4_HDLC_RX_TIME_STAMP_CLK_SRC_EXT	SIO4_TIME_STAMP_SRC_EXT

//*****************************************************************************
// sio4_hdlc_t.tx.bit_rate
// sio4_hdlc_t_tx_bit_rate()
// This is the value computed from sio4_hdlc_init_t.tx_bit_rate.

//*****************************************************************************
// sio4_hdlc_t.tx.char_len					// USC TMR D2-D4
// sio4_hdlc_t_tx_char_len()
#define SIO4_HDLC_TX_CHAR_LEN_1				SIO4_USC_CHAR_LEN_1
#define SIO4_HDLC_TX_CHAR_LEN_2				SIO4_USC_CHAR_LEN_2
#define SIO4_HDLC_TX_CHAR_LEN_3				SIO4_USC_CHAR_LEN_3
#define SIO4_HDLC_TX_CHAR_LEN_4				SIO4_USC_CHAR_LEN_4
#define SIO4_HDLC_TX_CHAR_LEN_5				SIO4_USC_CHAR_LEN_5
#define SIO4_HDLC_TX_CHAR_LEN_6				SIO4_USC_CHAR_LEN_6
#define SIO4_HDLC_TX_CHAR_LEN_7				SIO4_USC_CHAR_LEN_7
#define SIO4_HDLC_TX_CHAR_LEN_8				SIO4_USC_CHAR_LEN_8					// default

//*****************************************************************************
// sio4_hdlc_t.tx.crc.enable				// USC TMR D9
// sio4_hdlc_t_tx_crc_enable()
#define SIO4_HDLC_TX_CRC_ENABLE_NO			SIO4_USC_CRC_ENABLE_NO
#define SIO4_HDLC_TX_CRC_ENABLE_YES			SIO4_USC_CRC_ENABLE_YES				// default

//*****************************************************************************
// sio4_hdlc_t.tx.crc.on_end				// USC TMR D8
// sio4_hdlc_t_tx_crc_on_end()
#define SIO4_HDLC_TX_CRC_ON_END_NO			SIO4_USC_TX_CRC_ON_END_NO
#define SIO4_HDLC_TX_CRC_ON_END_YES			SIO4_USC_TX_CRC_ON_END_YES			// default

//*****************************************************************************
// sio4_hdlc_t.tx.crc.preset				// USC TMR D10
// sio4_hdlc_t_tx_crc_preset()
#define SIO4_HDLC_TX_CRC_PRESET_ALL_0		SIO4_USC_CRC_PRESET_ALL_0
#define SIO4_HDLC_TX_CRC_PRESET_ALL_1		SIO4_USC_CRC_PRESET_ALL_1			// default

//*****************************************************************************
// sio4_hdlc_t.tx.crc.type					// USC TMR D11-D12
// sio4_hdlc_t_tx_crc_type()
#define SIO4_HDLC_TX_CRC_TYPE_CCITT			SIO4_USC_CRC_TYPE_CCITT				// default
#define SIO4_HDLC_TX_CRC_TYPE_16			SIO4_USC_CRC_TYPE_16
#define SIO4_HDLC_TX_CRC_TYPE_32			SIO4_USC_CRC_TYPE_32

//*****************************************************************************
// sio4_hdlc_t.tx.enable					// USC TMR D0-D1
// sio4_hdlc_t_tx_enable()
#define SIO4_HDLC_TX_ENABLE_NO_NOW			SIO4_USC_ENABLE_NO_NOW
#define SIO4_HDLC_TX_ENABLE_NO_AFTER		SIO4_USC_ENABLE_NO_AFTER
#define SIO4_HDLC_TX_ENABLE_YES_NOW			SIO4_USC_ENABLE_YES_NOW				// default
#define SIO4_HDLC_TX_ENABLE_YES_W_AE		SIO4_USC_ENABLE_YES_W_AE

//*****************************************************************************
// sio4_hdlc_t.tx.encoding					// USC TMR D13-D15
// sio4_hdlc_t_tx_encoding()
#define SIO4_HDLC_TX_ENCODING_NRZ			SIO4_USC_DATA_ENCODE_NRZ
#define SIO4_HDLC_TX_ENCODING_NRZB			SIO4_USC_DATA_ENCODE_NRZB
#define SIO4_HDLC_TX_ENCODING_NRZI_MARK		SIO4_USC_DATA_ENCODE_NRZI_MARK		// FM1
#define SIO4_HDLC_TX_ENCODING_NRZI_SPACE	SIO4_USC_DATA_ENCODE_NRZI_SPACE		// FM0, default
#define SIO4_HDLC_TX_ENCODING_BI_MARK		SIO4_USC_DATA_ENCODE_BI_MARK
#define SIO4_HDLC_TX_ENCODING_BI_SPACE		SIO4_USC_DATA_ENCODE_BI_SPACE
#define SIO4_HDLC_TX_ENCODING_BI_LEVEL		SIO4_USC_DATA_ENCODE_BI_LEVEL		// Manchester
#define SIO4_HDLC_TX_ENCODING_D_BI_LEVEL	SIO4_USC_DATA_ENCODE_D_BI_LEVEL

//*****************************************************************************
// sio4_hdlc_t.tx.fifo.ae					// TAR D0-D15
// sio4_hdlc_t_tx_fifo_ae()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_hdlc_t.tx.fifo.af					// TAR D16-D31
// sio4_hdlc_t_tx_fifo_af()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_hdlc_t.tx.fifo.empty_cfg			// CSR D18, D26
// sio4_hdlc_t_tx_fifo_empty_cfg()
#define SIO4_HDLC_TX_FIFO_EMPTY_CFG_IGNORE	SIO4_TX_FIFO_EMPTY_CFG_IGNORE		// do nothing, default
#define SIO4_HDLC_TX_FIFO_EMPTY_CFG_TX_OFF	SIO4_TX_FIFO_EMPTY_CFG_TX_OFF		// Disable Transmitter

//*****************************************************************************
// sio4_hdlc_t.tx.fifo.size					// FSR D0-D15, read-only
// sio4_hdlc_t_tx_fifo_size()
// This field is filled in by the sio4_hdlc_init().

//*****************************************************************************
// sio4_hdlc_t.tx.fifo.space_cfg			// CSR D4-D5
// sio4_hdlc_t_tx_fifo_space_cfg()
#define SIO4_HDLC_TX_FIFO_SPACE_CFG_RX_2X	SIO4_FIFO_SPACE_CFG_RX_2X			// Rx has 2x, Tx has x, default
#define SIO4_HDLC_TX_FIFO_SPACE_CFG_TX_2X	SIO4_FIFO_SPACE_CFG_TX_2X			// Tx has 2x, Rx has x

//*****************************************************************************
// sio4_hdlc_t.tx.idle_cond					// USC TCSR D8-D10
// sio4_hdlc_t_tx_idle_cond()
#define SIO4_HDLC_TX_IDLE_COND_DEFAULT		SIO4_USC_TX_IDLE_COND_DEFAULT		// default
#define SIO4_HDLC_TX_IDLE_COND_0_1			SIO4_USC_TX_IDLE_COND_0_1
#define SIO4_HDLC_TX_IDLE_COND_0			SIO4_USC_TX_IDLE_COND_0
#define SIO4_HDLC_TX_IDLE_COND_1			SIO4_USC_TX_IDLE_COND_1
#define SIO4_HDLC_TX_IDLE_COND_MARK_SPACE	SIO4_USC_TX_IDLE_COND_MARK_SPACE
#define SIO4_HDLC_TX_IDLE_COND_SPACE		SIO4_USC_TX_IDLE_COND_SPACE
#define SIO4_HDLC_TX_IDLE_COND_MARK			SIO4_USC_TX_IDLE_COND_MARK

//*****************************************************************************
// sio4_hdlc_t.tx.io.mode
// sio4_hdlc_t_tx_io_mode()
#define SIO4_HDLC_TX_IO_MODE_PIO			GSC_IO_MODE_PIO	// default
#define SIO4_HDLC_TX_IO_MODE_DMA			GSC_IO_MODE_DMA
#define SIO4_HDLC_TX_IO_MODE_DMDMA			GSC_IO_MODE_DMDMA

//*****************************************************************************
// sio4_hdlc_t.tx.io.overrun
// sio4_hdlc_t_tx_io_overrun()
#define	SIO4_HDLC_TX_IO_OVERRUN_IGNORE		SIO4_IO_OVERRUN_IGNORE				// default
#define	SIO4_HDLC_TX_IO_OVERRUN_CHECK		SIO4_IO_OVERRUN_CHECK

//*****************************************************************************
// sio4_hdlc_t.tx.io.pio_thresh
// sio4_hdlc_t_tx_io_pio_thresh()
// Any non-negative value. The default is 64.

//*****************************************************************************
// sio4_hdlc_t.tx.io.timeout
// sio4_hdlc_t_tx_io_timeout()
#define SIO4_HDLC_TX_IO_TIMEOUT_DEFAULT		SIO4_IO_TIMEOUT_DEFAULT				// default
#define SIO4_HDLC_TX_IO_TIMEOUT_NO_SLEEP	SIO4_IO_TIMEOUT_NO_SLEEP			// PIO only
#define SIO4_HDLC_TX_IO_TIMEOUT_MIN			SIO4_IO_TIMEOUT_MIN
#define SIO4_HDLC_TX_IO_TIMEOUT_MAX			SIO4_IO_TIMEOUT_MAX

//*****************************************************************************
// sio4_hdlc_t.tx.mode						// USC CMR D8-D11
// sio4_hdlc_t_tx_mode()
#define SIO4_HDLC_TX_MODE_HDLC				SIO4_USC_MODE_HDLC					// Required!

//*****************************************************************************
// sio4_hdlc_t.tx.parity.enable				// USC TMR D5
// sio4_hdlc_t_tx_parity_enable()
#define SIO4_HDLC_TX_PARITY_ENABLE_NO		SIO4_USC_PAR_ENABLE_NO				// default
#define SIO4_HDLC_TX_PARITY_ENABLE_YES		SIO4_USC_PAR_ENABLE_YES

//*****************************************************************************
// sio4_hdlc_t.tx.parity.type				// USC TMR D6-D7
// sio4_hdlc_t_tx_parity_type()
#define SIO4_HDLC_TX_PARITY_TYPE_EVEN		SIO4_USC_PAR_TYPE_EVEN				// default
#define SIO4_HDLC_TX_PARITY_TYPE_ODD		SIO4_USC_PAR_TYPE_ODD
#define SIO4_HDLC_TX_PARITY_TYPE_ZERO		SIO4_USC_PAR_TYPE_ZERO
#define SIO4_HDLC_TX_PARITY_TYPE_ONE		SIO4_USC_PAR_TYPE_ONE

//*****************************************************************************
// sio4_hdlc_t.tx.preamble.enable			// USC CMR D13
// sio4_hdlc_t_tx_preamble_enable()
#define SIO4_HDLC_TX_PREAMBLE_ENABLE_NO		SIO4_USC_SMONO_TX_ACTIVE_WAIT		// default
#define SIO4_HDLC_TX_PREAMBLE_ENABLE_YES	SIO4_USC_SMONO_TX_ACTIVE_ON_SYNC

//*****************************************************************************
// sio4_hdlc_t.tx.preamble.flag				// USC CCR D12
// sio4_hdlc_t_tx_preamble_flag()
#define SIO4_HDLC_TX_PREAMBLE_FLAG_NO		SIO4_USC_TX_PREAMBLE_FLAG_NO
#define SIO4_HDLC_TX_PREAMBLE_FLAG_YES		SIO4_USC_TX_PREAMBLE_FLAG_YES		// default

//*****************************************************************************
// sio4_hdlc_t.tx.preamble.length				// USC CCR D10-D11
// sio4_hdlc_t_tx_preamble_length()
#define SIO4_HDLC_TX_PREAMBLE_LENGTH_8_BITS		SIO4_USC_TX_PREAMBLE_LEN_8_BITS	// default
#define SIO4_HDLC_TX_PREAMBLE_LENGTH_16_BITS	SIO4_USC_TX_PREAMBLE_LEN_16_BITS
#define SIO4_HDLC_TX_PREAMBLE_LENGTH_32_BITS	SIO4_USC_TX_PREAMBLE_LEN_32_BITS
#define SIO4_HDLC_TX_PREAMBLE_LENGTH_64_BITS	SIO4_USC_TX_PREAMBLE_LEN_64_BITS

//*****************************************************************************
// sio4_hdlc_t.tx.preamble.pattern			// USC CCR D8-D9
// sio4_hdlc_t_tx_preamble_pattern()
#define SIO4_HDLC_TX_PREAMBLE_PATTERN_0		SIO4_USC_TX_PREAMBLE_PAT_0
#define SIO4_HDLC_TX_PREAMBLE_PATTERN_1		SIO4_USC_TX_PREAMBLE_PAT_1			// default
#define SIO4_HDLC_TX_PREAMBLE_PATTERN_10	SIO4_USC_TX_PREAMBLE_PAT_10
#define SIO4_HDLC_TX_PREAMBLE_PATTERN_01	SIO4_USC_TX_PREAMBLE_PAT_01

//*****************************************************************************
// sio4_hdlc_t.tx.share_0					// USC CMR D12
// sio4_hdlc_t_tx_share_0()
#define SIO4_HDLC_TX_SHARE_0_NO				SIO4_USC_HDLC_TX_SHARE_0_NO
#define SIO4_HDLC_TX_SHARE_0_YES			SIO4_USC_HDLC_TX_SHARE_0_YES		// default

//*****************************************************************************
// sio4_hdlc_t.tx.underrun					// USC CMR D14-D15
// sio4_hdlc_t_tx_underrun()
#define SIO4_HDLC_TX_UNDERRUN_ABORT			SIO4_USC_HDLC_TX_UNDERRUN_ABORT
#define SIO4_HDLC_TX_UNDERRUN_EXT_A			SIO4_USC_HDLC_TX_UNDERRUN_EXT_A
#define SIO4_HDLC_TX_UNDERRUN_FLAG			SIO4_USC_HDLC_TX_UNDERRUN_FLAG
#define SIO4_HDLC_TX_UNDERRUN_CRC_F			SIO4_USC_HDLC_TX_UNDERRUN_CRC_F		// default

//*****************************************************************************
// sio4_hdlc_t.tx.wait_underrun				// USC TCSR D11
// sio4_hdlc_t_tx_wait_underrun()
#define SIO4_HDLC_TX_WAIT_UNDERRUN_NO		SIO4_USC_TX_WAIT_UNDERRUN_NO		// default
#define SIO4_HDLC_TX_WAIT_UNDERRUN_YES		SIO4_USC_TX_WAIT_UNDERRUN_YES

//*****************************************************************************
// sio4_hdlc_t.usc.brg0.clk_src				// USC CMCR D8-D9
// sio4_hdlc_t_usc_brg0_clk_src()
#define SIO4_HDLC_USC_BRG0_CLK_SRC_CTR0		SIO4_USC_BRG_CLK_SRC_CTR0			// default
#define SIO4_HDLC_USC_BRG0_CLK_SRC_CTR1		SIO4_USC_BRG_CLK_SRC_CTR1
#define SIO4_HDLC_USC_BRG0_CLK_SRC_RXC_PIN	SIO4_USC_BRG_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_BRG0_CLK_SRC_TXC_PIN	SIO4_USC_BRG_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_hdlc_t.usc.brg0.divider				// USC TC0R D0-D15
// sio4_hdlc_t_usc_brg0_divider()
// Any value from 0x0000 to 0xFFFF. The default is zero.

//*****************************************************************************
// sio4_hdlc_t.usc.brg0.enable				// USC HCR D0
// sio4_hdlc_t_usc_brg0_enable()
#define SIO4_HDLC_USC_BRG0_ENABLE_NO		SIO4_USC_BRG_ENABLE_NO				// default
#define SIO4_HDLC_USC_BRG0_ENABLE_YES		SIO4_USC_BRG_ENABLE_YES

//*****************************************************************************
// sio4_hdlc_t.usc.brg0.mode				// USC HCR D1
// sio4_hdlc_t_usc_brg0_mode()
#define SIO4_HDLC_USC_BRG0_MODE_CONT		SIO4_USC_BRG_MODE_CONT				// default
#define SIO4_HDLC_USC_BRG0_MODE_SINGLE		SIO4_USC_BRG_MODE_SINGLE

//*****************************************************************************
// sio4_hdlc_t.usc.brg1.clk_src				// USC CMCR D10-D11
// sio4_hdlc_t_usc_brg1_clk_src()
#define SIO4_HDLC_USC_BRG1_CLK_SRC_CTR0		SIO4_USC_BRG_CLK_SRC_CTR0			// default
#define SIO4_HDLC_USC_BRG1_CLK_SRC_CTR1		SIO4_USC_BRG_CLK_SRC_CTR1
#define SIO4_HDLC_USC_BRG1_CLK_SRC_RXC_PIN	SIO4_USC_BRG_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_BRG1_CLK_SRC_TXC_PIN	SIO4_USC_BRG_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_hdlc_t.usc.brg1.divider				// USC TC1R D0-D15
// sio4_hdlc_t_usc_brg1_divider()
// Any value from 0x0000 to 0xFFFF. The default is zero.

//*****************************************************************************
// sio4_hdlc_t.usc.brg1.enable				// USC HCR D4
// sio4_hdlc_t_usc_brg1_enable()
#define SIO4_HDLC_USC_BRG1_ENABLE_NO		SIO4_USC_BRG_ENABLE_NO				// default
#define SIO4_HDLC_USC_BRG1_ENABLE_YES		SIO4_USC_BRG_ENABLE_YES

//*****************************************************************************
// sio4_hdlc_t.usc.brg1.mode				// USC HCR D5
// sio4_hdlc_t_usc_brg1_mode()
#define SIO4_HDLC_USC_BRG1_MODE_CONT		SIO4_USC_BRG_MODE_CONT				// disable
#define SIO4_HDLC_USC_BRG1_MODE_SINGLE		SIO4_USC_BRG_MODE_SINGLE

//*****************************************************************************
// sio4_hdlc_t.usc.ctr0.clk_src				// USC CMCR D12-D13
// sio4_hdlc_t_usc_ctr0_clk_src()
#define SIO4_HDLC_USC_CTR0_CLK_SRC_DISABLE	SIO4_USC_CTR_CLK_SRC_DISABLE		// default
#define SIO4_HDLC_USC_CTR0_CLK_SRC_RXC_PIN	SIO4_USC_CTR_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_CTR0_CLK_SRC_TXC_PIN	SIO4_USC_CTR_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_hdlc_t.usc.ctr0.rate				// USC HCR D14-D15
// sio4_hdlc_t_usc_ctr0_rate()
#define SIO4_HDLC_USC_CTR0_RATE_32X			SIO4_USC_CTR0_RATE_32X
#define SIO4_HDLC_USC_CTR0_RATE_16X			SIO4_USC_CTR0_RATE_16X
#define SIO4_HDLC_USC_CTR0_RATE_8X			SIO4_USC_CTR0_RATE_8X
#define SIO4_HDLC_USC_CTR0_RATE_4X			SIO4_USC_CTR0_RATE_4X				// default

//*****************************************************************************
// sio4_hdlc_t.usc.ctr1.clk_src				// USC CMCR D14-D15
// sio4_hdlc_t_usc_ctr1_clk_src()
#define SIO4_HDLC_USC_CTR1_CLK_SRC_DISABLE	SIO4_USC_CTR_CLK_SRC_DISABLE		// default
#define SIO4_HDLC_USC_CTR1_CLK_SRC_RXC_PIN	SIO4_USC_CTR_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_CTR1_CLK_SRC_TXC_PIN	SIO4_USC_CTR_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_hdlc_t.usc.ctr1.rate_src			// USC HCR D13
// sio4_hdlc_t_usc_ctr1_rate_src()
#define SIO4_HDLC_USC_CTR1_RATE_SRC_CTR0	SIO4_USC_CTR1_RATE_CTR0				// default
#define SIO4_HDLC_USC_CTR1_RATE_SRC_DPLL	SIO4_USC_CTR1_RATE_DPLL

//*****************************************************************************
// sio4_hdlc_t.usc.cts						// PSRCR D9-D10, USC IOCR D14-D15
// sio4_hdlc_t_usc_cts()
#define SIO4_HDLC_USC_CTS_TRI				SIO4_USC_CTS_CFG_TRI				// default
#define SIO4_HDLC_USC_CTS_IN_CBL_CTS		SIO4_USC_CTS_CFG_IN_CBL_CTS
#define SIO4_HDLC_USC_CTS_OUT_0				SIO4_USC_CTS_CFG_OUT_0				// lower nibble: PSRCR D9-D10
#define SIO4_HDLC_USC_CTS_OUT_1				SIO4_USC_CTS_CFG_OUT_1				// upper nibble: USC IOCR D14-D15

//*****************************************************************************
// sio4_hdlc_t.usc.tx.cts_legacy			USC IOCR D14-D15
// sio4_hdlc_t_usc_tx_cts_legacy()
#define SIO4_HDLC_USC_TX_CTS_LEG_IN			SIO4_USC_CTS_LEG_IN					// default
#define SIO4_HDLC_USC_TX_CTS_LEG_OUT_0		SIO4_USC_CTS_LEG_OUT_0
#define SIO4_HDLC_USC_TX_CTS_LEG_OUT_1		SIO4_USC_CTS_LEG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.usc.dcd						// PSRCR D11-D12, USC IOCR D12-D13
// sio4_hdlc_t_usc_dcd()
#define SIO4_HDLC_USC_DCD_DISABLE			SIO4_USC_DCD_CFG_DISABLE			// default
#define SIO4_HDLC_USC_DCD_IN_DCD_CBL_DCD	SIO4_USC_DCD_CFG_IN_DCD_CBL_DCD
#define SIO4_HDLC_USC_DCD_IN_SYNC_CBL_DCD	SIO4_USC_DCD_CFG_IN_SYNC_CBL_DCD
#define SIO4_HDLC_USC_DCD_OUT_0				SIO4_USC_DCD_CFG_OUT_0				// lower nibble: PSRCR D11-D12
#define SIO4_HDLC_USC_DCD_OUT_1				SIO4_USC_DCD_CFG_OUT_1				// upper nibble: USC IOCR D12-D13

//*****************************************************************************
// sio4_hdlc_t.usc.dcd_legacy				USC IOCR D12-D13
// sio4_hdlc_t_usc_dcd_legacy()
#define SIO4_HDLC_USC_DCD_LEG_IN_DCD		SIO4_USC_DCD_LEG_IN_DCD				// default
#define SIO4_HDLC_USC_DCD_LEG_IN_SYNC		SIO4_USC_DCD_LEG_IN_SYNC
#define SIO4_HDLC_USC_DCD_LEG_OUT_0			SIO4_USC_DCD_LEG_OUT_0
#define SIO4_HDLC_USC_DCD_LEG_OUT_1			SIO4_USC_DCD_LEG_OUT_1

//*****************************************************************************
// sio4_hdlc_t.usc.dpll.edge				// USC CCSR D8-D9
// sio4_hdlc_t_usc_dpll_edge()
#define SIO4_HDLC_USC_DPLL_EDGE_BOTH_EDGE	SIO4_USC_DPLL_ADJ_SYNC_BOTH_EDGE
#define SIO4_HDLC_USC_DPLL_EDGE_RISE_EDGE	SIO4_USC_DPLL_ADJ_SYNC_RISE_EDGE
#define SIO4_HDLC_USC_DPLL_EDGE_FALL_EDGE	SIO4_USC_DPLL_ADJ_SYNC_FALL_EDGE
#define SIO4_HDLC_USC_DPLL_EDGE_INHIBIT		SIO4_USC_DPLL_ADJ_SYNC_INHIBIT		// default

//*****************************************************************************
// sio4_hdlc_t.usc.dpll.clk_src				// USC CMCR D6-D7
// sio4_hdlc_t_usc_dpll_clk_src()
#define SIO4_HDLC_USC_DPLL_CLK_SRC_BRG0		SIO4_USC_DPLL_CLK_SRC_BRG0			// default
#define SIO4_HDLC_USC_DPLL_CLK_SRC_BRG1		SIO4_USC_DPLL_CLK_SRC_BRG1
#define SIO4_HDLC_USC_DPLL_CLK_SRC_RXC_PIN	SIO4_USC_DPLL_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_DPLL_CLK_SRC_TXC_PIN	SIO4_USC_DPLL_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_hdlc_t.usc.dpll.mode				// USC HCR D8-D9
// sio4_hdlc_t_usc_dpll_mode()
#define SIO4_HDLC_USC_DPLL_MODE_DISABLE		SIO4_USC_DPLL_MODE_DISABLE			// default
#define SIO4_HDLC_USC_DPLL_MODE_NRZ_NRZI	SIO4_USC_DPLL_MODE_NRZ_NRZI
#define SIO4_HDLC_USC_DPLL_MODE_BIPH_MS		SIO4_USC_DPLL_MODE_BIPH_MS			// Biphase-Mark/Space
#define SIO4_HDLC_USC_DPLL_MODE_BIPH_LVL	SIO4_USC_DPLL_MODE_BIPH_LVL			// Biphase-Level

//*****************************************************************************
// sio4_hdlc_t.usc.dpll.rate				// USC HCR D10-D11
// sio4_hdlc_t_usc_dpll_rate()
#define SIO4_HDLC_USC_DPLL_RATE_32X			SIO4_USC_DPLL_RATE_32X
#define SIO4_HDLC_USC_DPLL_RATE_16X			SIO4_USC_DPLL_RATE_16X
#define SIO4_HDLC_USC_DPLL_RATE_8X			SIO4_USC_DPLL_RATE_8X				// default
#define SIO4_HDLC_USC_DPLL_RATE_CTR1_4X		SIO4_USC_DPLL_RATE_CTR1_4X			// Used only for CRT1 rate

//*****************************************************************************
// sio4_hdlc_t.usc.mode						// USC CCAR D8-D9
// sio4_hdlc_t_usc_mode()
#define SIO4_HDLC_USC_MODE_NORMAL			SIO4_USC_OPER_MODE_NORMAL			// default
#define SIO4_HDLC_USC_MODE_AUTO_ECHO		SIO4_USC_OPER_MODE_AUTO_ECHO
#define SIO4_HDLC_USC_MODE_LOOPBACK_EXT		SIO4_USC_OPER_MODE_EXT_LOOPBACK
#define SIO4_HDLC_USC_MODE_LOOPBACK_INT		SIO4_USC_OPER_MODE_INT_LOOPBACK

//*****************************************************************************
// sio4_hdlc_t.usc.rx.clk_src				// USC CMCR D0-D2
// sio4_hdlc_t_usc_rx_clk_src()
#define SIO4_HDLC_USC_RX_CLK_SRC_DISABLE	SIO4_USC_CLK_SRC_DISABLE			// default
#define SIO4_HDLC_USC_RX_CLK_SRC_RXC_PIN	SIO4_USC_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_RX_CLK_SRC_TXC_PIN	SIO4_USC_CLK_SRC_TXC_PIN
#define SIO4_HDLC_USC_RX_CLK_SRC_DPLL		SIO4_USC_CLK_SRC_DPLL
#define SIO4_HDLC_USC_RX_CLK_SRC_BRG0		SIO4_USC_CLK_SRC_BRG0
#define SIO4_HDLC_USC_RX_CLK_SRC_BRG1		SIO4_USC_CLK_SRC_BRG1
#define SIO4_HDLC_USC_RX_CLK_SRC_CTR0		SIO4_USC_CLK_SRC_CTR0
#define SIO4_HDLC_USC_RX_CLK_SRC_CTR1		SIO4_USC_CLK_SRC_CTR1

//*****************************************************************************
// sio4_hdlc_t.usc.rx.rxc					// PSRCR D3-D5, USC IOCR D0-D2
// sio4_hdlc_t_usc_rx_rxc()
#define SIO4_HDLC_USC_RX_RXC_IN_OSC			SIO4_USC_RXC_CFG_IN_OSC				// lower nibble: PSRCR D3-D5
#define SIO4_HDLC_USC_RX_RXC_IN_OSC_INV		SIO4_USC_RXC_CFG_IN_OSC_INV			// upper nibble: USC IOCR D0-D2
#define SIO4_HDLC_USC_RX_RXC_IN_0			SIO4_USC_RXC_CFG_IN_0				// default
#define SIO4_HDLC_USC_RX_RXC_IN_1			SIO4_USC_RXC_CFG_IN_1
#define SIO4_HDLC_USC_RX_RXC_IN_CBL_RXC		SIO4_USC_RXC_CFG_IN_CBL_RXC
#define SIO4_HDLC_USC_RX_RXC_IN_CBL_RXAUX	SIO4_USC_RXC_CFG_IN_CBL_RXAUXC
#define SIO4_HDLC_USC_RX_RXC_OUT_CLK		SIO4_USC_RXC_CFG_OUT_RX_CLK
#define SIO4_HDLC_USC_RX_RXC_OUT_BYTE_CLK	SIO4_USC_RXC_CFG_OUT_RX_BYTE_CLK
#define SIO4_HDLC_USC_RX_RXC_OUT_SYNC		SIO4_USC_RXC_CFG_OUT_SYNC
#define SIO4_HDLC_USC_RX_RXC_OUT_BRG0		SIO4_USC_RXC_CFG_OUT_BRG0
#define SIO4_HDLC_USC_RX_RXC_OUT_BRG1		SIO4_USC_RXC_CFG_OUT_BRG1
#define SIO4_HDLC_USC_RX_RXC_OUT_CTR0		SIO4_USC_RXC_CFG_OUT_CTR0
#define SIO4_HDLC_USC_RX_RXC_OUT_DPLL_RX	SIO4_USC_RXC_CFG_OUT_DPLL_RX

//*****************************************************************************
// sio4_hdlc_t.usc.rx.rxc_legacy				USC IOCR D0-D2
// sio4_hdlc_t_usc_rx_rxc_legacy()
#define SIO4_HDLC_USC_RX_RXC_LEG_IN				SIO4_USC_RXC_LEG_IN				// legacy
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_CLK		SIO4_USC_RXC_LEG_OUT_RX_CLK
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_BYTE_CLK	SIO4_USC_RXC_LEG_OUT_RX_BYTE_CLK
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_SYNC		SIO4_USC_RXC_LEG_OUT_SYNC
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_BRG0		SIO4_USC_RXC_LEG_OUT_BRG0
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_BRG1		SIO4_USC_RXC_LEG_OUT_BRG1
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_CTR0		SIO4_USC_RXC_LEG_OUT_CTR0
#define SIO4_HDLC_USC_RX_RXC_LEG_OUT_DPLL_RX	SIO4_USC_RXC_LEG_OUT_DPLL_RX

//*****************************************************************************
// sio4_hdlc_t.usc.tx.clk_src				// USC CMCR D3-D5
// sio4_hdlc_t_usc_tx_clk_src()
#define SIO4_HDLC_USC_TX_CLK_SRC_DISABLE	SIO4_USC_CLK_SRC_DISABLE			// default
#define SIO4_HDLC_USC_TX_CLK_SRC_RXC_PIN	SIO4_USC_CLK_SRC_RXC_PIN
#define SIO4_HDLC_USC_TX_CLK_SRC_TXC_PIN	SIO4_USC_CLK_SRC_TXC_PIN
#define SIO4_HDLC_USC_TX_CLK_SRC_DPLL		SIO4_USC_CLK_SRC_DPLL
#define SIO4_HDLC_USC_TX_CLK_SRC_BRG0		SIO4_USC_CLK_SRC_BRG0
#define SIO4_HDLC_USC_TX_CLK_SRC_BRG1		SIO4_USC_CLK_SRC_BRG1
#define SIO4_HDLC_USC_TX_CLK_SRC_CTR0		SIO4_USC_CLK_SRC_CTR0
#define SIO4_HDLC_USC_TX_CLK_SRC_CTR1		SIO4_USC_CLK_SRC_CTR1

//*****************************************************************************
// sio4_hdlc_t.usc.tx.txc					// PSRCR D0-D2, USC IOCR D3-D5
// sio4_hdlc_t_usc_tx_txc()
#define SIO4_HDLC_USC_TX_TXC_IN_OSC			SIO4_USC_TXC_CFG_IN_OSC				// Lower nibble: PSRCR D0-D2
#define SIO4_HDLC_USC_TX_TXC_IN_OSC_INV		SIO4_USC_TXC_CFG_IN_OSC_INV			// Upper nibble: USC IOCR D3-D5
#define SIO4_HDLC_USC_TX_TXC_IN_0			SIO4_USC_TXC_CFG_IN_0				// default
#define SIO4_HDLC_USC_TX_TXC_IN_1			SIO4_USC_TXC_CFG_IN_1
#define SIO4_HDLC_USC_TX_TXC_IN_CBL_RXC		SIO4_USC_TXC_CFG_IN_CBL_RXC
#define SIO4_HDLC_USC_TX_TXC_IN_CBL_RXAUX	SIO4_USC_TXC_CFG_IN_CBL_RXAUXC
#define SIO4_HDLC_USC_TX_TXC_OUT_CLK		SIO4_USC_TXC_CFG_OUT_TX_CLK
#define SIO4_HDLC_USC_TX_TXC_OUT_BYTE_CLK	SIO4_USC_TXC_CFG_OUT_TX_BYTE_CLK
#define SIO4_HDLC_USC_TX_TXC_OUT_COMP		SIO4_USC_TXC_CFG_OUT_TX_COMP
#define SIO4_HDLC_USC_TX_TXC_OUT_BRG0		SIO4_USC_TXC_CFG_OUT_BRG0
#define SIO4_HDLC_USC_TX_TXC_OUT_BRG1		SIO4_USC_TXC_CFG_OUT_BRG1
#define SIO4_HDLC_USC_TX_TXC_OUT_CTR1		SIO4_USC_TXC_CFG_OUT_CTR1
#define SIO4_HDLC_USC_TX_TXC_OUT_DPLL_TX	SIO4_USC_TXC_CFG_OUT_DPLL_TX

//*****************************************************************************
// sio4_hdlc_t.usc.tx.txc_legacy				USC IOCR D3-D5
// sio4_hdlc_t_usc_tx_txc_legacy()
#define SIO4_HDLC_USC_TX_TXC_LEG_IN				SIO4_USC_TXC_LEG_IN				// default
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_CLK		SIO4_USC_TXC_LEG_OUT_TX_CLK
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_BYTE_CLK	SIO4_USC_TXC_LEG_OUT_TX_BYTE_CLK
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_COMP		SIO4_USC_TXC_LEG_OUT_TX_COMP
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_BRG0		SIO4_USC_TXC_LEG_OUT_BRG0
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_BRG1		SIO4_USC_TXC_LEG_OUT_BRG1
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_CTR1		SIO4_USC_TXC_LEG_OUT_CTR1
#define SIO4_HDLC_USC_TX_TXC_LEG_OUT_DPLL_TX	SIO4_USC_TXC_LEG_OUT_DPLL_TX

//*****************************************************************************
// sio4_hdlc_t.usc.txd						// USC IOCR D6-D7
// sio4_hdlc_t_usc_txd()
#define SIO4_HDLC_USC_TXD_OUT_TXD			SIO4_USC_TXD_CFG_OUT_TXD			// default
#define SIO4_HDLC_USC_TXD_TRI				SIO4_USC_TXD_CFG_TRI
#define SIO4_HDLC_USC_TXD_OUT_0				SIO4_USC_TXD_CFG_OUT_0
#define SIO4_HDLC_USC_TXD_OUT_1				SIO4_USC_TXD_CFG_OUT_1



// data types *****************************************************************

typedef enum
{
	SIO4_HDLC_ACTION_GET,
	SIO4_HDLC_ACTION_INIT,
	SIO4_HDLC_ACTION_SET,
	SIO4_HDLC_ACTION_SHOW,
	SIO4_HDLC_ACTION_VERIFY
} sio4_hdlc_action_t;

typedef struct
{
	// These are filled in by the caller before the transfer.
	void*		buf;
	s32			size;		// max number of bytes to get

	// These are filled in by the library after the transfer.
	s32			rcvd;		// Number of bytes transferred.
	u32			flags;		// SIO4_HDLC_FLAG_RX_*
	s32			last;		// SIO4_HDLC_RX_LAST_CHAR_LEN_*
} sio4_hdlc_rx_frame_t;

typedef struct
{
	// These are filled in by the caller before the transfer.
	void*		buf;
	s32			count;		// number of bytes to send
	s32			last;		// SIO4_HDLC_TX_LAST_CHAR_LEN_*

	// These are filled in by the library after the transfer.
	s32			sent;		// Number of bytes transferred.
	u32			flags;		// SIO4_HDLC_FLAG_TX_*
} sio4_hdlc_tx_frame_t;

typedef struct
{
	// All fields must be filled in before calling sio4_hdlc_init().
	s32			tx_bit_rate;
	s32			rx_bit_rate;
	s32			rx_uses_cbl_rxc;
	s32			osc_prog;
} sio4_hdlc_init_t;

typedef struct
{
	// All fields are filled in by the library when calling
	// sio4_hdlc_init(). Application mods must be made before calling
	// sio4_hdlc_set(). sio4_hdlc_init() will set a field to -1
	// if the feature is unsupported.

	struct
	{
		s32		ref;
		s32		prog;
	} osc;

	struct
	{
		s32		enable;		// PSRCR D31
		s32		mode;		// PSRCR D28, DCE or DTE
		s32		protocol;	// PSRSR D24-D27

		s32		txc;		// PSRCR D6-D8
		s32		txd;		// PSRCR D19-D20
		s32		txaux;		// PSRCR D17-D18
		s32		dcd;		// PSRCR D15-D16
		s32		dtr_dsr;	// PSRCR D21-D22
		s32		rts;		// PSRCR D13-D14

		struct
		{
			s32	mode;		// PSRCR D23, D29
		} loopback;

		struct
		{
			s32	enable;		// PSRCR D30
		} term;

		struct
		{
			s32	txc;		// CCR 0x3333
			s32	txd_cts;	// CSR D2-D3
			s32	rxc;		// CCR 0xCCCC
			s32	rxd_dcd;	// CSR D4-D5
		} legacy;

	} cable;

	struct
	{
		s32		mode;		// USC CMR D8-D11
		s32		enable;		// USC TMR D0-D1
		s32		char_len;	// USC TMR D2-D4
		s32		encoding;	// USC TMR D13-D15
		s32		bit_rate;	// reflects sio4_hdlc_init_t.tx_bit_rate
		s32		idle_cond;	// USC TCSR D8-D10
		s32		share_0;	// USC CMR D12
		s32		underrun;	// USC CMR D14-D15
		s32		wait_underrun;	// USC TCSR D11

		struct
		{
			s32	enable;		// USC TMR D9
			s32	type;		// USC TMR D11-D12
			s32	preset;		// USC TMR D10
			s32	on_end;		// USC TMR D8
		} crc;

		struct
		{
			s32	enable;		// USC TMR D5
			s32	type;		// USC TMR D6-D7
		} parity;

		struct
		{
			s32	enable;		// USC CMR D13
			s32	flag;		// USC CCR D12
			s32	pattern;	// USC CCR D8-D9
			s32	length;		// USC CCR D10-D11
		} preamble;

		struct
		{
			s32	size;		// FSR D0-D15, read-only
			s32	ae;			// TAR D0-D15
			s32	af;			// TAR D16-D31
			s32	empty_cfg;	// CSR D18, D26
			s32	space_cfg;	// CSR D4-D5
		} fifo;

		struct
		{
			s32	mode;
			s32	pio_thresh;
			s32	timeout;
			s32	overrun;
		} io;

	} tx;

	struct
	{
		s32		mode;		// USC CMR D0-D3
		s32		adrs;		// USC RSR D0-D7
		s32		adrs_ctrl;	// USC CMR D4-D7
		s32		enable;		// USC RMR D0-D1
		s32		char_len;	// USC RMR D2-D4
		s32		encoding;	// USC RMR D13-D15
		s32		bit_rate;	// reflects sio4_hdlc_init_t.rx_bit_rate
		s32		queue_abort;// USC RMR D8
		s32		sync_byte;	// SBR D0-D7
		s32		status_word;// CSR D3

		struct
		{
			s32	enable;		// USC RMR D9
			s32	type;		// USC RMR D11-D12
			s32	preset;		// USC RMR D10
		} crc;

		struct
		{
			s32	enable;		// USC RMR D5
			s32	type;		// USC RMR D6-D7
		} parity;

		struct
		{
			s32	size;		// FSR D16-D21, read-only
			s32	ae;			// RAR D0-D15
			s32	af;			// RAR D16-D31
			s32	full_cfg;	// BCR D8
		} fifo;

		struct
		{
			s32	mode;
			s32	pio_thresh;
			s32	timeout;
			s32	overrun;
			s32	underrun;
		} io;

		struct
		{
			s32	enable;		// CSR D2
			s32	clk_src;	// BCR D22
		} time_stamp;

	} rx;

	struct
	{
		s32		mode;		// USC CCAR D8-D9
		s32		txd;		// USC IOCR D6-D7
		s32		cts;		// PSRCR D9-D10, USC IOCR D14-D15
		s32		cts_legacy;	// USC IOCR D14-D15
		s32		dcd;		// PSRCR D11-D12, USC IOCR D12-D13
		s32		dcd_legacy;	// USC IOCR D12-D13

		// All of the folling USC fields are initialized
		// by sio4_hdlc_init() based on the content of the
		// sio4_hdlc_init_t structure.

		struct
		{
			s32	clk_src;	// USC CMCR D3-D5
			s32	txc;		// PSRCR D0-D2, USC IOCR D3-D5
			s32	txc_legacy;	// USC IOCR D3-D5
		} tx;

		struct
		{
			s32	clk_src;	// USC CMCR D0-D2
			s32	rxc;		// PSRCR D3-D5, USC IOCR D0-D2
			s32	rxc_legacy;	// USC IOCR D0-D2
		} rx;

		struct
		{
			s32	enable;		// USC HCR D0
			s32	clk_src;	// USC CMCR D8-D9
			s32	divider;	// USC TC1R D0-D15
			s32	mode;		// USC HCR D1
		} brg0;

		struct
		{
			s32	enable;		// USC HCR D4
			s32	clk_src;	// USC CMCR D10-D11
			s32	divider;	// USC TC0R D0-D15
			s32	mode;		// USC HCR D5
		} brg1;

		struct
		{
			s32	clk_src;	// USC CMCR D12-D13
			s32	rate;		// USC HCR D14-D15
		} ctr0;

		struct
		{
			s32	clk_src;	// USC CMCR D14-D15
			s32	rate_src;	// USC HCR D13, ...
		} ctr1;

		struct
		{
			s32	clk_src;	// USC CMCR D6-D7
			s32	mode;		// USC HCR D8-D9
			s32	rate;		// USC HCR D10-D11
			s32	edge;		// USC CCSR D8-D9
		} dpll;

	} usc;

} sio4_hdlc_t;



// prototypes *****************************************************************

// High level functions.

int		sio4_hdlc_lib_init(void);									// returns 0 or -errno
int		sio4_hdlc_version(const char** version, const char** built);// returns 0 or -errno

int		sio4_hdlc_open(int index);									// returns >= 0 or -errno
int		sio4_hdlc_close(int fd);									// returns 0 or -errno
int		sio4_hdlc_ioctl(int fd, int cmd, void* arg);				// returns 0 or -errno

int		sio4_hdlc_init(int fd, const sio4_hdlc_init_t* init, sio4_hdlc_t* hdlc, const char** err);	// returns 0 or -errno
int		sio4_hdlc_get(int fd, sio4_hdlc_t* hdlc, const char** err);									// returns 0 or -errno
int		sio4_hdlc_set(int fd, const sio4_hdlc_t* hdlc, const char** err);							// returns 0 or -errno
int		sio4_hdlc_show(int fd, const sio4_hdlc_t* hdlc, const char** err);							// returns 0 or -errno

int		sio4_hdlc_rx_frame(int fd, sio4_hdlc_rx_frame_t* rx);		// returns 0 or -errno
int		sio4_hdlc_rx_flush(int fd);									// returns 0 or -errno

int		sio4_hdlc_tx_abort(int fd, int timeout);					// returns 0 or -errno
int		sio4_hdlc_tx_flush(int fd, int timeout);					// returns 0 or -errno
int		sio4_hdlc_tx_frame(int fd, sio4_hdlc_tx_frame_t* tx);		// returns 0 or -errno
int		sio4_hdlc_tx_wait(int fd, int timeout, int* done);			// returns 0 or -errno

// Low level functions.

void	sio4_hdlc_t_cable_dcd				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_dtr_dsr			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_enable			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_legacy_rxc		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_legacy_rxd_dcd	(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_legacy_txc		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_legacy_txd_cts	(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_loopback_mode		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_mode				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_protocol			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_rts				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_term_enable		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_txaux				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_txc				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_cable_txd				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);

void	sio4_hdlc_t_osc_prog				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_osc_ref					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);

void	sio4_hdlc_t_rx_adrs					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_adrs_ctrl			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_bit_rate				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_char_len				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_crc_enable			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_crc_preset			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_crc_type				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_enable				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_encoding				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_fifo_ae				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_fifo_af				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_fifo_full_cfg		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_fifo_size			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_io_mode				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_io_overrun			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_io_pio_thresh		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_io_timeout			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_io_underrun			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_mode					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_parity_enable		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_parity_type			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_queue_abort			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_status_word			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_sync_byte			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_time_stamp_clk_src	(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_rx_time_stamp_enable	(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);

void	sio4_hdlc_t_tx_bit_rate				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_char_len				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_crc_enable			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_crc_on_end			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_crc_preset			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_crc_type				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_enable				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_encoding				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_fifo_ae				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_fifo_af				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_fifo_empty_cfg		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_fifo_size			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_fifo_space_cfg		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_idle_cond			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_io_mode				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_io_overrun			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_io_pio_thresh		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_io_timeout			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_mode					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_parity_enable		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_parity_type			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_preamble_enable		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_preamble_flag		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_preamble_length		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_preamble_pattern		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_share_0				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_underrun				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_tx_wait_underrun		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);

void	sio4_hdlc_t_usc_brg0_clk_src		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg0_divider		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg0_enable			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg0_mode			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg1_clk_src		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg1_divider		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg1_enable			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_brg1_mode			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_ctr0_clk_src		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_ctr0_rate			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_ctr1_clk_src		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_ctr1_rate_src		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_cts					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_cts_legacy			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_dcd					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_dcd_legacy			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_dpll_clk_src		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_dpll_edge			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_dpll_mode			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_dpll_rate			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_mode				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_rx_clk_src			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_rx_rxc				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_rx_rxc_legacy		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_tx_clk_src			(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_tx_txc				(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_tx_txc_legacy		(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);
void	sio4_hdlc_t_usc_txd					(int fd, s32* arg, sio4_hdlc_action_t action, const char** err);



#endif
