// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/utils/sio4_async_utils.h $
// $Rev: 31502 $
// $Date: 2014-12-09 18:31:48 -0600 (Tue, 09 Dec 2014) $

#ifndef __SIO4_ASYNC_UTILS_H__
#define __SIO4_ASYNC_UTILS_H__

#include "sio4_dsl.h"
#include "sio4_utils.h"
#include "sio4_async.h"



// prototypes *****************************************************************

int		async_util_close	(int fd, int index, int verbose);
int		async_util_get		(int fd, int index, int verbose, sio4_async_t* async, const char** err);
int		async_util_init		(int fd, int index, int verbose, const sio4_async_init_t* init, sio4_async_t* async, const char** err);
int		async_util_ioctl	(int fd, int index, int verbose, int cmd, void* arg);
int		async_util_lib_init	(					int verbose);
int		async_util_open		(		 int index, int verbose, int show_index);
int		async_util_read		(int fd, int index, int verbose, void* buf, size_t size);
int		async_util_set		(int fd, int index, int verbose, const sio4_async_t* async, const char** err);
int		async_util_show		(int fd, int index, int verbose, const sio4_async_t* async, const char** err);
void	async_util_version	(					int verbose, const char** version, const char** built);
int		async_util_write	(int fd, int index, int verbose, const void* buf, size_t size);



#endif
