// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/SIO4%20and%20SIO8/SIO4_Linux_2.x.x_GSC_DN/async/lib/sio4_async.h $
// $Rev: 32775 $
// $Date: 2015-09-07 15:34:15 -0500 (Mon, 07 Sep 2015) $

#ifndef __SIO4_ASYNC_H__
#define __SIO4_ASYNC_H__

#include "sio4.h"



// #defines *******************************************************************

//*****************************************************************************
// sio4_async_init_t.rx_bit_rate
// Specified by caller before calling sio4_async_init().

//*****************************************************************************
// sio4_async_init_t.tx_bit_rate
// Specified by caller before calling sio4_async_init().

//*****************************************************************************
// sio4_async_init_t.osc_prog
// Specified by caller before calling sio4_async_init().

//*****************************************************************************
// sio4_async_t.cable.dcd					// PSRCR D15-D16
// sio4_async_t_cable_dcd()
#define SIO4_ASYNC_CABLE_DCD_OUT_USC_DCD	SIO4_Z16_CBL_DCD_CFG_OUT_USC_DCD	// default
#define SIO4_ASYNC_CABLE_DCD_OUT_RTS		SIO4_Z16_CBL_DCD_CFG_OUT_RTS		// Rx FIFO Almost Full
#define SIO4_ASYNC_CABLE_DCD_OUT_0			SIO4_Z16_CBL_DCD_CFG_OUT_0
#define SIO4_ASYNC_CABLE_DCD_OUT_1			SIO4_Z16_CBL_DCD_CFG_OUT_1

//*****************************************************************************
// sio4_async_t.cable.mode					// PSRCR D28, else DCE
// sio4_async_t_cable_mode()
#define SIO4_ASYNC_CABLE_MODE_DTE			SIO4_CBL_MODE_DTE					// default
#define SIO4_ASYNC_CABLE_MODE_DCE			SIO4_CBL_MODE_DCE

//*****************************************************************************
// sio4_async_t.cable.dtr_dsr				// PSRCR D21-D22
// sio4_async_t_cable_dtr_dsr()
#define SIO4_ASYNC_CABLE_DTR_DSR_TRI		SIO4_Z16_CBL_DTR_DSR_CFG_TRI		// default
#define SIO4_ASYNC_CABLE_DTR_DSR_IN			SIO4_Z16_CBL_DTR_DSR_CFG_IN			// DSR
#define SIO4_ASYNC_CABLE_DTR_DSR_OUT_0		SIO4_Z16_CBL_DTR_DSR_CFG_OUT_0
#define SIO4_ASYNC_CABLE_DTR_DSR_OUT_1		SIO4_Z16_CBL_DTR_DSR_CFG_OUT_1

//*****************************************************************************
// sio4_async_t.cable.enable				// PSRCR D31
// sio4_async_t_cable_enable()
#define SIO4_ASYNC_CABLE_ENABLE_NO			SIO4_XCVR_ENABLE_NO
#define SIO4_ASYNC_CABLE_ENABLE_YES			SIO4_XCVR_ENABLE_YES				// default

//*****************************************************************************
// sio4_async_t.cable.legacy.rxc			// CCR D2-D3, D6-D7, D10-D11, D14-D15
// sio4_async_t_cable_legacy_rxc()
#define SIO4_ASYNC_CABLE_LEGACY_RXC_DISABLE	SIO4_Z16_LEG_RXC_DISABLE
#define SIO4_ASYNC_CABLE_LEGACY_RXC_UP		SIO4_Z16_LEG_RXC_UPPER
#define SIO4_ASYNC_CABLE_LEGACY_RXC_LOW		SIO4_Z16_LEG_RXC_LOWER				// default

//*****************************************************************************
// sio4_async_t.cable.legacy.rxd_dcd			// CSR D4-D5
// sio4_async_t_cable_legacy_rxd_dcd()
#define SIO4_ASYNC_CABLE_LEGACY_RXD_DCD_DISABLE	SIO4_Z16_LEG_RXD_DCD_CFG_TRI
#define SIO4_ASYNC_CABLE_LEGACY_RXD_DCD_UP		SIO4_Z16_LEG_RXD_DCD_CFG_UP
#define SIO4_ASYNC_CABLE_LEGACY_RXD_DCD_LOW		SIO4_Z16_LEG_RXD_DCD_CFG_LOW	// default

//*****************************************************************************
// sio4_async_t.cable.legacy.txc			// CCR D0-D1, D4-D5, D8-D9, D12-D13
// sio4_async_t_cable_legacy_txc()
#define SIO4_ASYNC_CABLE_LEGACY_TXC_DISABLE	SIO4_Z16_LEG_TXC_DISABLE
#define SIO4_ASYNC_CABLE_LEGACY_TXC_UP		SIO4_Z16_LEG_TXC_UPPER				// default
#define SIO4_ASYNC_CABLE_LEGACY_TXC_LOW		SIO4_Z16_LEG_TXC_LOWER
#define SIO4_ASYNC_CABLE_LEGACY_TXC_BOTH	SIO4_Z16_LEG_TXC_BOTH

//*****************************************************************************
// sio4_async_t.cable.legacy.txd_cts			// CSR D2-D3
// sio4_async_t_cable_legacy_txd_cts()
#define SIO4_ASYNC_CABLE_LEGACY_TXD_CTS_TRI		SIO4_Z16_LEG_TXD_CTS_CFG_TRI
#define SIO4_ASYNC_CABLE_LEGACY_TXD_CTS_LOW		SIO4_Z16_LEG_TXD_CTS_CFG_LOW
#define SIO4_ASYNC_CABLE_LEGACY_TXD_CTS_UP		SIO4_Z16_LEG_TXD_CTS_CFG_UP		// default
#define SIO4_ASYNC_CABLE_LEGACY_TXD_CTS_BOTH	SIO4_Z16_LEG_TXD_CTS_CFG_UP_LOW

//*****************************************************************************
// sio4_async_t.cable.loopback.mode			// PSRCR D23, D29
// sio4_async_t_cable_loopback_mode()
#define SIO4_ASYNC_LOOPBACK_MODE_DISABLE	SIO4_LOOP_BACK_DISABLE				// default
#define SIO4_ASYNC_LOOPBACK_MODE_INTERNAL	SIO4_LOOP_BACK_INTERNAL
#define SIO4_ASYNC_LOOPBACK_MODE_EXTERNAL	SIO4_LOOP_BACK_EXTERNAL

//*****************************************************************************
// sio4_async_t.cable.protocol					// PSRCR D24-D27
// sio4_async_t_cable_protocol()
#define SIO4_ASYNC_CABLE_PROTOCOL_RS422_RS485	SIO4_XCVR_PROTOCOL_RS422_RS485
#define SIO4_ASYNC_CABLE_PROTOCOL_RS423			SIO4_XCVR_PROTOCOL_RS423
#define SIO4_ASYNC_CABLE_PROTOCOL_RS232			SIO4_XCVR_PROTOCOL_RS232		// default
#define SIO4_ASYNC_CABLE_PROTOCOL_RS530			SIO4_XCVR_PROTOCOL_RS530		// or RS-530 Mode 1
#define SIO4_ASYNC_CABLE_PROTOCOL_RS530A		SIO4_XCVR_PROTOCOL_RS530A		// or RS-530 Mode 2
#define SIO4_ASYNC_CABLE_PROTOCOL_V35			SIO4_XCVR_PROTOCOL_V35			// or V.35 Mode 1
#define SIO4_ASYNC_CABLE_PROTOCOL_V35A			SIO4_XCVR_PROTOCOL_V35A			// or V.35 Mode 2
#define SIO4_ASYNC_CABLE_PROTOCOL_RS422_423_1	SIO4_XCVR_PROTOCOL_RS422_RS423_1// or RS-422/RS-423 Mixed Mode 1
#define SIO4_ASYNC_CABLE_PROTOCOL_RS422_423_2	SIO4_XCVR_PROTOCOL_RS422_RS423_2// or RS-422/RS-423 Mixed Mode 2
#define	SIO4_ASYNC_CABLE_PROTOCOL_DISABLE		SIO4_XCVR_PROTOCOL_DISABLE		// Hi Impediance
#define	SIO4_ASYNC_CABLE_PROTOCOL_UNKNOWN		SIO4_XCVR_PROTOCOL_UNKNOWN

//*****************************************************************************
// sio4_async_t.cable.rts					// PSRCR D13-D14
// sio4_async_t_cable_rts()
#define SIO4_ASYNC_CABLE_RTS_OUT_CTS		SIO4_Z16_CBL_RTS_CFG_OUT_USC_CTS	// from USC
#define SIO4_ASYNC_CABLE_RTS_OUT_RTS		SIO4_Z16_CBL_RTS_CFG_OUT_RTS		// Rx FIFO Almost Full, default
#define SIO4_ASYNC_CABLE_RTS_OUT_0			SIO4_Z16_CBL_RTS_CFG_OUT_0
#define SIO4_ASYNC_CABLE_RTS_OUT_1			SIO4_Z16_CBL_RTS_CFG_OUT_1

//*****************************************************************************
// sio4_async_t.cable.term.enable			// PSRCR D30
// sio4_async_t_cable_term_enable()
#define SIO4_ASYNC_CABLE_TERM_ENABLE_YES	SIO4_XCVR_TERM_ENABLE
#define SIO4_ASYNC_CABLE_TERM_ENABLE_NO		SIO4_XCVR_TERM_DISABLE				// default

//*****************************************************************************
// sio4_async_t.cable.txaux					// PSRCR D17-D18
// sio4_async_t_cable_txaux()
#define SIO4_ASYNC_CABLE_TXAUX_TRI			SIO4_Z16_CBL_TXAUXC_CFG_TRI			// default
#define SIO4_ASYNC_CABLE_TXAUX_OUT_OSC		SIO4_Z16_CBL_TXAUXC_CFG_OUT_OSC
#define SIO4_ASYNC_CABLE_TXAUX_OUT_0		SIO4_Z16_CBL_TXAUXC_CFG_OUT_0
#define SIO4_ASYNC_CABLE_TXAUX_OUT_1		SIO4_Z16_CBL_TXAUXC_CFG_OUT_1

//*****************************************************************************
// sio4_async_t.cable.txc					// PSRCR D6-D8
// sio4_async_t_cable_txc()
#define SIO4_ASYNC_CABLE_TXC_OUT_OSC		SIO4_Z16_CBL_TXC_CFG_OUT_OSC		// default
#define SIO4_ASYNC_CABLE_TXC_OUT_OSC_INV	SIO4_Z16_CBL_TXC_CFG_OUT_OSC_INV
#define SIO4_ASYNC_CABLE_TXC_OUT_0			SIO4_Z16_CBL_TXC_CFG_OUT_0
#define SIO4_ASYNC_CABLE_TXC_OUT_1			SIO4_Z16_CBL_TXC_CFG_OUT_1
#define SIO4_ASYNC_CABLE_TXC_OUT_USC_TXC	SIO4_Z16_CBL_TXC_CFG_OUT_USC_TXC
#define SIO4_ASYNC_CABLE_TXC_OUT_USC_RXC	SIO4_Z16_CBL_TXC_CFG_OUT_USC_RXC
#define SIO4_ASYNC_CABLE_TXC_OUT_CBL_RXC	SIO4_Z16_CBL_TXC_CFG_OUT_CBL_RXC
#define SIO4_ASYNC_CABLE_TXC_OUT_CBL_RXA	SIO4_Z16_CBL_TXC_CFG_OUT_CBL_RXA

//*****************************************************************************
// sio4_async_t.cable.txd					// PSRCR D19-D20
// sio4_async_t_cable_txd()
#define SIO4_ASYNC_CABLE_TXD_OUT_USC_TXD	SIO4_Z16_CBL_TXD_CFG_OUT_USC_TXD	// default
#define SIO4_ASYNC_CABLE_TXD_OUT_0			SIO4_Z16_CBL_TXD_CFG_OUT_0
#define SIO4_ASYNC_CABLE_TXD_OUT_1			SIO4_Z16_CBL_TXD_CFG_OUT_1

//*****************************************************************************
// sio4_async_t.osc.prog
// sio4_async_t_osc_prog()
// The default is the value taken from sio4_async_init_t.osc_prog.

//*****************************************************************************
// sio4_async_t.osc.ref
// sio4_async_t_osc_ref()
// Any value supported by the current oscillator. The default is 20M.

//*****************************************************************************
// sio4_async_t.rx.bit_rate
// sio4_async_t_rx_bit_rate()
// The default is the value taken from sio4_async_init_t.rx_bit_rate.

//*****************************************************************************
// sio4_async_t.rx.char_len					// USC RMR D2-D4
// sio4_async_t_rx_char_len()
#define SIO4_ASYNC_RX_CHAR_LEN_1			SIO4_USC_CHAR_LEN_1
#define SIO4_ASYNC_RX_CHAR_LEN_2			SIO4_USC_CHAR_LEN_2
#define SIO4_ASYNC_RX_CHAR_LEN_3			SIO4_USC_CHAR_LEN_3
#define SIO4_ASYNC_RX_CHAR_LEN_4			SIO4_USC_CHAR_LEN_4
#define SIO4_ASYNC_RX_CHAR_LEN_5			SIO4_USC_CHAR_LEN_5
#define SIO4_ASYNC_RX_CHAR_LEN_6			SIO4_USC_CHAR_LEN_6
#define SIO4_ASYNC_RX_CHAR_LEN_7			SIO4_USC_CHAR_LEN_7
#define SIO4_ASYNC_RX_CHAR_LEN_8			SIO4_USC_CHAR_LEN_8					// default

//*****************************************************************************
// sio4_async_t.rx.enable					// USC RMR D0-D1
// sio4_async_t_rx_enable()
#define SIO4_ASYNC_RX_ENABLE_NO_NOW			SIO4_USC_ENABLE_NO_NOW
#define SIO4_ASYNC_RX_ENABLE_NO_AFTER		SIO4_USC_ENABLE_NO_AFTER
#define SIO4_ASYNC_RX_ENABLE_YES_NOW		SIO4_USC_ENABLE_YES_NOW				// default
#define SIO4_ASYNC_RX_ENABLE_YES_W_AE		SIO4_USC_ENABLE_YES_W_AE

//*****************************************************************************
// sio4_async_t.rx.encoding					// USC RMR D13-D15
// sio4_async_t_rx_encoding()
#define SIO4_ASYNC_RX_ENCODING_NRZ			SIO4_USC_DATA_ENCODE_NRZ			// default
#define SIO4_ASYNC_RX_ENCODING_NRZB			SIO4_USC_DATA_ENCODE_NRZB
#define SIO4_ASYNC_RX_ENCODING_NRZI_MARK	SIO4_USC_DATA_ENCODE_NRZI_MARK		// FM1
#define SIO4_ASYNC_RX_ENCODING_NRZI_SPACE	SIO4_USC_DATA_ENCODE_NRZI_SPACE		// FM0
#define SIO4_ASYNC_RX_ENCODING_BI_MARK		SIO4_USC_DATA_ENCODE_BI_MARK
#define SIO4_ASYNC_RX_ENCODING_BI_SPACE		SIO4_USC_DATA_ENCODE_BI_SPACE
#define SIO4_ASYNC_RX_ENCODING_BI_LEVEL		SIO4_USC_DATA_ENCODE_BI_LEVEL		// Manchester
#define SIO4_ASYNC_RX_ENCODING_D_BI_LEVEL	SIO4_USC_DATA_ENCODE_D_BI_LEVEL

//*****************************************************************************
// sio4_async_t.rx.fifo.ae					// RAR D0-D15
// sio4_async_t_rx_fifo_ae()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_async_t.rx.fifo.af					// RAR D16-D31
// sio4_async_t_rx_fifo_af()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_async_t.rx.fifo.full_cfg			// CSR D19
// sio4_async_t_rx_fifo_full_cfg			// CSR D19
#define SIO4_ASYNC_RX_FIFO_FULL_CFG_OVER	SIO4_RX_FIFO_FULL_CFG_OVER			// default
#define SIO4_ASYNC_RX_FIFO_FULL_CFG_DISABLE	SIO4_RX_FIFO_FULL_CFG_DISABLE

//*****************************************************************************
// sio4_async_t.rx.fifo.size				// FSR D16-D21, read-only
// sio4_async_t_rx_fifo_size()
// This field is filled in by sio4_async_init().

//*****************************************************************************
// sio4_async_t.rx.io.mode
// sio4_async_t_rx_io_mode()
#define SIO4_ASYNC_RX_IO_MODE_PIO			GSC_IO_MODE_PIO						// default
#define SIO4_ASYNC_RX_IO_MODE_DMA			GSC_IO_MODE_DMA
#define SIO4_ASYNC_RX_IO_MODE_DMDMA			GSC_IO_MODE_DMDMA

//*****************************************************************************
// sio4_async_t.rx.io.overrun
// sio4_async_t_rx_io_overrun()
#define	SIO4_ASYNC_RX_IO_OVERRUN_IGNORE		SIO4_IO_OVERRUN_IGNORE
#define	SIO4_ASYNC_RX_IO_OVERRUN_CHECK		SIO4_IO_OVERRUN_CHECK				// default

//*****************************************************************************
// sio4_async_t.rx.io.pio_thresh
// sio4_async_t_rx_io_pio_thresh()
// Any non-negative value. The default is 64.

//*****************************************************************************
// sio4_async_t.rx.io.timeout
// sio4_async_t_rx_io_timeout()
#define SIO4_ASYNC_RX_IO_TIMEOUT_DEFAULT	SIO4_IO_TIMEOUT_DEFAULT				// default
#define SIO4_ASYNC_RX_IO_TIMEOUT_NO_SLEEP	SIO4_IO_TIMEOUT_NO_SLEEP			// PIO only
#define SIO4_ASYNC_RX_IO_TIMEOUT_MIN		SIO4_IO_TIMEOUT_MIN
#define SIO4_ASYNC_RX_IO_TIMEOUT_MAX		SIO4_IO_TIMEOUT_MAX

//*****************************************************************************
// sio4_async_t.rx.io.underrun
// sio4_async_t_rx_io_underrun()
#define	SIO4_ASYNC_RX_IO_UNDERRUN_IGNORE	SIO4_IO_UNDERRUN_IGNORE
#define	SIO4_ASYNC_RX_IO_UNDERRUN_CHECK		SIO4_IO_UNDERRUN_CHECK				// default

//*****************************************************************************
// sio4_async_t.rx.mode						// USC CMR D0-D3
// sio4_async_t_rx_mode()
#define SIO4_ASYNC_RX_MODE_ASYNC			SIO4_USC_MODE_ASYNC					// Required!

//*****************************************************************************
// sio4_async_t.rx.parity.enable			// USC RMR D5
// sio4_async_t_rx_parity_enable()
#define SIO4_ASYNC_RX_PARITY_ENABLE_NO		SIO4_USC_PAR_ENABLE_NO				// default
#define SIO4_ASYNC_RX_PARITY_ENABLE_YES		SIO4_USC_PAR_ENABLE_YES

//*****************************************************************************
// sio4_async_t.rx.parity.type				// USC RMR D6-D7
// sio4_async_t_rx_parity_type()
#define SIO4_ASYNC_RX_PARITY_TYPE_EVEN		SIO4_USC_PAR_TYPE_EVEN				// default
#define SIO4_ASYNC_RX_PARITY_TYPE_ODD		SIO4_USC_PAR_TYPE_ODD
#define SIO4_ASYNC_RX_PARITY_TYPE_ZERO		SIO4_USC_PAR_TYPE_ZERO
#define SIO4_ASYNC_RX_PARITY_TYPE_ONE		SIO4_USC_PAR_TYPE_ONE

//*****************************************************************************
// sio4_async_t.rx.status_word				// CSR D3
// sio4_async_t_rx_status_word()
#define SIO4_ASYNC_RX_STATUS_WORD_DISABLE	SIO4_Z16_RX_STS_WRD_ENABLE_NO		// default
#define SIO4_ASYNC_RX_STATUS_WORD_ENABLE	SIO4_Z16_RX_STS_WRD_ENABLE_YES

//*****************************************************************************
// sio4_async_t.rx.sync_byte				// SBR D0-D7
// sio4_async_t_rx_sync_byte()
// Any value from 0x00 to 0xFF. The default is zero.

//*****************************************************************************
// sio4_async_t.rx.time_stamp.enable		// CSR D2
// sio4_async_t_rx_time_stamp_enable()
#define SIO4_ASYNC_RX_TIME_STAMP_ENABLE_NO	SIO4_TIME_STAMP_ENABLE_NO			// default
#define SIO4_ASYNC_RX_TIME_STAMP_ENABLE_YES	SIO4_TIME_STAMP_ENABLE_YES

//*****************************************************************************
// sio4_async_t.rx.time_stamp.clk_src			// BCR D22
// sio4_async_t_rx_time_stamp_clk_src()
#define SIO4_ASYNC_RX_TIME_STAMP_CLK_SRC_INT	SIO4_TIME_STAMP_SRC_INT			// default
#define SIO4_ASYNC_RX_TIME_STAMP_CLK_SRC_EXT	SIO4_TIME_STAMP_SRC_EXT

//*****************************************************************************
// sio4_async_t.tx.bit_rate
// sio4_async_t_tx_bit_rate()
// The default is the value taken from sio4_async_init_t.tx_bit_rate.

//*****************************************************************************
// sio4_async_t.tx.char_len					// USC TMR D2-D4
// sio4_async_t_tx_char_len()
#define SIO4_ASYNC_TX_CHAR_LEN_1			SIO4_USC_CHAR_LEN_1
#define SIO4_ASYNC_TX_CHAR_LEN_2			SIO4_USC_CHAR_LEN_2
#define SIO4_ASYNC_TX_CHAR_LEN_3			SIO4_USC_CHAR_LEN_3
#define SIO4_ASYNC_TX_CHAR_LEN_4			SIO4_USC_CHAR_LEN_4
#define SIO4_ASYNC_TX_CHAR_LEN_5			SIO4_USC_CHAR_LEN_5
#define SIO4_ASYNC_TX_CHAR_LEN_6			SIO4_USC_CHAR_LEN_6
#define SIO4_ASYNC_TX_CHAR_LEN_7			SIO4_USC_CHAR_LEN_7
#define SIO4_ASYNC_TX_CHAR_LEN_8			SIO4_USC_CHAR_LEN_8					// default

//*****************************************************************************
// sio4_async_t.tx.enable					// USC TMR D0-D1
// sio4_async_t_tx_enable()
#define SIO4_ASYNC_TX_ENABLE_NO_NOW			SIO4_USC_ENABLE_NO_NOW
#define SIO4_ASYNC_TX_ENABLE_NO_AFTER		SIO4_USC_ENABLE_NO_AFTER
#define SIO4_ASYNC_TX_ENABLE_YES_NOW		SIO4_USC_ENABLE_YES_NOW				// default
#define SIO4_ASYNC_TX_ENABLE_YES_W_AE		SIO4_USC_ENABLE_YES_W_AE

//*****************************************************************************
// sio4_async_t.tx.encoding					// USC TMR D13-D15
// sio4_async_t_tx_encoding()
#define SIO4_ASYNC_TX_ENCODING_NRZ			SIO4_USC_DATA_ENCODE_NRZ			// default
#define SIO4_ASYNC_TX_ENCODING_NRZB			SIO4_USC_DATA_ENCODE_NRZB
#define SIO4_ASYNC_TX_ENCODING_NRZI_MARK	SIO4_USC_DATA_ENCODE_NRZI_MARK		// FM1
#define SIO4_ASYNC_TX_ENCODING_NRZI_SPACE	SIO4_USC_DATA_ENCODE_NRZI_SPACE		// FM0
#define SIO4_ASYNC_TX_ENCODING_BI_MARK		SIO4_USC_DATA_ENCODE_BI_MARK
#define SIO4_ASYNC_TX_ENCODING_BI_SPACE		SIO4_USC_DATA_ENCODE_BI_SPACE
#define SIO4_ASYNC_TX_ENCODING_BI_LEVEL		SIO4_USC_DATA_ENCODE_BI_LEVEL		// Manchester
#define SIO4_ASYNC_TX_ENCODING_D_BI_LEVEL	SIO4_USC_DATA_ENCODE_D_BI_LEVEL

//*****************************************************************************
// sio4_async_t.tx.fifo.ae					// TAR D0-D15
// sio4_async_t_tx_fifo_ae()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_async_t.tx.fifo.af					// TAR D16-D31
// sio4_async_t_tx_fifo_af()
// Values from 0x0000 to 0xFFFF. The default is 0x7.

//*****************************************************************************
// sio4_async_t.tx.fifo.empty_cfg			// CSR D18, D26
// sio4_async_t_tx_fifo_empty_cfg()
#define SIO4_ASYNC_TX_FIFO_EMPTY_CFG_IGNORE	SIO4_TX_FIFO_EMPTY_CFG_IGNORE		// do nothing, default
#define SIO4_ASYNC_TX_FIFO_EMPTY_CFG_TX_OFF	SIO4_TX_FIFO_EMPTY_CFG_TX_OFF		// Disable Transmitter

//*****************************************************************************
// sio4_async_t.tx.fifo.size				// FSR D0-D15, read-only
// sio4_async_t_tx_fifo_size()
// This field is filled in by the sio4_async_init().

//*****************************************************************************
// sio4_async_t.tx.fifo.space_cfg			// CSR D4-D5
// sio4_async_t_tx_fifo_space_cfg()
#define SIO4_ASYNC_TX_FIFO_SPACE_CFG_RX_2X	SIO4_FIFO_SPACE_CFG_RX_2X			// Rx has 2x, Tx has x, default
#define SIO4_ASYNC_TX_FIFO_SPACE_CFG_TX_2X	SIO4_FIFO_SPACE_CFG_TX_2X			// Tx has 2x, Rx has x

//*****************************************************************************
// sio4_async_t.tx.idle_cond				// USC TCSR D8-D10
// sio4_async_t_tx_idle_cond()
#define SIO4_ASYNC_TX_IDLE_COND_DEFAULT		SIO4_USC_TX_IDLE_COND_DEFAULT		// default
#define SIO4_ASYNC_TX_IDLE_COND_0_1			SIO4_USC_TX_IDLE_COND_0_1
#define SIO4_ASYNC_TX_IDLE_COND_0			SIO4_USC_TX_IDLE_COND_0
#define SIO4_ASYNC_TX_IDLE_COND_1			SIO4_USC_TX_IDLE_COND_1
#define SIO4_ASYNC_TX_IDLE_COND_MARK_SPACE	SIO4_USC_TX_IDLE_COND_MARK_SPACE
#define SIO4_ASYNC_TX_IDLE_COND_SPACE		SIO4_USC_TX_IDLE_COND_SPACE
#define SIO4_ASYNC_TX_IDLE_COND_MARK		SIO4_USC_TX_IDLE_COND_MARK

//*****************************************************************************
// sio4_async_t.tx.io.mode
// sio4_async_t_tx_io_mode()
#define SIO4_ASYNC_TX_IO_MODE_PIO			GSC_IO_MODE_PIO						// default
#define SIO4_ASYNC_TX_IO_MODE_DMA			GSC_IO_MODE_DMA
#define SIO4_ASYNC_TX_IO_MODE_DMDMA			GSC_IO_MODE_DMDMA

//*****************************************************************************
// sio4_async_t.tx.io.overrun
// sio4_async_t_tx_io_overrun()
#define	SIO4_ASYNC_TX_IO_OVERRUN_IGNORE		SIO4_IO_OVERRUN_IGNORE
#define	SIO4_ASYNC_TX_IO_OVERRUN_CHECK		SIO4_IO_OVERRUN_CHECK				// default

//*****************************************************************************
// sio4_async_t.tx.io.pio_thresh
// sio4_async_t_tx_io_pio_thresh()
// Any non-negative value. The default is 64.

//*****************************************************************************
// sio4_async_t.tx.io.timeout
// sio4_async_t_tx_io_timeout()
#define SIO4_ASYNC_TX_IO_TIMEOUT_DEFAULT	SIO4_IO_TIMEOUT_DEFAULT				// default
#define SIO4_ASYNC_TX_IO_TIMEOUT_NO_SLEEP	SIO4_IO_TIMEOUT_NO_SLEEP			// PIO only
#define SIO4_ASYNC_TX_IO_TIMEOUT_MIN		SIO4_IO_TIMEOUT_MIN
#define SIO4_ASYNC_TX_IO_TIMEOUT_MAX		SIO4_IO_TIMEOUT_MAX

//*****************************************************************************
// sio4_async_t.tx.mode						// USC CMR D8-D11
// sio4_async_t_tx_mode()
#define SIO4_ASYNC_TX_MODE_ASYNC			SIO4_USC_MODE_ASYNC					// Required!

//*****************************************************************************
// sio4_async_t.tx.parity.enable			// USC TMR D5
// sio4_async_t_tx_parity_enable()
#define SIO4_ASYNC_TX_PARITY_ENABLE_NO		SIO4_USC_PAR_ENABLE_NO				// default
#define SIO4_ASYNC_TX_PARITY_ENABLE_YES		SIO4_USC_PAR_ENABLE_YES

//*****************************************************************************
// sio4_async_t.tx.parity.type				// USC TMR D6-D7
// sio4_async_t_tx_parity_type()
#define SIO4_ASYNC_TX_PARITY_TYPE_EVEN		SIO4_USC_PAR_TYPE_EVEN				// default
#define SIO4_ASYNC_TX_PARITY_TYPE_ODD		SIO4_USC_PAR_TYPE_ODD
#define SIO4_ASYNC_TX_PARITY_TYPE_ZERO		SIO4_USC_PAR_TYPE_ZERO
#define SIO4_ASYNC_TX_PARITY_TYPE_ONE		SIO4_USC_PAR_TYPE_ONE

//*****************************************************************************
// sio4_async_t.usc.brg0.clk_src			// USC CMCR D8-D9
// sio4_async_t_usc_brg0_clk_src()
#define SIO4_ASYNC_USC_BRG0_CLK_SRC_CTR0	SIO4_USC_BRG_CLK_SRC_CTR0			// default
#define SIO4_ASYNC_USC_BRG0_CLK_SRC_CTR1	SIO4_USC_BRG_CLK_SRC_CTR1
#define SIO4_ASYNC_USC_BRG0_CLK_SRC_RXC_PIN	SIO4_USC_BRG_CLK_SRC_RXC_PIN
#define SIO4_ASYNC_USC_BRG0_CLK_SRC_TXC_PIN	SIO4_USC_BRG_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_async_t.usc.brg0.divider			// USC TC0R D0-D15
// sio4_async_t_usc_brg0_divider()
// Any value from 0x0000 to 0xFFFF. The default is zero.

//*****************************************************************************
// sio4_async_t.usc.brg0.enable				// USC HCR D0
// sio4_async_t_usc_brg0_enable()
#define SIO4_ASYNC_USC_BRG0_ENABLE_NO		SIO4_USC_BRG_ENABLE_NO				// default
#define SIO4_ASYNC_USC_BRG0_ENABLE_YES		SIO4_USC_BRG_ENABLE_YES

//*****************************************************************************
// sio4_async_t.usc.brg0.mode				// USC HCR D1
// sio4_async_t_usc_brg0_mode()
#define SIO4_ASYNC_USC_BRG0_MODE_CONT		SIO4_USC_BRG_MODE_CONT				// default
#define SIO4_ASYNC_USC_BRG0_MODE_SINGLE		SIO4_USC_BRG_MODE_SINGLE

//*****************************************************************************
// sio4_async_t.usc.brg1.clk_src			// USC CMCR D10-D11
// sio4_async_t_usc_brg1_clk_src()
#define SIO4_ASYNC_USC_BRG1_CLK_SRC_CTR0	SIO4_USC_BRG_CLK_SRC_CTR0
#define SIO4_ASYNC_USC_BRG1_CLK_SRC_CTR1	SIO4_USC_BRG_CLK_SRC_CTR1			// default
#define SIO4_ASYNC_USC_BRG1_CLK_SRC_RXC_PIN	SIO4_USC_BRG_CLK_SRC_RXC_PIN
#define SIO4_ASYNC_USC_BRG1_CLK_SRC_TXC_PIN	SIO4_USC_BRG_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_async_t.usc.brg1.divider			// USC TC1R D0-D15
// sio4_async_t_usc_brg1_divider()
// Any value from 0x0000 to 0xFFFF. The default is zero.

//*****************************************************************************
// sio4_async_t.usc.brg1.enable				// USC HCR D4
// sio4_async_t_usc_brg1_enable()
#define SIO4_ASYNC_USC_BRG1_ENABLE_NO		SIO4_USC_BRG_ENABLE_NO				// default
#define SIO4_ASYNC_USC_BRG1_ENABLE_YES		SIO4_USC_BRG_ENABLE_YES

//*****************************************************************************
// sio4_async_t.usc.brg1.mode				// USC HCR D5
// sio4_async_t_usc_brg1_mode()
#define SIO4_ASYNC_USC_BRG1_MODE_CONT		SIO4_USC_BRG_MODE_CONT				// disable
#define SIO4_ASYNC_USC_BRG1_MODE_SINGLE		SIO4_USC_BRG_MODE_SINGLE

//*****************************************************************************
// sio4_async_t.usc.ctr0.clk_src			// USC CMCR D12-D13
// sio4_async_t_usc_ctr0_clk_src()
#define SIO4_ASYNC_USC_CTR0_CLK_SRC_DISABLE	SIO4_USC_CTR_CLK_SRC_DISABLE		// default
#define SIO4_ASYNC_USC_CTR0_CLK_SRC_RXC_PIN	SIO4_USC_CTR_CLK_SRC_RXC_PIN
#define SIO4_ASYNC_USC_CTR0_CLK_SRC_TXC_PIN	SIO4_USC_CTR_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_async_t.usc.ctr0.rate				// USC HCR D14-D15
// sio4_async_t_usc_ctr0_rate()
#define SIO4_ASYNC_USC_CTR0_RATE_32X		SIO4_USC_CTR0_RATE_32X				// default
#define SIO4_ASYNC_USC_CTR0_RATE_16X		SIO4_USC_CTR0_RATE_16X
#define SIO4_ASYNC_USC_CTR0_RATE_8X			SIO4_USC_CTR0_RATE_8X
#define SIO4_ASYNC_USC_CTR0_RATE_4X			SIO4_USC_CTR0_RATE_4X

//*****************************************************************************
// sio4_async_t.usc.ctr1.clk_src			// USC CMCR D14-D15
// sio4_async_t_usc_ctr1_clk_src()
#define SIO4_ASYNC_USC_CTR1_CLK_SRC_DISABLE	SIO4_USC_CTR_CLK_SRC_DISABLE		// default
#define SIO4_ASYNC_USC_CTR1_CLK_SRC_RXC_PIN	SIO4_USC_CTR_CLK_SRC_RXC_PIN
#define SIO4_ASYNC_USC_CTR1_CLK_SRC_TXC_PIN	SIO4_USC_CTR_CLK_SRC_TXC_PIN

//*****************************************************************************
// sio4_async_t.usc.ctr1.rate_src			// USC HCR D13
// sio4_async_t_usc_ctr1_rate_src()
#define SIO4_ASYNC_USC_CTR1_RATE_SRC_CTR0	SIO4_USC_CTR1_RATE_CTR0				// default
#define SIO4_ASYNC_USC_CTR1_RATE_SRC_DPLL	SIO4_USC_CTR1_RATE_DPLL

//*****************************************************************************
// sio4_async_t.usc.cts						// PSRCR D9-D10, USC IOCR D14-D15
// sio4_async_t_usc_cts()
#define SIO4_ASYNC_USC_CTS_TRI				SIO4_USC_CTS_CFG_TRI				// default
#define SIO4_ASYNC_USC_CTS_IN_CBL_CTS		SIO4_USC_CTS_CFG_IN_CBL_CTS
#define SIO4_ASYNC_USC_CTS_OUT_0			SIO4_USC_CTS_CFG_OUT_0				// lower nibble: PSRCR D9-D10
#define SIO4_ASYNC_USC_CTS_OUT_1			SIO4_USC_CTS_CFG_OUT_1				// upper nibble: USC IOCR D14-D15

//*****************************************************************************
// sio4_async_t.usc.cts_legacy				USC IOCR D14-D15
// sio4_async_t_usc_cts_legacy()
#define SIO4_ASYNC_USC_CTS_LEG_IN			SIO4_USC_CTS_LEG_IN
#define SIO4_ASYNC_USC_CTS_LEG_OUT_0		SIO4_USC_CTS_LEG_OUT_0				// default
#define SIO4_ASYNC_USC_CTS_LEG_OUT_1		SIO4_USC_CTS_LEG_OUT_1

//*****************************************************************************
// sio4_async_t.usc.dcd						// PSRCR D11-D12, USC IOCR D12-D13
// sio4_async_t_usc_dcd()
#define SIO4_ASYNC_USC_DCD_DISABLE			SIO4_USC_DCD_CFG_DISABLE			// default
#define SIO4_ASYNC_USC_DCD_IN_DCD_CBL_DCD	SIO4_USC_DCD_CFG_IN_DCD_CBL_DCD
#define SIO4_ASYNC_USC_DCD_IN_SYNC_CBL_DCD	SIO4_USC_DCD_CFG_IN_SYNC_CBL_DCD
#define SIO4_ASYNC_USC_DCD_OUT_0			SIO4_USC_DCD_CFG_OUT_0				// lower nibble: PSRCR D11-D12
#define SIO4_ASYNC_USC_DCD_OUT_1			SIO4_USC_DCD_CFG_OUT_1				// upper nibble: USC IOCR D12-D13

//*****************************************************************************
// sio4_async_t.usc.dcd_legacy				USC IOCR D12-D13
// sio4_async_t_usc_dcd_legacy()
#define SIO4_ASYNC_USC_DCD_LEG_IN_DCD		SIO4_USC_DCD_LEG_IN_DCD
#define SIO4_ASYNC_USC_DCD_LEG_IN_SYNC		SIO4_USC_DCD_LEG_IN_SYNC
#define SIO4_ASYNC_USC_DCD_LEG_OUT_0		SIO4_USC_DCD_LEG_OUT_0				// default
#define SIO4_ASYNC_USC_DCD_LEG_OUT_1		SIO4_USC_DCD_LEG_OUT_1

//*****************************************************************************
// sio4_async_t.usc.dpll.rate				USC HCR D10-D11
// sio4_async_t_usc_dpll_rate()
#define SIO4_ASYNC_USC_DPLL_RATE_32X		SIO4_USC_DPLL_RATE_32X				// default
#define SIO4_ASYNC_USC_DPLL_RATE_16X		SIO4_USC_DPLL_RATE_16X
#define SIO4_ASYNC_USC_DPLL_RATE_8X			SIO4_USC_DPLL_RATE_8X
#define SIO4_ASYNC_USC_DPLL_RATE_4X			SIO4_USC_DPLL_RATE_CTR1_4X

//*****************************************************************************
// sio4_async_t.usc.mode					// USC CCAR D8-D9
// sio4_async_t_usc_mode()
#define SIO4_ASYNC_USC_MODE_NORMAL			SIO4_USC_OPER_MODE_NORMAL			// default
#define SIO4_ASYNC_USC_MODE_AUTO_ECHO		SIO4_USC_OPER_MODE_AUTO_ECHO
#define SIO4_ASYNC_USC_MODE_LOOPBACK_EXT	SIO4_USC_OPER_MODE_EXT_LOOPBACK
#define SIO4_ASYNC_USC_MODE_LOOPBACK_INT	SIO4_USC_OPER_MODE_INT_LOOPBACK

//*****************************************************************************
// sio4_async_t.usc.rx.clk_rate				// USC CMR D4-D5
// sio4_async_t_usc_rx_clk_rate()
#define SIO4_ASYNC_USC_RX_CLK_RATE_16X		SIO4_USC_ASYNC_CLK_RATE_16X
#define SIO4_ASYNC_USC_RX_CLK_RATE_32X		SIO4_USC_ASYNC_CLK_RATE_32X
#define SIO4_ASYNC_USC_RX_CLK_RATE_64X		SIO4_USC_ASYNC_CLK_RATE_64X			// default

//*****************************************************************************
// sio4_async_t.usc.rx.clk_src				// USC CMCR D0-D2
// sio4_async_t_usc_rx_clk_src()
#define SIO4_ASYNC_USC_RX_CLK_SRC_DISABLE	SIO4_USC_CLK_SRC_DISABLE
#define SIO4_ASYNC_USC_RX_CLK_SRC_RXC_PIN	SIO4_USC_CLK_SRC_RXC_PIN			// default
#define SIO4_ASYNC_USC_RX_CLK_SRC_TXC_PIN	SIO4_USC_CLK_SRC_TXC_PIN
#define SIO4_ASYNC_USC_RX_CLK_SRC_DPLL		SIO4_USC_CLK_SRC_DPLL
#define SIO4_ASYNC_USC_RX_CLK_SRC_BRG0		SIO4_USC_CLK_SRC_BRG0
#define SIO4_ASYNC_USC_RX_CLK_SRC_BRG1		SIO4_USC_CLK_SRC_BRG1
#define SIO4_ASYNC_USC_RX_CLK_SRC_CTR0		SIO4_USC_CLK_SRC_CTR0
#define SIO4_ASYNC_USC_RX_CLK_SRC_CTR1		SIO4_USC_CLK_SRC_CTR1

//*****************************************************************************
// sio4_async_t.usc.rx.rxc					// PSRCR D3-D5, USC IOCR D0-D2
// sio4_async_t_usc_rx_rxc()
#define SIO4_ASYNC_USC_RX_RXC_IN_OSC		SIO4_USC_RXC_CFG_IN_OSC				// lower nibble: PSRCR D3-D5
#define SIO4_ASYNC_USC_RX_RXC_IN_OSC_INV	SIO4_USC_RXC_CFG_IN_OSC_INV			// upper nibble: USC IOCR D0-D2
#define SIO4_ASYNC_USC_RX_RXC_IN_0			SIO4_USC_RXC_CFG_IN_0
#define SIO4_ASYNC_USC_RX_RXC_IN_1			SIO4_USC_RXC_CFG_IN_1
#define SIO4_ASYNC_USC_RX_RXC_IN_CBL_RXC	SIO4_USC_RXC_CFG_IN_CBL_RXC			// default
#define SIO4_ASYNC_USC_RX_RXC_IN_CBL_RXAUX	SIO4_USC_RXC_CFG_IN_CBL_RXAUXC
#define SIO4_ASYNC_USC_RX_RXC_OUT_CLK		SIO4_USC_RXC_CFG_OUT_RX_CLK
#define SIO4_ASYNC_USC_RX_RXC_OUT_BYTE_CLK	SIO4_USC_RXC_CFG_OUT_RX_BYTE_CLK
#define SIO4_ASYNC_USC_RX_RXC_OUT_SYNC		SIO4_USC_RXC_CFG_OUT_SYNC
#define SIO4_ASYNC_USC_RX_RXC_OUT_BRG0		SIO4_USC_RXC_CFG_OUT_BRG0
#define SIO4_ASYNC_USC_RX_RXC_OUT_BRG1		SIO4_USC_RXC_CFG_OUT_BRG1
#define SIO4_ASYNC_USC_RX_RXC_OUT_CTR0		SIO4_USC_RXC_CFG_OUT_CTR0
#define SIO4_ASYNC_USC_RX_RXC_OUT_DPLL_RX	SIO4_USC_RXC_CFG_OUT_DPLL_RX

//*****************************************************************************
// sio4_async_t.usc.rx.rxc_legacy				USC IOCR D0-D2
// sio4_async_t_usc_rx_rxc_legacy()
#define SIO4_ASYNC_USC_RX_RXC_LEG_IN			SIO4_USC_RXC_LEG_IN				// legacy
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_CLK		SIO4_USC_RXC_LEG_OUT_RX_CLK
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_BYTE_CLK	SIO4_USC_RXC_LEG_OUT_RX_BYTE_CLK
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_SYNC		SIO4_USC_RXC_LEG_OUT_SYNC
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_BRG0		SIO4_USC_RXC_LEG_OUT_BRG0
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_BRG1		SIO4_USC_RXC_LEG_OUT_BRG1
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_CTR0		SIO4_USC_RXC_LEG_OUT_CTR0
#define SIO4_ASYNC_USC_RX_RXC_LEG_OUT_DPLL_RX	SIO4_USC_RXC_LEG_OUT_DPLL_RX

//*****************************************************************************
// sio4_async_t.usc.tx.clk_rate				// USC CMR D12-D13
// sio4_async_t_usc_tx_clk_rate()
#define SIO4_ASYNC_USC_TX_CLK_RATE_16X		SIO4_USC_ASYNC_CLK_RATE_16X
#define SIO4_ASYNC_USC_TX_CLK_RATE_32X		SIO4_USC_ASYNC_CLK_RATE_32X
#define SIO4_ASYNC_USC_TX_CLK_RATE_64X		SIO4_USC_ASYNC_CLK_RATE_64X			// default

//*****************************************************************************
// sio4_async_t.usc.tx.clk_src				// USC CMCR D3-D5
// sio4_async_t_usc_tx_clk_src()
#define SIO4_ASYNC_USC_TX_CLK_SRC_DISABLE	SIO4_USC_CLK_SRC_DISABLE
#define SIO4_ASYNC_USC_TX_CLK_SRC_RXC_PIN	SIO4_USC_CLK_SRC_RXC_PIN
#define SIO4_ASYNC_USC_TX_CLK_SRC_TXC_PIN	SIO4_USC_CLK_SRC_TXC_PIN			// default
#define SIO4_ASYNC_USC_TX_CLK_SRC_DPLL		SIO4_USC_CLK_SRC_DPLL
#define SIO4_ASYNC_USC_TX_CLK_SRC_BRG0		SIO4_USC_CLK_SRC_BRG0
#define SIO4_ASYNC_USC_TX_CLK_SRC_BRG1		SIO4_USC_CLK_SRC_BRG1
#define SIO4_ASYNC_USC_TX_CLK_SRC_CTR0		SIO4_USC_CLK_SRC_CTR0
#define SIO4_ASYNC_USC_TX_CLK_SRC_CTR1		SIO4_USC_CLK_SRC_CTR1

//*****************************************************************************
// sio4_async_t.usc.tx.stop_bits			// USC CMR D15-D15, USC CCR D8-D11
// sio4_async_t_usc_tx_stop_bits()
#define SIO4_ASYNC_USC_TX_STOP_BIT_1		SIO4_USC_ASYNC_TX_STOP_BIT_1		// default
#define SIO4_ASYNC_USC_TX_STOP_BIT_2		SIO4_USC_ASYNC_TX_STOP_BIT_2

#define SIO4_ASYNC_USC_TX_STOP_BIT_0__9_16	SIO4_USC_ASYNC_TX_STOP_BIT_0__9_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_0_10_16	SIO4_USC_ASYNC_TX_STOP_BIT_0_10_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_0_11_16	SIO4_USC_ASYNC_TX_STOP_BIT_0_11_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_0_12_16	SIO4_USC_ASYNC_TX_STOP_BIT_0_12_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_0_13_16	SIO4_USC_ASYNC_TX_STOP_BIT_0_13_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_0_14_16	SIO4_USC_ASYNC_TX_STOP_BIT_0_14_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_0_15_16	SIO4_USC_ASYNC_TX_STOP_BIT_0_15_16

#define SIO4_ASYNC_USC_TX_STOP_BIT_1__1_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__1_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__2_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__2_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__3_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__3_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__4_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__4_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__5_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__5_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__6_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__6_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__7_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__7_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__8_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__8_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1__9_16	SIO4_USC_ASYNC_TX_STOP_BIT_1__9_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1_10_16	SIO4_USC_ASYNC_TX_STOP_BIT_1_10_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1_11_16	SIO4_USC_ASYNC_TX_STOP_BIT_1_11_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1_12_16	SIO4_USC_ASYNC_TX_STOP_BIT_1_12_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1_13_16	SIO4_USC_ASYNC_TX_STOP_BIT_1_13_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1_14_16	SIO4_USC_ASYNC_TX_STOP_BIT_1_14_16
#define SIO4_ASYNC_USC_TX_STOP_BIT_1_15_16	SIO4_USC_ASYNC_TX_STOP_BIT_1_15_16

//*****************************************************************************
// sio4_async_t.usc.tx.txc					// PSRCR D0-D2, USC IOCR D3-D5
// sio4_async_t_usc_tx_txc()
#define SIO4_ASYNC_USC_TX_TXC_IN_OSC		SIO4_USC_TXC_CFG_IN_OSC				// Lower nibble: PSRCR D0-D2, default
#define SIO4_ASYNC_USC_TX_TXC_IN_OSC_INV	SIO4_USC_TXC_CFG_IN_OSC_INV			// Upper nibble: USC IOCR D3-D5
#define SIO4_ASYNC_USC_TX_TXC_IN_0			SIO4_USC_TXC_CFG_IN_0
#define SIO4_ASYNC_USC_TX_TXC_IN_1			SIO4_USC_TXC_CFG_IN_1
#define SIO4_ASYNC_USC_TX_TXC_IN_CBL_RXC	SIO4_USC_TXC_CFG_IN_CBL_RXC
#define SIO4_ASYNC_USC_TX_TXC_IN_CBL_RXAUX	SIO4_USC_TXC_CFG_IN_CBL_RXAUXC
#define SIO4_ASYNC_USC_TX_TXC_OUT_CLK		SIO4_USC_TXC_CFG_OUT_TX_CLK			// default
#define SIO4_ASYNC_USC_TX_TXC_OUT_BYTE_CLK	SIO4_USC_TXC_CFG_OUT_TX_BYTE_CLK
#define SIO4_ASYNC_USC_TX_TXC_OUT_COMP		SIO4_USC_TXC_CFG_OUT_TX_COMP
#define SIO4_ASYNC_USC_TX_TXC_OUT_BRG0		SIO4_USC_TXC_CFG_OUT_BRG0
#define SIO4_ASYNC_USC_TX_TXC_OUT_BRG1		SIO4_USC_TXC_CFG_OUT_BRG1
#define SIO4_ASYNC_USC_TX_TXC_OUT_CTR1		SIO4_USC_TXC_CFG_OUT_CTR1
#define SIO4_ASYNC_USC_TX_TXC_OUT_DPLL_TX	SIO4_USC_TXC_CFG_OUT_DPLL_TX

//*****************************************************************************
// sio4_async_t.usc.tx.txc_legacy				USC IOCR D3-D5
// sio4_async_t_usc_tx_txc_legacy()
#define SIO4_ASYNC_USC_TX_TXC_LEG_IN			SIO4_USC_TXC_LEG_IN
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_CLK		SIO4_USC_TXC_LEG_OUT_TX_CLK		// default
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_BYTE_CLK	SIO4_USC_TXC_LEG_OUT_TX_BYTE_CLK
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_COMP		SIO4_USC_TXC_LEG_OUT_TX_COMP
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_BRG0		SIO4_USC_TXC_LEG_OUT_BRG0
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_BRG1		SIO4_USC_TXC_LEG_OUT_BRG1
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_CTR1		SIO4_USC_TXC_LEG_OUT_CTR1
#define SIO4_ASYNC_USC_TX_TXC_LEG_OUT_DPLL_TX	SIO4_USC_TXC_LEG_OUT_DPLL_TX

//*****************************************************************************
// sio4_async_t.usc.txd						// USC IOCR D6-D7
// sio4_async_t_usc_txd()
#define SIO4_ASYNC_USC_TXD_OUT_TXD			SIO4_USC_TXD_CFG_OUT_TXD			// default
#define SIO4_ASYNC_USC_TXD_TRI				SIO4_USC_TXD_CFG_TRI
#define SIO4_ASYNC_USC_TXD_OUT_0			SIO4_USC_TXD_CFG_OUT_0
#define SIO4_ASYNC_USC_TXD_OUT_1			SIO4_USC_TXD_CFG_OUT_1



// data types *****************************************************************

typedef enum
{
	SIO4_ASYNC_ACTION_GET,
	SIO4_ASYNC_ACTION_INIT,
	SIO4_ASYNC_ACTION_SET,
	SIO4_ASYNC_ACTION_SHOW,
	SIO4_ASYNC_ACTION_VERIFY
} sio4_async_action_t;

typedef struct
{
	// All fields must be filled in before calling sio4_async_init().
	s32			tx_bit_rate;
	s32			rx_bit_rate;
	s32			osc_prog;
} sio4_async_init_t;

typedef struct
{
	// All fields are filled in by the library when calling
	// sio4_async_init(). Application mods must be made before calling
	// sio4_async_set().

	struct
	{
		s32		ref;
		s32		prog;
	} osc;

	struct
	{
		s32		enable;		// PSRCR D31
		s32		mode;		// PSRCR D28, DCE or DTE
		s32		protocol;	// PSRSR D24-D27
		s32		txc;		// PSRCR D6-D8
		s32		txd;		// PSRCR D19-D20
		s32		txaux;		// PSRCR D17-D18
		s32		dcd;		// PSRCR D15-D16
		s32		dtr_dsr;	// PSRCR D21-D22
		s32		rts;		// PSRCR D13-D14

		struct	// cable
		{
			s32	mode;		// PSRCR D23, D29
		} loopback;

		struct
		{
			s32	enable;		// PSRCR D30
		} term;

		struct
		{
			s32	txc;		// CCR 0x3333
			s32	txd_cts;	// CSR D2-D3
			s32	rxc;		// CCR 0xCCCC
			s32	rxd_dcd;	// CSR D4-D5
		} legacy;

	} cable;

	struct	// tx
	{
		s32		mode;		// USC CMR D8-D11
		s32		enable;		// USC TMR D0-D1
		s32		char_len;	// USC TMR D2-D4
		s32		encoding;	// USC TMR D13-D15
		s32		bit_rate;	// reflects sio4_async_init_t.tx_bit_rate
		s32		idle_cond;	// USC TCSR D8-D10

		struct
		{
			s32	enable;		// USC TMR D5
			s32	type;		// USC TMR D6-D7
		} parity;

		struct
		{
			s32	size;		// FSR D0-D15, read-only
			s32	ae;			// TAR D0-D15
			s32	af;			// TAR D16-D31
			s32	empty_cfg;	// CSR D18, D26
			s32	space_cfg;	// CSR D4-D5
		} fifo;

		struct
		{
			s32	mode;
			s32	pio_thresh;
			s32	timeout;
			s32	overrun;
		} io;

	} tx;

	struct	// rx
	{
		s32		mode;		// USC CMR D0-D3
		s32		enable;		// USC RMR D0-D1
		s32		char_len;	// USC RMR D2-D4
		s32		encoding;	// USC RMR D13-D15
		s32		bit_rate;	// reflects sio4_async_init_t.rx_bit_rate
		s32		sync_byte;	// SBR D0-D7
		s32		status_word;// CSR D3

		struct
		{
			s32	enable;		// USC RMR D5
			s32	type;		// USC RMR D6-D7
		} parity;

		struct
		{
			s32	size;		// FSR D16-D21, read-only
			s32	ae;			// RAR D0-D15
			s32	af;			// RAR D16-D31
			s32	full_cfg;	// BCR D8
		} fifo;

		struct
		{
			s32	mode;
			s32	pio_thresh;
			s32	timeout;
			s32	overrun;
			s32	underrun;
		} io;

		struct
		{
			s32	enable;		// CSR D2
			s32	clk_src;	// BCR D22
		} time_stamp;

	} rx;

	struct	// usc
	{
		s32		mode;		// USC CCAR D8-D9
		s32		txd;		// USC IOCR D6-D7
		s32		cts;		// PSRCR D9-D10, USC IOCR D14-D15
		s32		cts_legacy;	// USC IOCR D14-D15
		s32		dcd;		// PSRCR D11-D12, USC IOCR D12-D13
		s32		dcd_legacy;	// USC IOCR D12-D13

		// All of the folling USC fields are initialized
		// by sio4_async_init() based on the content of the
		// sio4_async_init_t structure.

		struct
		{
			s32	clk_rate;	// USC CMR D4-D5
			s32	clk_src;	// USC CMCR D3-D5
			s32	txc;		// PSRCR D0-D2, USC IOCR D3-D5
			s32	txc_legacy;	// USC IOCR D3-D5
			s32	stop_bits;	// USC CMR D14
		} tx;

		struct
		{
			s32	clk_rate;	// USC CMR D12-D13
			s32	clk_src;	// USC CMCR D0-D2
			s32	rxc;		// PSRCR D3-D5, USC IOCR D0-D2
			s32	rxc_legacy;	// USC IOCR D0-D2
		} rx;

		struct
		{
			s32	enable;		// USC HCR D0
			s32	clk_src;	// USC CMCR D8-D9
			s32	divider;	// USC TC1R D0-D15
			s32	mode;		// USC HCR D1
		} brg0;

		struct
		{
			s32	enable;		// USC HCR D4
			s32	clk_src;	// USC CMCR D10-D11
			s32	divider;	// USC TC0R D0-D15
			s32	mode;		// USC HCR D5
		} brg1;

		struct
		{
			s32	clk_src;	// USC CMCR D12-D13
			s32	rate;		// USC HCR D14-D15
		} ctr0;

		struct
		{
			s32	clk_src;	// USC CMCR D14-D15
			s32	rate_src;	// USC HCR D13, ...
		} ctr1;

		struct
		{
			s32	rate;		// USC HCR D10-D11
		} dpll;

	} usc;

} sio4_async_t;



// prototypes *****************************************************************

// High level functions.

int		sio4_async_lib_init(void);												// returns 0 or -errno
int		sio4_async_version(const char** version, const char** built);			// returns 0 or -errno

int		sio4_async_open(int index);												// returns >= 0 or -errno
int		sio4_async_close(int fd);												// returns 0 or -errno
int		sio4_async_ioctl(int fd, int cmd, void* arg);							// returns 0 or -errno

int		sio4_async_init(int fd, const sio4_async_init_t* init, sio4_async_t* async, const char** err);	// returns 0 or -errno
int		sio4_async_get(int fd, sio4_async_t* async, const char** err);			// returns 0 or -errno
int		sio4_async_set(int fd, const sio4_async_t* async, const char** err);	// returns 0 or -errno
int		sio4_async_show(int fd, const sio4_async_t* async, const char** err);	// returns 0 or -errno

int		sio4_async_read(int fd, void* buf, size_t size);						// returns >= 0 or -errno
int		sio4_async_write(int fd, const void* buf, size_t size);					// returns >= 0 or -errno

// Low level functions.

void	sio4_async_t_cable_dcd				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_dtr_dsr			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_enable			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_legacy_rxc		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_legacy_rxd_dcd	(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_legacy_txc		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_legacy_txd_cts	(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_loopback_mode	(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_mode				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_protocol			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_rts				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_term_enable		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_txaux			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_txc				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_cable_txd				(int fd, s32* arg, sio4_async_action_t action, const char** err);

void	sio4_async_t_osc_prog				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_osc_ref				(int fd, s32* arg, sio4_async_action_t action, const char** err);

void	sio4_async_t_rx_bit_rate			(		 s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_char_len			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_enable				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_encoding			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_fifo_ae				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_fifo_af				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_fifo_full_cfg		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_fifo_size			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_io_mode				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_io_overrun			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_io_pio_thresh		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_io_timeout			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_io_underrun			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_mode				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_parity_enable		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_parity_type			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_status_word			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_sync_byte			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_time_stamp_clk_src	(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_rx_time_stamp_enable	(int fd, s32* arg, sio4_async_action_t action, const char** err);

void	sio4_async_t_tx_bit_rate			(		 s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_char_len			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_enable				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_encoding			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_fifo_ae				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_fifo_af				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_fifo_empty_cfg		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_fifo_size			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_fifo_space_cfg		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_idle_cond			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_io_mode				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_io_overrun			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_io_pio_thresh		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_io_timeout			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_mode				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_parity_enable		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_tx_parity_type			(int fd, s32* arg, sio4_async_action_t action, const char** err);

void	sio4_async_t_usc_brg0_clk_src		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg0_divider		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg0_enable		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg0_mode			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg1_clk_src		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg1_divider		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg1_enable		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_brg1_mode			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_ctr0_clk_src		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_ctr0_rate			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_ctr1_clk_src		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_ctr1_rate_src		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_cts				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_cts_legacy			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_dcd				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_dcd_legacy			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_dpll_rate			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_mode				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_rx_clk_rate		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_rx_clk_src			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_rx_rxc				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_rx_rxc_legacy		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_tx_clk_rate		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_tx_clk_src			(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_tx_stop_bits		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_tx_txc				(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_tx_txc_legacy		(int fd, s32* arg, sio4_async_action_t action, const char** err);
void	sio4_async_t_usc_txd				(int fd, s32* arg, sio4_async_action_t action, const char** err);



#endif
